/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.ConfiguratonFileWatcher;
import org.apache.logging.log4j.core.config.Node;
import org.apache.logging.log4j.core.config.Reconfigurable;
import org.apache.logging.log4j.core.config.plugins.util.PluginType;
import org.apache.logging.log4j.core.config.plugins.util.ResolverUtil;
import org.apache.logging.log4j.core.config.status.StatusConfiguration;
import org.apache.logging.log4j.core.util.Patterns;

public class JsonConfiguration
extends AbstractConfiguration
implements Reconfigurable {
    private static final String[] VERBOSE_CLASSES = new String[]{ResolverUtil.class.getName()};
    private final List<Status> status = new ArrayList<Status>();
    private JsonNode root;

    public JsonConfiguration(LoggerContext loggerContext, ConfigurationSource configSource) {
        super(loggerContext, configSource);
        File configFile = configSource.getFile();
        try {
            byte[] buffer;
            try (InputStream configStream = configSource.getInputStream();){
                buffer = JsonConfiguration.toByteArray(configStream);
            }
            ByteArrayInputStream is = new ByteArrayInputStream(buffer);
            this.root = this.getObjectMapper().readTree((InputStream)is);
            if (this.root.size() == 1) {
                Iterator i$ = this.root.iterator();
                while (i$.hasNext()) {
                    JsonNode node;
                    this.root = node = (JsonNode)i$.next();
                }
            }
            this.processAttributes(this.rootNode, this.root);
            StatusConfiguration statusConfig = new StatusConfiguration().withVerboseClasses(VERBOSE_CLASSES).withStatus(this.getDefaultStatus());
            for (Map.Entry<String, String> entry : this.rootNode.getAttributes().entrySet()) {
                String key2 = entry.getKey();
                String value2 = this.getStrSubstitutor().replace(entry.getValue());
                if ("status".equalsIgnoreCase(key2)) {
                    statusConfig.withStatus(value2);
                    continue;
                }
                if ("dest".equalsIgnoreCase(key2)) {
                    statusConfig.withDestination(value2);
                    continue;
                }
                if ("shutdownHook".equalsIgnoreCase(key2)) {
                    this.isShutdownHookEnabled = !"disable".equalsIgnoreCase(value2);
                    continue;
                }
                if ("shutdownTimeout".equalsIgnoreCase(key2)) {
                    this.shutdownTimeoutMillis = Long.parseLong(value2);
                    continue;
                }
                if ("verbose".equalsIgnoreCase(entry.getKey())) {
                    statusConfig.withVerbosity(value2);
                    continue;
                }
                if ("packages".equalsIgnoreCase(key2)) {
                    this.pluginPackages.addAll(Arrays.asList(value2.split(Patterns.COMMA_SEPARATOR)));
                    continue;
                }
                if ("name".equalsIgnoreCase(key2)) {
                    this.setName(value2);
                    continue;
                }
                if ("monitorInterval".equalsIgnoreCase(key2)) {
                    int intervalSeconds = Integer.parseInt(value2);
                    if (intervalSeconds <= 0) continue;
                    this.getWatchManager().setIntervalSeconds(intervalSeconds);
                    if (configFile == null) continue;
                    ConfiguratonFileWatcher watcher = new ConfiguratonFileWatcher(this, this.listeners);
                    this.getWatchManager().watchFile(configFile, watcher);
                    continue;
                }
                if (!"advertiser".equalsIgnoreCase(key2)) continue;
                this.createAdvertiser(value2, configSource, buffer, "application/json");
            }
            statusConfig.initialize();
            if (this.getName() == null) {
                this.setName(configSource.getLocation());
            }
        }
        catch (Exception ex) {
            LOGGER.error("Error parsing " + configSource.getLocation(), (Throwable)ex);
        }
    }

    protected ObjectMapper getObjectMapper() {
        return new ObjectMapper().configure(JsonParser.Feature.ALLOW_COMMENTS, true);
    }

    @Override
    public void setup() {
        Iterator iter = this.root.fields();
        List<Node> children = this.rootNode.getChildren();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            JsonNode n = (JsonNode)entry.getValue();
            if (n.isObject()) {
                LOGGER.debug("Processing node for object {}", entry.getKey());
                children.add(this.constructNode((String)entry.getKey(), this.rootNode, n));
                continue;
            }
            if (!n.isArray()) continue;
            LOGGER.error("Arrays are not supported at the root configuration.");
        }
        LOGGER.debug("Completed parsing configuration");
        if (this.status.size() > 0) {
            for (Status s : this.status) {
                LOGGER.error("Error processing element {}: {}", (Object)s.name, (Object)s.errorType);
            }
        }
    }

    @Override
    public Configuration reconfigure() {
        try {
            ConfigurationSource source2 = this.getConfigurationSource().resetInputStream();
            if (source2 == null) {
                return null;
            }
            return new JsonConfiguration(this.getLoggerContext(), source2);
        }
        catch (IOException ex) {
            LOGGER.error("Cannot locate file {}", (Object)this.getConfigurationSource(), (Object)ex);
            return null;
        }
    }

    private Node constructNode(String name2, Node parent2, JsonNode jsonNode) {
        PluginType<?> type = this.pluginManager.getPluginType(name2);
        Node node = new Node(parent2, name2, type);
        this.processAttributes(node, jsonNode);
        Iterator iter = jsonNode.fields();
        List<Node> children = node.getChildren();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            JsonNode n = (JsonNode)entry.getValue();
            if (n.isArray() || n.isObject()) {
                if (type == null) {
                    this.status.add(new Status(name2, n, ErrorType.CLASS_NOT_FOUND));
                }
                if (n.isArray()) {
                    LOGGER.debug("Processing node for array {}", entry.getKey());
                    for (int i = 0; i < n.size(); ++i) {
                        String pluginType = this.getType(n.get(i), (String)entry.getKey());
                        PluginType<?> entryType = this.pluginManager.getPluginType(pluginType);
                        Node item = new Node(node, (String)entry.getKey(), entryType);
                        this.processAttributes(item, n.get(i));
                        if (pluginType.equals(entry.getKey())) {
                            LOGGER.debug("Processing {}[{}]", entry.getKey(), (Object)i);
                        } else {
                            LOGGER.debug("Processing {} {}[{}]", (Object)pluginType, entry.getKey(), (Object)i);
                        }
                        Iterator itemIter = n.get(i).fields();
                        List<Node> itemChildren = item.getChildren();
                        while (itemIter.hasNext()) {
                            Map.Entry itemEntry = (Map.Entry)itemIter.next();
                            if (((JsonNode)itemEntry.getValue()).isObject()) {
                                LOGGER.debug("Processing node for object {}", itemEntry.getKey());
                                itemChildren.add(this.constructNode((String)itemEntry.getKey(), item, (JsonNode)itemEntry.getValue()));
                                continue;
                            }
                            if (!((JsonNode)itemEntry.getValue()).isArray()) continue;
                            JsonNode array = (JsonNode)itemEntry.getValue();
                            String entryName = (String)itemEntry.getKey();
                            LOGGER.debug("Processing array for object {}", (Object)entryName);
                            for (int j = 0; j < array.size(); ++j) {
                                itemChildren.add(this.constructNode(entryName, item, array.get(j)));
                            }
                        }
                        children.add(item);
                    }
                    continue;
                }
                LOGGER.debug("Processing node for object {}", entry.getKey());
                children.add(this.constructNode((String)entry.getKey(), node, n));
                continue;
            }
            LOGGER.debug("Node {} is of type {}", entry.getKey(), (Object)n.getNodeType());
        }
        String t = type == null ? "null" : type.getElementName() + ':' + type.getPluginClass();
        String p = node.getParent() == null ? "null" : (node.getParent().getName() == null ? "root" : node.getParent().getName());
        LOGGER.debug("Returning {} with parent {} of type {}", (Object)node.getName(), (Object)p, (Object)t);
        return node;
    }

    private String getType(JsonNode node, String name2) {
        Iterator iter = node.fields();
        while (iter.hasNext()) {
            JsonNode n;
            Map.Entry entry = (Map.Entry)iter.next();
            if (!((String)entry.getKey()).equalsIgnoreCase("type") || !(n = (JsonNode)entry.getValue()).isValueNode()) continue;
            return n.asText();
        }
        return name2;
    }

    private void processAttributes(Node parent2, JsonNode node) {
        Map<String, String> attrs = parent2.getAttributes();
        Iterator iter = node.fields();
        while (iter.hasNext()) {
            JsonNode n;
            Map.Entry entry = (Map.Entry)iter.next();
            if (((String)entry.getKey()).equalsIgnoreCase("type") || !(n = (JsonNode)entry.getValue()).isValueNode()) continue;
            attrs.put((String)entry.getKey(), n.asText());
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[location=" + this.getConfigurationSource() + "]";
    }

    private static class Status {
        private final JsonNode node;
        private final String name;
        private final ErrorType errorType;

        public Status(String name2, JsonNode node, ErrorType errorType) {
            this.name = name2;
            this.node = node;
            this.errorType = errorType;
        }

        public String toString() {
            return "Status [name=" + this.name + ", errorType=" + (Object)((Object)this.errorType) + ", node=" + this.node + "]";
        }
    }

    private static enum ErrorType {
        CLASS_NOT_FOUND;

    }
}

