/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.properties;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.AppenderRefComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.FilterComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.FilterableComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LoggableComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ScriptComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ScriptFileComponentBuilder;
import org.apache.logging.log4j.core.config.properties.PropertiesConfiguration;
import org.apache.logging.log4j.core.util.Builder;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.Strings;

public class PropertiesConfigurationBuilder
extends ConfigurationBuilderFactory
implements Builder<PropertiesConfiguration> {
    private static final String ADVERTISER_KEY = "advertiser";
    private static final String STATUS_KEY = "status";
    private static final String SHUTDOWN_HOOK = "shutdownHook";
    private static final String SHUTDOWN_TIMEOUT = "shutdownTimeout";
    private static final String VERBOSE = "verbose";
    private static final String DEST = "dest";
    private static final String PACKAGES = "packages";
    private static final String CONFIG_NAME = "name";
    private static final String MONITOR_INTERVAL = "monitorInterval";
    private static final String CONFIG_TYPE = "type";
    private final ConfigurationBuilder<PropertiesConfiguration> builder = PropertiesConfigurationBuilder.newConfigurationBuilder(PropertiesConfiguration.class);
    private LoggerContext loggerContext;
    private Properties rootProperties;

    public PropertiesConfigurationBuilder setRootProperties(Properties rootProperties) {
        this.rootProperties = rootProperties;
        return this;
    }

    public PropertiesConfigurationBuilder setConfigurationSource(ConfigurationSource source2) {
        this.builder.setConfigurationSource(source2);
        return this;
    }

    @Override
    public PropertiesConfiguration build() {
        Properties props2;
        String loggerProp;
        String appenderProp;
        String name2;
        String filterProp;
        for (String key2 : this.rootProperties.stringPropertyNames()) {
            if (key2.contains(".")) continue;
            this.builder.addRootProperty(key2, this.rootProperties.getProperty(key2));
        }
        this.builder.setStatusLevel(Level.toLevel(this.rootProperties.getProperty(STATUS_KEY), Level.ERROR)).setShutdownHook(this.rootProperties.getProperty(SHUTDOWN_HOOK)).setShutdownTimeout(Long.parseLong(this.rootProperties.getProperty(SHUTDOWN_TIMEOUT, "0")), TimeUnit.MILLISECONDS).setVerbosity(this.rootProperties.getProperty(VERBOSE)).setDestination(this.rootProperties.getProperty(DEST)).setPackages(this.rootProperties.getProperty(PACKAGES)).setConfigurationName(this.rootProperties.getProperty(CONFIG_NAME)).setMonitorInterval(this.rootProperties.getProperty(MONITOR_INTERVAL, "0")).setAdvertiser(this.rootProperties.getProperty(ADVERTISER_KEY));
        Properties propertyPlaceholders = PropertiesUtil.extractSubset(this.rootProperties, "property");
        for (String key3 : propertyPlaceholders.stringPropertyNames()) {
            this.builder.addProperty(key3, propertyPlaceholders.getProperty(key3));
        }
        Map<String, Properties> scripts = PropertiesUtil.partitionOnCommonPrefixes(PropertiesUtil.extractSubset(this.rootProperties, "script"));
        for (Map.Entry<String, Properties> entry : scripts.entrySet()) {
            Properties scriptProps = entry.getValue();
            String type = (String)scriptProps.remove(CONFIG_TYPE);
            if (type == null) {
                throw new ConfigurationException("No type provided for script - must be Script or ScriptFile");
            }
            if (type.equalsIgnoreCase("script")) {
                this.builder.add(this.createScript(scriptProps));
                continue;
            }
            this.builder.add(this.createScriptFile(scriptProps));
        }
        Properties levelProps = PropertiesUtil.extractSubset(this.rootProperties, "customLevel");
        if (levelProps.size() > 0) {
            for (String key4 : levelProps.stringPropertyNames()) {
                this.builder.add(this.builder.newCustomLevel(key4, Integer.parseInt(levelProps.getProperty(key4))));
            }
        }
        if ((filterProp = this.rootProperties.getProperty("filters")) != null) {
            String[] filterNames;
            for (String filterName : filterNames = filterProp.split(",")) {
                name2 = filterName.trim();
                this.builder.add(this.createFilter(name2, PropertiesUtil.extractSubset(this.rootProperties, "filter." + name2)));
            }
        } else {
            Map<String, Properties> filters = PropertiesUtil.partitionOnCommonPrefixes(PropertiesUtil.extractSubset(this.rootProperties, "filter"));
            for (Map.Entry<String, Properties> entry : filters.entrySet()) {
                this.builder.add(this.createFilter(entry.getKey().trim(), entry.getValue()));
            }
        }
        if ((appenderProp = this.rootProperties.getProperty("appenders")) != null) {
            String[] appenderNames;
            for (String appenderName : appenderNames = appenderProp.split(",")) {
                String name3 = appenderName.trim();
                this.builder.add(this.createAppender(appenderName.trim(), PropertiesUtil.extractSubset(this.rootProperties, "appender." + name3)));
            }
        } else {
            Map<String, Properties> appenders = PropertiesUtil.partitionOnCommonPrefixes(PropertiesUtil.extractSubset(this.rootProperties, "appender"));
            for (Map.Entry<String, Properties> entry : appenders.entrySet()) {
                this.builder.add(this.createAppender(entry.getKey().trim(), entry.getValue()));
            }
        }
        if ((loggerProp = this.rootProperties.getProperty("loggers")) != null) {
            String[] loggerNames;
            for (String loggerName : loggerNames = loggerProp.split(",")) {
                String name4 = loggerName.trim();
                if (name4.equals("root")) continue;
                this.builder.add(this.createLogger(name4, PropertiesUtil.extractSubset(this.rootProperties, "logger." + name4)));
            }
        } else {
            Map<String, Properties> loggers = PropertiesUtil.partitionOnCommonPrefixes(PropertiesUtil.extractSubset(this.rootProperties, "logger"));
            for (Map.Entry<String, Properties> entry : loggers.entrySet()) {
                name2 = entry.getKey().trim();
                if (name2.equals("root")) continue;
                this.builder.add(this.createLogger(name2, entry.getValue()));
            }
        }
        if ((props2 = PropertiesUtil.extractSubset(this.rootProperties, "rootLogger")).size() > 0) {
            this.builder.add(this.createRootLogger(props2));
        }
        this.builder.setLoggerContext(this.loggerContext);
        return this.builder.build(false);
    }

    private ScriptComponentBuilder createScript(Properties properties2) {
        String name2 = (String)properties2.remove(CONFIG_NAME);
        String language = (String)properties2.remove("language");
        String text2 = (String)properties2.remove("text");
        ScriptComponentBuilder scriptBuilder = this.builder.newScript(name2, language, text2);
        return PropertiesConfigurationBuilder.processRemainingProperties(scriptBuilder, properties2);
    }

    private ScriptFileComponentBuilder createScriptFile(Properties properties2) {
        String name2 = (String)properties2.remove(CONFIG_NAME);
        String path = (String)properties2.remove("path");
        ScriptFileComponentBuilder scriptFileBuilder = this.builder.newScriptFile(name2, path);
        return PropertiesConfigurationBuilder.processRemainingProperties(scriptFileBuilder, properties2);
    }

    private AppenderComponentBuilder createAppender(String key2, Properties properties2) {
        String name2 = (String)properties2.remove(CONFIG_NAME);
        if (Strings.isEmpty(name2)) {
            throw new ConfigurationException("No name attribute provided for Appender " + key2);
        }
        String type = (String)properties2.remove(CONFIG_TYPE);
        if (Strings.isEmpty(type)) {
            throw new ConfigurationException("No type attribute provided for Appender " + key2);
        }
        AppenderComponentBuilder appenderBuilder = this.builder.newAppender(name2, type);
        this.addFiltersToComponent(appenderBuilder, properties2);
        Properties layoutProps = PropertiesUtil.extractSubset(properties2, "layout");
        if (layoutProps.size() > 0) {
            appenderBuilder.add(this.createLayout(name2, layoutProps));
        }
        return PropertiesConfigurationBuilder.processRemainingProperties(appenderBuilder, properties2);
    }

    private FilterComponentBuilder createFilter(String key2, Properties properties2) {
        String type = (String)properties2.remove(CONFIG_TYPE);
        if (Strings.isEmpty(type)) {
            throw new ConfigurationException("No type attribute provided for Appender " + key2);
        }
        String onMatch = (String)properties2.remove("onMatch");
        String onMismatch = (String)properties2.remove("onMismatch");
        FilterComponentBuilder filterBuilder = this.builder.newFilter(type, onMatch, onMismatch);
        return PropertiesConfigurationBuilder.processRemainingProperties(filterBuilder, properties2);
    }

    private AppenderRefComponentBuilder createAppenderRef(String key2, Properties properties2) {
        String ref = (String)properties2.remove("ref");
        if (Strings.isEmpty(ref)) {
            throw new ConfigurationException("No ref attribute provided for AppenderRef " + key2);
        }
        AppenderRefComponentBuilder appenderRefBuilder = this.builder.newAppenderRef(ref);
        String level = Strings.trimToNull((String)properties2.remove("level"));
        if (!Strings.isEmpty(level)) {
            appenderRefBuilder.addAttribute("level", level);
        }
        return this.addFiltersToComponent(appenderRefBuilder, properties2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LoggerComponentBuilder createLogger(String key2, Properties properties2) {
        LoggerComponentBuilder loggerBuilder;
        String name2 = (String)properties2.remove(CONFIG_NAME);
        String location = (String)properties2.remove("includeLocation");
        if (Strings.isEmpty(name2)) {
            throw new ConfigurationException("No name attribute provided for Logger " + key2);
        }
        String level = Strings.trimToNull((String)properties2.remove("level"));
        String type = (String)properties2.remove(CONFIG_TYPE);
        if (type != null) {
            if (!type.equalsIgnoreCase("asyncLogger")) throw new ConfigurationException("Unknown Logger type " + type + " for Logger " + name2);
            if (location != null) {
                boolean includeLocation = Boolean.parseBoolean(location);
                loggerBuilder = this.builder.newAsyncLogger(name2, level, includeLocation);
            } else {
                loggerBuilder = this.builder.newAsyncLogger(name2, level);
            }
        } else if (location != null) {
            boolean includeLocation = Boolean.parseBoolean(location);
            loggerBuilder = this.builder.newLogger(name2, level, includeLocation);
        } else {
            loggerBuilder = this.builder.newLogger(name2, level);
        }
        this.addLoggersToComponent(loggerBuilder, properties2);
        this.addFiltersToComponent(loggerBuilder, properties2);
        String additivity = (String)properties2.remove("additivity");
        if (Strings.isEmpty(additivity)) return loggerBuilder;
        loggerBuilder.addAttribute("additivity", additivity);
        return loggerBuilder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RootLoggerComponentBuilder createRootLogger(Properties properties2) {
        RootLoggerComponentBuilder loggerBuilder;
        String level = Strings.trimToNull((String)properties2.remove("level"));
        String type = (String)properties2.remove(CONFIG_TYPE);
        String location = (String)properties2.remove("includeLocation");
        if (type != null) {
            if (!type.equalsIgnoreCase("asyncRoot")) throw new ConfigurationException("Unknown Logger type for root logger" + type);
            if (location != null) {
                boolean includeLocation = Boolean.parseBoolean(location);
                loggerBuilder = this.builder.newAsyncRootLogger(level, includeLocation);
            } else {
                loggerBuilder = this.builder.newAsyncRootLogger(level);
            }
        } else if (location != null) {
            boolean includeLocation = Boolean.parseBoolean(location);
            loggerBuilder = this.builder.newRootLogger(level, includeLocation);
        } else {
            loggerBuilder = this.builder.newRootLogger(level);
        }
        this.addLoggersToComponent(loggerBuilder, properties2);
        return this.addFiltersToComponent(loggerBuilder, properties2);
    }

    private LayoutComponentBuilder createLayout(String appenderName, Properties properties2) {
        String type = (String)properties2.remove(CONFIG_TYPE);
        if (Strings.isEmpty(type)) {
            throw new ConfigurationException("No type attribute provided for Layout on Appender " + appenderName);
        }
        LayoutComponentBuilder layoutBuilder = this.builder.newLayout(type);
        return PropertiesConfigurationBuilder.processRemainingProperties(layoutBuilder, properties2);
    }

    private static <B extends ComponentBuilder<B>> ComponentBuilder<B> createComponent(ComponentBuilder<?> parent2, String key2, Properties properties2) {
        String name2 = (String)properties2.remove(CONFIG_NAME);
        String type = (String)properties2.remove(CONFIG_TYPE);
        if (Strings.isEmpty(type)) {
            throw new ConfigurationException("No type attribute provided for component " + key2);
        }
        ComponentBuilder componentBuilder = parent2.getBuilder().newComponent(name2, type);
        return PropertiesConfigurationBuilder.processRemainingProperties(componentBuilder, properties2);
    }

    private static <B extends ComponentBuilder<?>> B processRemainingProperties(B builder, Properties properties2) {
        while (properties2.size() > 0) {
            String propertyName = properties2.stringPropertyNames().iterator().next();
            int index2 = propertyName.indexOf(46);
            if (index2 > 0) {
                String prefix = propertyName.substring(0, index2);
                Properties componentProperties = PropertiesUtil.extractSubset(properties2, prefix);
                builder.addComponent(PropertiesConfigurationBuilder.createComponent(builder, prefix, componentProperties));
                continue;
            }
            builder.addAttribute(propertyName, properties2.getProperty(propertyName));
            properties2.remove(propertyName);
        }
        return builder;
    }

    private <B extends FilterableComponentBuilder<? extends ComponentBuilder<?>>> B addFiltersToComponent(B componentBuilder, Properties properties2) {
        Map<String, Properties> filters = PropertiesUtil.partitionOnCommonPrefixes(PropertiesUtil.extractSubset(properties2, "filter"));
        for (Map.Entry<String, Properties> entry : filters.entrySet()) {
            componentBuilder.add(this.createFilter(entry.getKey().trim(), entry.getValue()));
        }
        return componentBuilder;
    }

    private <B extends LoggableComponentBuilder<? extends ComponentBuilder<?>>> B addLoggersToComponent(B loggerBuilder, Properties properties2) {
        Map<String, Properties> appenderRefs = PropertiesUtil.partitionOnCommonPrefixes(PropertiesUtil.extractSubset(properties2, "appenderRef"));
        for (Map.Entry<String, Properties> entry : appenderRefs.entrySet()) {
            loggerBuilder.add(this.createAppenderRef(entry.getKey().trim(), entry.getValue()));
        }
        return loggerBuilder;
    }

    public PropertiesConfigurationBuilder setLoggerContext(LoggerContext loggerContext) {
        this.loggerContext = loggerContext;
        return this;
    }

    public LoggerContext getLoggerContext() {
        return this.loggerContext;
    }
}

