/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class StringEncoder {
    private StringEncoder() {
    }

    public static byte[] toBytes(String str2, Charset charset) {
        if (str2 != null) {
            if (StandardCharsets.ISO_8859_1.equals(charset)) {
                return StringEncoder.encodeSingleByteChars(str2);
            }
            Charset actual2 = charset != null ? charset : Charset.defaultCharset();
            try {
                return str2.getBytes(actual2.name());
            }
            catch (UnsupportedEncodingException e) {
                return str2.getBytes(actual2);
            }
        }
        return null;
    }

    public static byte[] encodeSingleByteChars(CharSequence s) {
        int length2 = s.length();
        byte[] result = new byte[length2];
        StringEncoder.encodeString(s, 0, length2, result);
        return result;
    }

    public static int encodeIsoChars(CharSequence charArray, int charIndex, byte[] byteArray, int byteIndex, int length2) {
        char c;
        int i;
        for (i = 0; i < length2 && (c = charArray.charAt(charIndex++)) <= '\u00ff'; ++i) {
            byteArray[byteIndex++] = (byte)c;
        }
        return i;
    }

    public static int encodeString(CharSequence charArray, int charOffset, int charLength, byte[] byteArray) {
        int byteOffset = 0;
        int length2 = Math.min(charLength, byteArray.length);
        int charDoneIndex = charOffset + length2;
        while (charOffset < charDoneIndex) {
            char c;
            int done = StringEncoder.encodeIsoChars(charArray, charOffset, byteArray, byteOffset, length2);
            charOffset += done;
            byteOffset += done;
            if (done == length2) continue;
            if (Character.isHighSurrogate(c = charArray.charAt(charOffset++)) && charOffset < charDoneIndex && Character.isLowSurrogate(charArray.charAt(charOffset))) {
                if (charLength > byteArray.length) {
                    ++charDoneIndex;
                    --charLength;
                }
                ++charOffset;
            }
            byteArray[byteOffset++] = 63;
            length2 = Math.min(charDoneIndex - charOffset, byteArray.length - byteOffset);
        }
        return byteOffset;
    }
}

