/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.message.AsynchronouslyFormattable;
import org.apache.logging.log4j.message.ParameterFormatter;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.EnglishEnums;
import org.apache.logging.log4j.util.IndexedReadOnlyStringMap;
import org.apache.logging.log4j.util.IndexedStringMap;
import org.apache.logging.log4j.util.MultiFormatStringBuilderFormattable;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.apache.logging.log4j.util.SortedArrayStringMap;
import org.apache.logging.log4j.util.StringBuilders;
import org.apache.logging.log4j.util.TriConsumer;

@AsynchronouslyFormattable
@PerformanceSensitive(value={"allocation"})
public class MapMessage<M extends MapMessage<M, V>, V>
implements MultiFormatStringBuilderFormattable {
    private static final long serialVersionUID = -5031471831131487120L;
    private final IndexedStringMap data;

    public MapMessage() {
        this.data = new SortedArrayStringMap();
    }

    public MapMessage(int initialCapacity) {
        this.data = new SortedArrayStringMap(initialCapacity);
    }

    public MapMessage(Map<String, V> map23) {
        this.data = new SortedArrayStringMap(map23);
    }

    @Override
    public String[] getFormats() {
        return MapFormat.names();
    }

    @Override
    public Object[] getParameters() {
        Object[] result = new Object[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            result[i] = this.data.getValueAt(i);
        }
        return result;
    }

    @Override
    public String getFormat() {
        return "";
    }

    public Map<String, V> getData() {
        TreeMap result = new TreeMap();
        for (int i = 0; i < this.data.size(); ++i) {
            result.put(this.data.getKeyAt(i), this.data.getValueAt(i));
        }
        return Collections.unmodifiableMap(result);
    }

    public IndexedReadOnlyStringMap getIndexedReadOnlyStringMap() {
        return this.data;
    }

    public void clear() {
        this.data.clear();
    }

    public boolean containsKey(String key2) {
        return this.data.containsKey(key2);
    }

    public void put(String key2, String value2) {
        if (value2 == null) {
            throw new IllegalArgumentException("No value provided for key " + key2);
        }
        this.validate(key2, value2);
        this.data.putValue(key2, value2);
    }

    public void putAll(Map<String, String> map23) {
        for (Map.Entry<String, String> entry : map23.entrySet()) {
            this.data.putValue(entry.getKey(), entry.getValue());
        }
    }

    public String get(String key2) {
        Object result = this.data.getValue(key2);
        return ParameterFormatter.deepToString(result);
    }

    public String remove(String key2) {
        String result = this.get(key2);
        this.data.remove(key2);
        return result;
    }

    public String asString() {
        return this.format(null, new StringBuilder()).toString();
    }

    public String asString(String format2) {
        try {
            return this.format(EnglishEnums.valueOf(MapFormat.class, format2), new StringBuilder()).toString();
        }
        catch (IllegalArgumentException ex) {
            return this.asString();
        }
    }

    public <CV> void forEach(BiConsumer<String, ? super CV> action) {
        this.data.forEach(action);
    }

    public <CV, S> void forEach(TriConsumer<String, ? super CV, S> action, S state) {
        this.data.forEach(action, state);
    }

    private StringBuilder format(MapFormat format2, StringBuilder sb) {
        if (format2 == null) {
            this.appendMap(sb);
        } else {
            switch (format2) {
                case XML: {
                    this.asXml(sb);
                    break;
                }
                case JSON: {
                    this.asJson(sb);
                    break;
                }
                case JAVA: {
                    this.asJava(sb);
                    break;
                }
                default: {
                    this.appendMap(sb);
                }
            }
        }
        return sb;
    }

    public void asXml(StringBuilder sb) {
        sb.append("<Map>\n");
        for (int i = 0; i < this.data.size(); ++i) {
            sb.append("  <Entry key=\"").append(this.data.getKeyAt(i)).append("\">");
            int size2 = sb.length();
            ParameterFormatter.recursiveDeepToString(this.data.getValueAt(i), sb, null);
            StringBuilders.escapeXml(sb, size2);
            sb.append("</Entry>\n");
        }
        sb.append("</Map>");
    }

    @Override
    public String getFormattedMessage() {
        return this.asString();
    }

    @Override
    public String getFormattedMessage(String[] formats) {
        return this.format(this.getFormat(formats), new StringBuilder()).toString();
    }

    private MapFormat getFormat(String[] formats) {
        if (formats == null || formats.length == 0) {
            return null;
        }
        for (int i = 0; i < formats.length; ++i) {
            MapFormat mapFormat = MapFormat.lookupIgnoreCase(formats[i]);
            if (mapFormat == null) continue;
            return mapFormat;
        }
        return null;
    }

    protected void appendMap(StringBuilder sb) {
        for (int i = 0; i < this.data.size(); ++i) {
            if (i > 0) {
                sb.append(' ');
            }
            sb.append(this.data.getKeyAt(i)).append('=').append('\"');
            ParameterFormatter.recursiveDeepToString(this.data.getValueAt(i), sb, null);
            sb.append('\"');
        }
    }

    protected void asJson(StringBuilder sb) {
        sb.append('{');
        for (int i = 0; i < this.data.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append('\"');
            int start = sb.length();
            sb.append(this.data.getKeyAt(i));
            StringBuilders.escapeJson(sb, start);
            sb.append('\"').append(':').append('\"');
            start = sb.length();
            ParameterFormatter.recursiveDeepToString(this.data.getValueAt(i), sb, null);
            StringBuilders.escapeJson(sb, start);
            sb.append('\"');
        }
        sb.append('}');
    }

    protected void asJava(StringBuilder sb) {
        sb.append('{');
        for (int i = 0; i < this.data.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.data.getKeyAt(i)).append('=').append('\"');
            ParameterFormatter.recursiveDeepToString(this.data.getValueAt(i), sb, null);
            sb.append('\"');
        }
        sb.append('}');
    }

    public M newInstance(Map<String, V> map23) {
        return (M)new MapMessage<M, V>(map23);
    }

    public String toString() {
        return this.asString();
    }

    @Override
    public void formatTo(StringBuilder buffer) {
        this.format(null, buffer);
    }

    @Override
    public void formatTo(String[] formats, StringBuilder buffer) {
        this.format(this.getFormat(formats), buffer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapMessage that = (MapMessage)o;
        return this.data.equals(that.data);
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    @Override
    public Throwable getThrowable() {
        return null;
    }

    protected void validate(String key2, boolean value2) {
    }

    protected void validate(String key2, byte value2) {
    }

    protected void validate(String key2, char value2) {
    }

    protected void validate(String key2, double value2) {
    }

    protected void validate(String key2, float value2) {
    }

    protected void validate(String key2, int value2) {
    }

    protected void validate(String key2, long value2) {
    }

    protected void validate(String key2, Object value2) {
    }

    protected void validate(String key2, short value2) {
    }

    protected void validate(String key2, String value2) {
    }

    public M with(String key2, boolean value2) {
        this.validate(key2, value2);
        this.data.putValue(key2, value2);
        return (M)this;
    }

    public M with(String key2, byte value2) {
        this.validate(key2, value2);
        this.data.putValue(key2, value2);
        return (M)this;
    }

    public M with(String key2, char value2) {
        this.validate(key2, value2);
        this.data.putValue(key2, Character.valueOf(value2));
        return (M)this;
    }

    public M with(String key2, double value2) {
        this.validate(key2, value2);
        this.data.putValue(key2, value2);
        return (M)this;
    }

    public M with(String key2, float value2) {
        this.validate(key2, value2);
        this.data.putValue(key2, Float.valueOf(value2));
        return (M)this;
    }

    public M with(String key2, int value2) {
        this.validate(key2, value2);
        this.data.putValue(key2, value2);
        return (M)this;
    }

    public M with(String key2, long value2) {
        this.validate(key2, value2);
        this.data.putValue(key2, value2);
        return (M)this;
    }

    public M with(String key2, Object value2) {
        this.validate(key2, value2);
        this.data.putValue(key2, value2);
        return (M)this;
    }

    public M with(String key2, short value2) {
        this.validate(key2, value2);
        this.data.putValue(key2, value2);
        return (M)this;
    }

    public M with(String key2, String value2) {
        this.put(key2, value2);
        return (M)this;
    }

    public static enum MapFormat {
        XML,
        JSON,
        JAVA;


        public static MapFormat lookupIgnoreCase(String format2) {
            return XML.name().equalsIgnoreCase(format2) ? XML : (JSON.name().equalsIgnoreCase(format2) ? JSON : (JAVA.name().equalsIgnoreCase(format2) ? JAVA : null));
        }

        public static String[] names() {
            return new String[]{XML.name(), JSON.name(), JAVA.name()};
        }
    }
}

