/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.spi;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.spi.ObjectThreadContextMap;
import org.apache.logging.log4j.spi.ReadOnlyThreadContextMap;
import org.apache.logging.log4j.spi.ThreadContextMap;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.SortedArrayStringMap;
import org.apache.logging.log4j.util.StringMap;

class GarbageFreeSortedArrayThreadContextMap
implements ReadOnlyThreadContextMap,
ObjectThreadContextMap {
    public static final String INHERITABLE_MAP = "isThreadContextMapInheritable";
    protected static final int DEFAULT_INITIAL_CAPACITY = 16;
    protected static final String PROPERTY_NAME_INITIAL_CAPACITY = "log4j2.ThreadContext.initial.capacity";
    protected final ThreadLocal<StringMap> localMap = this.createThreadLocalMap();
    private static volatile int initialCapacity;
    private static volatile boolean inheritableMap;

    static void init() {
        PropertiesUtil properties2 = PropertiesUtil.getProperties();
        initialCapacity = properties2.getIntegerProperty(PROPERTY_NAME_INITIAL_CAPACITY, 16);
        inheritableMap = properties2.getBooleanProperty(INHERITABLE_MAP);
    }

    private ThreadLocal<StringMap> createThreadLocalMap() {
        if (inheritableMap) {
            return new InheritableThreadLocal<StringMap>(){

                @Override
                protected StringMap childValue(StringMap parentValue) {
                    return parentValue != null ? GarbageFreeSortedArrayThreadContextMap.this.createStringMap(parentValue) : null;
                }
            };
        }
        return new ThreadLocal<StringMap>();
    }

    protected StringMap createStringMap() {
        return new SortedArrayStringMap(initialCapacity);
    }

    protected StringMap createStringMap(ReadOnlyStringMap original) {
        return new SortedArrayStringMap(original);
    }

    private StringMap getThreadLocalMap() {
        StringMap map23 = this.localMap.get();
        if (map23 == null) {
            map23 = this.createStringMap();
            this.localMap.set(map23);
        }
        return map23;
    }

    @Override
    public void put(String key2, String value2) {
        this.getThreadLocalMap().putValue(key2, value2);
    }

    public void putValue(String key2, Object value2) {
        this.getThreadLocalMap().putValue(key2, value2);
    }

    @Override
    public void putAll(Map<String, String> values) {
        if (values == null || values.isEmpty()) {
            return;
        }
        StringMap map23 = this.getThreadLocalMap();
        for (Map.Entry<String, String> entry : values.entrySet()) {
            map23.putValue(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public <V> void putAllValues(Map<String, V> values) {
        if (values == null || values.isEmpty()) {
            return;
        }
        StringMap map23 = this.getThreadLocalMap();
        for (Map.Entry<String, V> entry : values.entrySet()) {
            map23.putValue(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public String get(String key2) {
        return (String)this.getValue(key2);
    }

    @Override
    public <V> V getValue(String key2) {
        StringMap map23 = this.localMap.get();
        return map23 == null ? null : (V)map23.getValue(key2);
    }

    @Override
    public void remove(String key2) {
        StringMap map23 = this.localMap.get();
        if (map23 != null) {
            map23.remove(key2);
        }
    }

    @Override
    public void removeAll(Iterable<String> keys) {
        StringMap map23 = this.localMap.get();
        if (map23 != null) {
            for (String key2 : keys) {
                map23.remove(key2);
            }
        }
    }

    @Override
    public void clear() {
        StringMap map23 = this.localMap.get();
        if (map23 != null) {
            map23.clear();
        }
    }

    @Override
    public boolean containsKey(String key2) {
        StringMap map23 = this.localMap.get();
        return map23 != null && map23.containsKey(key2);
    }

    @Override
    public Map<String, String> getCopy() {
        StringMap map23 = this.localMap.get();
        return map23 == null ? new HashMap() : map23.toMap();
    }

    @Override
    public StringMap getReadOnlyContextData() {
        StringMap map23 = this.localMap.get();
        if (map23 == null) {
            map23 = this.createStringMap();
            this.localMap.set(map23);
        }
        return map23;
    }

    @Override
    public Map<String, String> getImmutableMapOrNull() {
        StringMap map23 = this.localMap.get();
        return map23 == null ? null : Collections.unmodifiableMap(map23.toMap());
    }

    @Override
    public boolean isEmpty() {
        StringMap map23 = this.localMap.get();
        return map23 == null || map23.size() == 0;
    }

    public String toString() {
        StringMap map23 = this.localMap.get();
        return map23 == null ? "{}" : map23.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        StringMap map23 = this.localMap.get();
        result = 31 * result + (map23 == null ? 0 : map23.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThreadContextMap)) {
            return false;
        }
        ThreadContextMap other = (ThreadContextMap)obj;
        Map<String, String> map23 = this.getImmutableMapOrNull();
        Map<String, String> otherMap = other.getImmutableMapOrNull();
        return !(map23 == null ? otherMap != null : !map23.equals(otherMap));
    }

    static {
        GarbageFreeSortedArrayThreadContextMap.init();
    }
}

