/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.LowLevelLogUtil;
import org.apache.logging.log4j.util.PropertiesPropertySource;
import org.apache.logging.log4j.util.PropertyFilePropertySource;
import org.apache.logging.log4j.util.PropertySource;

public final class PropertiesUtil {
    private static final String LOG4J_PROPERTIES_FILE_NAME = "log4j2.component.properties";
    private static final PropertiesUtil LOG4J_PROPERTIES = new PropertiesUtil("log4j2.component.properties");
    private final Environment environment;

    public PropertiesUtil(Properties props2) {
        this.environment = new Environment(new PropertiesPropertySource(props2));
    }

    public PropertiesUtil(String propertiesFileName) {
        this.environment = new Environment(new PropertyFilePropertySource(propertiesFileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Properties loadClose(InputStream in, Object source2) {
        Properties props2 = new Properties();
        if (null != in) {
            try {
                props2.load(in);
            }
            catch (IOException e) {
                LowLevelLogUtil.logException("Unable to read " + source2, e);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LowLevelLogUtil.logException("Unable to close " + source2, e);
                }
            }
        }
        return props2;
    }

    public static PropertiesUtil getProperties() {
        return LOG4J_PROPERTIES;
    }

    public boolean hasProperty(String name2) {
        return this.environment.containsKey(name2);
    }

    public boolean getBooleanProperty(String name2) {
        return this.getBooleanProperty(name2, false);
    }

    public boolean getBooleanProperty(String name2, boolean defaultValue) {
        String prop = this.getStringProperty(name2);
        return prop == null ? defaultValue : "true".equalsIgnoreCase(prop);
    }

    public boolean getBooleanProperty(String name2, boolean defaultValueIfAbsent, boolean defaultValueIfPresent) {
        String prop = this.getStringProperty(name2);
        return prop == null ? defaultValueIfAbsent : (prop.isEmpty() ? defaultValueIfPresent : "true".equalsIgnoreCase(prop));
    }

    public Charset getCharsetProperty(String name2) {
        return this.getCharsetProperty(name2, Charset.defaultCharset());
    }

    public Charset getCharsetProperty(String name2, Charset defaultValue) {
        String mapped;
        String charsetName = this.getStringProperty(name2);
        if (charsetName == null) {
            return defaultValue;
        }
        if (Charset.isSupported(charsetName)) {
            return Charset.forName(charsetName);
        }
        ResourceBundle bundle = PropertiesUtil.getCharsetsResourceBundle();
        if (bundle.containsKey(name2) && Charset.isSupported(mapped = bundle.getString(name2))) {
            return Charset.forName(mapped);
        }
        LowLevelLogUtil.log("Unable to get Charset '" + charsetName + "' for property '" + name2 + "', using default " + defaultValue + " and continuing.");
        return defaultValue;
    }

    public double getDoubleProperty(String name2, double defaultValue) {
        String prop = this.getStringProperty(name2);
        if (prop != null) {
            try {
                return Double.parseDouble(prop);
            }
            catch (Exception ignored) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public int getIntegerProperty(String name2, int defaultValue) {
        String prop = this.getStringProperty(name2);
        if (prop != null) {
            try {
                return Integer.parseInt(prop);
            }
            catch (Exception ignored) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public long getLongProperty(String name2, long defaultValue) {
        String prop = this.getStringProperty(name2);
        if (prop != null) {
            try {
                return Long.parseLong(prop);
            }
            catch (Exception ignored) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public String getStringProperty(String name2) {
        return this.environment.get(name2);
    }

    public String getStringProperty(String name2, String defaultValue) {
        String prop = this.getStringProperty(name2);
        return prop == null ? defaultValue : prop;
    }

    public static Properties getSystemProperties() {
        try {
            return new Properties(System.getProperties());
        }
        catch (SecurityException ex) {
            LowLevelLogUtil.logException("Unable to access system properties.", ex);
            return new Properties();
        }
    }

    public void reload() {
        this.environment.reload();
    }

    public static Properties extractSubset(Properties properties2, String prefix) {
        Properties subset = new Properties();
        if (prefix == null || prefix.length() == 0) {
            return subset;
        }
        String prefixToMatch = prefix.charAt(prefix.length() - 1) != '.' ? prefix + '.' : prefix;
        ArrayList<String> keys = new ArrayList<String>();
        for (String key2 : properties2.stringPropertyNames()) {
            if (!key2.startsWith(prefixToMatch)) continue;
            subset.setProperty(key2.substring(prefixToMatch.length()), properties2.getProperty(key2));
            keys.add(key2);
        }
        for (String key2 : keys) {
            properties2.remove(key2);
        }
        return subset;
    }

    static ResourceBundle getCharsetsResourceBundle() {
        return ResourceBundle.getBundle("Log4j-charsets");
    }

    public static Map<String, Properties> partitionOnCommonPrefixes(Properties properties2) {
        ConcurrentHashMap<String, Properties> parts = new ConcurrentHashMap<String, Properties>();
        for (String key2 : properties2.stringPropertyNames()) {
            String prefix = key2.substring(0, key2.indexOf(46));
            if (!parts.containsKey(prefix)) {
                parts.put(prefix, new Properties());
            }
            ((Properties)parts.get(prefix)).setProperty(key2.substring(key2.indexOf(46) + 1), properties2.getProperty(key2));
        }
        return parts;
    }

    public boolean isOsWindows() {
        return this.getStringProperty("os.name", "").startsWith("Windows");
    }

    private static class Environment {
        private final Set<PropertySource> sources = new TreeSet<PropertySource>(new PropertySource.Comparator());
        private final Map<CharSequence, String> literal = new ConcurrentHashMap<CharSequence, String>();
        private final Map<CharSequence, String> normalized = new ConcurrentHashMap<CharSequence, String>();
        private final Map<List<CharSequence>, String> tokenized = new ConcurrentHashMap<List<CharSequence>, String>();

        private Environment(PropertySource propertySource) {
            this.sources.add(propertySource);
            for (PropertySource source2 : ServiceLoader.load(PropertySource.class)) {
                this.sources.add(source2);
            }
            this.reload();
        }

        private synchronized void reload() {
            this.literal.clear();
            this.normalized.clear();
            this.tokenized.clear();
            for (final PropertySource source2 : this.sources) {
                source2.forEach(new BiConsumer<String, String>(){

                    @Override
                    public void accept(String key2, String value2) {
                        Environment.this.literal.put(key2, value2);
                        List<CharSequence> tokens = PropertySource.Util.tokenize(key2);
                        if (tokens.isEmpty()) {
                            Environment.this.normalized.put(source2.getNormalForm(Collections.singleton(key2)), value2);
                        } else {
                            Environment.this.normalized.put(source2.getNormalForm(tokens), value2);
                            Environment.this.tokenized.put(tokens, value2);
                        }
                    }
                });
            }
        }

        private static boolean hasSystemProperty(String key2) {
            try {
                return System.getProperties().containsKey(key2);
            }
            catch (SecurityException ignored) {
                return false;
            }
        }

        private String get(String key2) {
            if (this.normalized.containsKey(key2)) {
                return this.normalized.get(key2);
            }
            if (this.literal.containsKey(key2)) {
                return this.literal.get(key2);
            }
            if (Environment.hasSystemProperty(key2)) {
                return System.getProperty(key2);
            }
            return this.tokenized.get(PropertySource.Util.tokenize(key2));
        }

        private boolean containsKey(String key2) {
            return this.normalized.containsKey(key2) || this.literal.containsKey(key2) || Environment.hasSystemProperty(key2) || this.tokenized.containsKey(PropertySource.Util.tokenize(key2));
        }
    }
}

