/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;
import org.apache.logging.log4j.util.PropertiesUtil;

public final class Strings {
    public static final String EMPTY = "";
    public static final String LINE_SEPARATOR = PropertiesUtil.getProperties().getStringProperty("line.separator", "\n");

    private Strings() {
    }

    public static String dquote(String str2) {
        return '\"' + str2 + '\"';
    }

    public static boolean isBlank(String s) {
        return s == null || s.trim().isEmpty();
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isNotBlank(String s) {
        return !Strings.isBlank(s);
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !Strings.isEmpty(cs);
    }

    public static String quote(String str2) {
        return '\'' + str2 + '\'';
    }

    public String toRootUpperCase(String str2) {
        return str2.toUpperCase(Locale.ROOT);
    }

    public static String trimToNull(String str2) {
        String ts = str2 == null ? null : str2.trim();
        return Strings.isEmpty(ts) ? null : ts;
    }

    public static String join(Iterable<?> iterable, char separator) {
        if (iterable == null) {
            return null;
        }
        return Strings.join(iterable.iterator(), separator);
    }

    public static String join(Iterator<?> iterator2, char separator) {
        if (iterator2 == null) {
            return null;
        }
        if (!iterator2.hasNext()) {
            return EMPTY;
        }
        Object first2 = iterator2.next();
        if (!iterator2.hasNext()) {
            return Objects.toString(first2, EMPTY);
        }
        StringBuilder buf = new StringBuilder(256);
        if (first2 != null) {
            buf.append(first2);
        }
        while (iterator2.hasNext()) {
            buf.append(separator);
            Object obj = iterator2.next();
            if (obj == null) continue;
            buf.append(obj);
        }
        return buf.toString();
    }
}

