/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.common;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.parboiled.common.Preconditions;

public final class FileUtils {
    private FileUtils() {
    }

    public static String readAllTextFromResource(String string2) {
        Preconditions.checkArgNotNull(string2, "resource");
        return FileUtils.readAllText(FileUtils.class.getClassLoader().getResourceAsStream(string2));
    }

    public static String readAllTextFromResource(String string2, Charset charset) {
        Preconditions.checkArgNotNull(string2, "resource");
        Preconditions.checkArgNotNull(charset, "charset");
        return FileUtils.readAllText(FileUtils.class.getClassLoader().getResourceAsStream(string2), charset);
    }

    public static String readAllText(String string2) {
        Preconditions.checkArgNotNull(string2, "filename");
        return FileUtils.readAllText(new File(string2));
    }

    public static String readAllText(String string2, Charset charset) {
        Preconditions.checkArgNotNull(string2, "filename");
        Preconditions.checkArgNotNull(charset, "charset");
        return FileUtils.readAllText(new File(string2), charset);
    }

    public static String readAllText(File file) {
        Preconditions.checkArgNotNull(file, "file");
        return FileUtils.readAllText(file, Charset.forName("UTF8"));
    }

    public static String readAllText(File file, Charset charset) {
        Preconditions.checkArgNotNull(file, "file");
        Preconditions.checkArgNotNull(charset, "charset");
        try {
            return FileUtils.readAllText(new FileInputStream(file), charset);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public static String readAllText(InputStream inputStream) {
        return FileUtils.readAllText(inputStream, Charset.forName("UTF8"));
    }

    public static String readAllText(InputStream inputStream, Charset charset) {
        Preconditions.checkArgNotNull(charset, "charset");
        if (inputStream == null) {
            return null;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, charset));
        StringWriter stringWriter = new StringWriter();
        FileUtils.copyAll(bufferedReader, stringWriter);
        return stringWriter.toString();
    }

    public static char[] readAllCharsFromResource(String string2) {
        Preconditions.checkArgNotNull(string2, "resource");
        return FileUtils.readAllChars(FileUtils.class.getClassLoader().getResourceAsStream(string2));
    }

    public static char[] readAllCharsFromResource(String string2, Charset charset) {
        Preconditions.checkArgNotNull(string2, "resource");
        Preconditions.checkArgNotNull(charset, "charset");
        return FileUtils.readAllChars(FileUtils.class.getClassLoader().getResourceAsStream(string2), charset);
    }

    public static char[] readAllChars(String string2) {
        Preconditions.checkArgNotNull(string2, "filename");
        return FileUtils.readAllChars(new File(string2));
    }

    public static char[] readAllChars(String string2, Charset charset) {
        Preconditions.checkArgNotNull(string2, "filename");
        Preconditions.checkArgNotNull(charset, "charset");
        return FileUtils.readAllChars(new File(string2), charset);
    }

    public static char[] readAllChars(File file) {
        Preconditions.checkArgNotNull(file, "file");
        return FileUtils.readAllChars(file, Charset.forName("UTF8"));
    }

    public static char[] readAllChars(File file, Charset charset) {
        Preconditions.checkArgNotNull(file, "file");
        Preconditions.checkArgNotNull(charset, "charset");
        try {
            return FileUtils.readAllChars(new FileInputStream(file), charset);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public static char[] readAllChars(InputStream inputStream) {
        return FileUtils.readAllChars(inputStream, Charset.forName("UTF8"));
    }

    public static char[] readAllChars(InputStream inputStream, Charset charset) {
        Preconditions.checkArgNotNull(charset, "charset");
        if (inputStream == null) {
            return null;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, charset));
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        FileUtils.copyAll(bufferedReader, charArrayWriter);
        return charArrayWriter.toCharArray();
    }

    public static byte[] readAllBytesFromResource(String string2) {
        Preconditions.checkArgNotNull(string2, "resource");
        return FileUtils.readAllBytes(FileUtils.class.getClassLoader().getResourceAsStream(string2));
    }

    public static byte[] readAllBytes(String string2) {
        Preconditions.checkArgNotNull(string2, "filename");
        return FileUtils.readAllBytes(new File(string2));
    }

    public static byte[] readAllBytes(File file) {
        Preconditions.checkArgNotNull(file, "file");
        try {
            return FileUtils.readAllBytes(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public static byte[] readAllBytes(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileUtils.copyAll(bufferedInputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static void writeAllText(String string2, String string3) {
        Preconditions.checkArgNotNull(string3, "filename");
        FileUtils.writeAllText(string2, new File(string3));
    }

    public static void writeAllText(String string2, String string3, Charset charset) {
        Preconditions.checkArgNotNull(string3, "filename");
        Preconditions.checkArgNotNull(charset, "charset");
        FileUtils.writeAllText(string2, new File(string3), charset);
    }

    public static void writeAllText(String string2, File file) {
        Preconditions.checkArgNotNull(file, "file");
        FileUtils.writeAllText(string2, file, Charset.forName("UTF8"));
    }

    public static void writeAllText(String string2, File file, Charset charset) {
        Preconditions.checkArgNotNull(file, "file");
        Preconditions.checkArgNotNull(charset, "charset");
        try {
            FileUtils.ensureParentDir(file);
            FileUtils.writeAllText(string2, new FileOutputStream(file), charset);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException(fileNotFoundException);
        }
    }

    public static void writeAllText(String string2, OutputStream outputStream) {
        Preconditions.checkArgNotNull(outputStream, "stream");
        FileUtils.writeAllText(string2, outputStream, Charset.forName("UTF8"));
    }

    public static void writeAllText(String string2, OutputStream outputStream, Charset charset) {
        Preconditions.checkArgNotNull(outputStream, "stream");
        Preconditions.checkArgNotNull(charset, "charset");
        StringReader stringReader = new StringReader(string2 != null ? string2 : "");
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, charset));
        FileUtils.copyAll(stringReader, bufferedWriter);
    }

    public static void writeAllChars(char[] cArray, String string2) {
        Preconditions.checkArgNotNull(string2, "filename");
        FileUtils.writeAllChars(cArray, new File(string2));
    }

    public static void writeAllChars(char[] cArray, String string2, Charset charset) {
        Preconditions.checkArgNotNull(string2, "filename");
        Preconditions.checkArgNotNull(charset, "charset");
        FileUtils.writeAllChars(cArray, new File(string2), charset);
    }

    public static void writeAllChars(char[] cArray, File file) {
        Preconditions.checkArgNotNull(file, "file");
        FileUtils.writeAllChars(cArray, file, Charset.forName("UTF8"));
    }

    public static void writeAllChars(char[] cArray, File file, Charset charset) {
        Preconditions.checkArgNotNull(file, "file");
        Preconditions.checkArgNotNull(charset, "charset");
        try {
            FileUtils.ensureParentDir(file);
            FileUtils.writeAllChars(cArray, new FileOutputStream(file), charset);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException(fileNotFoundException);
        }
    }

    public static void writeAllChars(char[] cArray, OutputStream outputStream) {
        Preconditions.checkArgNotNull(outputStream, "stream");
        FileUtils.writeAllChars(cArray, outputStream, Charset.forName("UTF8"));
    }

    public static void writeAllChars(char[] cArray, OutputStream outputStream, Charset charset) {
        Preconditions.checkArgNotNull(outputStream, "stream");
        Preconditions.checkArgNotNull(charset, "charset");
        CharArrayReader charArrayReader = new CharArrayReader(cArray != null ? cArray : new char[]{});
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, charset));
        FileUtils.copyAll(charArrayReader, bufferedWriter);
    }

    public static void writeAllBytes(byte[] byArray, String string2) {
        Preconditions.checkArgNotNull(byArray, "data");
        Preconditions.checkArgNotNull(string2, "filename");
        FileUtils.writeAllBytes(byArray, new File(string2));
    }

    public static void writeAllBytes(byte[] byArray, File file) {
        Preconditions.checkArgNotNull(byArray, "data");
        Preconditions.checkArgNotNull(file, "file");
        try {
            FileUtils.ensureParentDir(file);
            FileUtils.writeAllBytes(byArray, new FileOutputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException(fileNotFoundException);
        }
    }

    public static void writeAllBytes(byte[] byArray, OutputStream outputStream) {
        Preconditions.checkArgNotNull(byArray, "data");
        Preconditions.checkArgNotNull(outputStream, "stream");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        FileUtils.copyAll(byteArrayInputStream, bufferedOutputStream);
    }

    public static void copyAll(Reader reader, Writer writer) {
        Preconditions.checkArgNotNull(reader, "reader");
        Preconditions.checkArgNotNull(writer, "writer");
        try {
            int n;
            char[] cArray = new char[4096];
            while ((n = reader.read(cArray)) >= 0) {
                writer.write(cArray, 0, n);
            }
            reader.close();
            writer.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static void copyAll(InputStream inputStream, OutputStream outputStream) {
        Preconditions.checkArgNotNull(inputStream, "in");
        Preconditions.checkArgNotNull(outputStream, "out");
        try {
            int n;
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray)) >= 0) {
                outputStream.write(byArray, 0, n);
            }
            inputStream.close();
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static void ensureParentDir(String string2) {
        FileUtils.ensureParentDir(new File(string2));
    }

    public static void ensureParentDir(File file) {
        File file2 = file.getParentFile();
        if (file2 != null && !file2.exists()) {
            try {
                FileUtils.forceMkdir(file2);
            }
            catch (IOException iOException) {
                throw new RuntimeException(String.format("Could not create directory %s", file2), iOException);
            }
        }
    }

    public static void forceMkdir(File file) throws IOException {
        if (file.exists()) {
            if (file.isFile()) {
                throw new IOException("File '" + file + "' exists and is not a directory. Unable to create directory.");
            }
        } else if (!file.mkdirs()) {
            throw new IOException("Unable to create directory " + file);
        }
    }
}

