/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.common;

public class IntArrayStack {
    private static final int INITIAL_CAPACITY = 16;
    private int[] array = new int[16];
    private int top = -1;

    public boolean isEmpty() {
        return this.top == -1;
    }

    public int size() {
        return this.top + 1;
    }

    public void getElements(int[] nArray, int n) {
        System.arraycopy(this.array, 0, nArray, n, this.size());
    }

    public int[] toArray() {
        int[] nArray = new int[this.size()];
        this.getElements(nArray, 0);
        return nArray;
    }

    public void clear() {
        this.top = -1;
    }

    public int peek() {
        if (this.isEmpty()) {
            throw new UnderflowException("IntArrayStack peek");
        }
        return this.array[this.top];
    }

    public int pop() {
        if (this.isEmpty()) {
            throw new UnderflowException("IntArrayStack pop");
        }
        return this.array[this.top--];
    }

    public void push(int n) {
        if (this.top == this.array.length - 1) {
            this.expandCapacity();
        }
        this.array[++this.top] = n;
    }

    private void expandCapacity() {
        int[] nArray = new int[this.array.length * 2];
        System.arraycopy(this.array, 0, nArray, 0, this.array.length);
        this.array = nArray;
    }

    public static class UnderflowException
    extends RuntimeException {
        public UnderflowException(String string2) {
            super(string2);
        }
    }
}

