/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.common;

import java.util.Arrays;
import java.util.Iterator;
import org.parboiled.common.Utils;

public final class StringUtils {
    private StringUtils() {
    }

    public static String escape(String string2) {
        if (StringUtils.isEmpty(string2)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = string2.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (i != cArray.length - 1 && cArray[i] == '\r' && cArray[i + 1] == '\n') continue;
            stringBuilder.append(StringUtils.escape(cArray[i]));
        }
        return stringBuilder.toString();
    }

    public static String escape(char c) {
        switch (c) {
            case '\r': {
                return "\\r";
            }
            case '\n': {
                return "\\n";
            }
            case '\t': {
                return "\\t";
            }
            case '\f': {
                return "\\f";
            }
            case '\ufdea': {
                return "DEL_ERROR";
            }
            case '\ufdeb': {
                return "INS_ERROR";
            }
            case '\ufdec': {
                return "RESYNC";
            }
            case '\ufded': {
                return "RESYNC_START";
            }
            case '\ufdee': {
                return "RESYNC_END";
            }
            case '\ufdef': {
                return "RESYNC_EOI";
            }
            case '\ufdd0': {
                return "INDENT";
            }
            case '\ufdd1': {
                return "DEDENT";
            }
            case '\uffff': {
                return "EOI";
            }
        }
        return String.valueOf(c);
    }

    public static String repeat(char c, int n) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, c);
        return String.valueOf(cArray);
    }

    public static String join(Iterable iterable, String string2) {
        return iterable == null ? null : StringUtils.join(iterable.iterator(), string2);
    }

    public static String join(Iterator iterator2, String string2) {
        if (iterator2 == null) {
            return null;
        }
        if (!iterator2.hasNext()) {
            return "";
        }
        Object e = iterator2.next();
        if (!iterator2.hasNext()) {
            return Utils.toString(e);
        }
        StringBuilder stringBuilder = new StringBuilder(256);
        if (e != null) {
            stringBuilder.append(e);
        }
        while (iterator2.hasNext()) {
            Object e2;
            if (string2 != null) {
                stringBuilder.append(string2);
            }
            if ((e2 = iterator2.next()) == null) continue;
            stringBuilder.append(e2);
        }
        return stringBuilder.toString();
    }

    public static String join(Object[] objectArray, String string2) {
        return objectArray == null ? null : StringUtils.join(objectArray, string2, 0, objectArray.length);
    }

    public static String join(Object[] objectArray, String string2, int n, int n2) {
        int n3;
        if (objectArray == null) {
            return null;
        }
        if (string2 == null) {
            string2 = "";
        }
        if ((n3 = n2 - n) <= 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(n3 *= (objectArray[n] == null ? 16 : objectArray[n].toString().length()) + string2.length());
        for (int i = n; i < n2; ++i) {
            if (i > n) {
                stringBuilder.append(string2);
            }
            if (objectArray[i] == null) continue;
            stringBuilder.append(objectArray[i]);
        }
        return stringBuilder.toString();
    }

    public static boolean isEmpty(String string2) {
        return string2 == null || string2.length() == 0;
    }

    public static boolean isNotEmpty(String string2) {
        return !StringUtils.isEmpty(string2);
    }

    public static int length(String string2) {
        return string2 == null ? 0 : string2.length();
    }

    public static boolean equalsIgnoreCase(String string2, String string3) {
        return string2 == null ? string3 == null : string2.equalsIgnoreCase(string3);
    }

    public static boolean startsWith(String string2, String string3) {
        return string2 != null && (string3 == null || string2.startsWith(string3));
    }

    public static String substring(String string2, int n) {
        if (string2 == null) {
            return null;
        }
        if (n < 0) {
            n = string2.length() + n;
        }
        if (n < 0) {
            n = 0;
        }
        if (n > string2.length()) {
            return "";
        }
        return string2.substring(n);
    }

    public static String substring(String string2, int n, int n2) {
        if (string2 == null) {
            return null;
        }
        if (n2 < 0) {
            n2 = string2.length() + n2;
        }
        if (n < 0) {
            n = string2.length() + n;
        }
        if (n2 > string2.length()) {
            n2 = string2.length();
        }
        if (n > n2) {
            return "";
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        return string2.substring(n, n2);
    }

    public static String left(String string2, int n) {
        if (string2 == null) {
            return null;
        }
        if (n < 0) {
            return "";
        }
        if (string2.length() <= n) {
            return string2;
        }
        return string2.substring(0, n);
    }

    public static String right(String string2, int n) {
        if (string2 == null) {
            return null;
        }
        if (n < 0) {
            return "";
        }
        if (string2.length() <= n) {
            return string2;
        }
        return string2.substring(string2.length() - n);
    }

    public static String mid(String string2, int n, int n2) {
        if (string2 == null) {
            return null;
        }
        if (n2 < 0 || n > string2.length()) {
            return "";
        }
        if (n < 0) {
            n = 0;
        }
        if (string2.length() <= n + n2) {
            return string2.substring(n);
        }
        return string2.substring(n, n + n2);
    }
}

