/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.parserunners;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.parboiled.MatchHandler;
import org.parboiled.MatcherContext;
import org.parboiled.Rule;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.common.Preconditions;
import org.parboiled.common.Predicate;
import org.parboiled.common.StringUtils;
import org.parboiled.common.Utils;
import org.parboiled.matchers.Matcher;
import org.parboiled.matchervisitors.DoWithMatcherVisitor;
import org.parboiled.parserunners.AbstractParseRunner;
import org.parboiled.support.ParsingResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfilingParseRunner<V>
extends AbstractParseRunner<V>
implements MatchHandler {
    private final Map<Rule, RuleReport> ruleReports = new HashMap<Rule, RuleReport>();
    private int runMatches;
    private int totalRuns;
    private int totalMatches;
    private int totalMismatches;
    private int totalRematches;
    private int totalRemismatches;
    private long totalNanoTime;
    private long timeCorrection;
    private final DoWithMatcherVisitor.Action updateStatsAction = new DoWithMatcherVisitor.Action(){

        public void process(Matcher matcher) {
            RuleStats ruleStats = (RuleStats)matcher.getTag();
            int n = 0;
            int n2 = 0;
            for (Integer n3 : ruleStats.positionMatches.values()) {
                if (n3 > 0) {
                    n += n3 - 1;
                    continue;
                }
                if (n3 >= 0) continue;
                n2 += -(n3 + 1);
            }
            ProfilingParseRunner.this.totalMatches += ruleStats.matches;
            ProfilingParseRunner.this.totalMismatches += ruleStats.mismatches;
            ProfilingParseRunner.this.totalRematches += n;
            ProfilingParseRunner.this.totalRemismatches += n2;
            Object object = (RuleReport)ProfilingParseRunner.this.ruleReports.get(matcher);
            if (object == null) {
                object = new RuleReport(matcher);
                ProfilingParseRunner.this.ruleReports.put(matcher, object);
            }
            ((RuleReport)object).update(ruleStats.matches, ruleStats.matchSubs, ruleStats.mismatches, ruleStats.mismatchSubs, n, ruleStats.rematchSubs, n2, ruleStats.remismatchSubs, ruleStats.nanoTime);
        }
    };

    public ProfilingParseRunner(Rule rule2) {
        super(rule2);
    }

    @Override
    public ParsingResult<V> run(InputBuffer inputBuffer) {
        Preconditions.checkArgNotNull(inputBuffer, "inputBuffer");
        this.resetValueStack();
        ++this.totalRuns;
        MatcherContext matcherContext = this.createRootContext(inputBuffer, this, true);
        matcherContext.getMatcher().accept(new DoWithMatcherVisitor(new DoWithMatcherVisitor.Action(){

            public void process(Matcher matcher) {
                RuleStats ruleStats = (RuleStats)matcher.getTag();
                if (ruleStats == null) {
                    ruleStats = new RuleStats();
                    matcher.setTag(ruleStats);
                } else {
                    ruleStats.clear();
                }
            }
        }));
        this.runMatches = 0;
        long l = System.nanoTime() - this.timeCorrection;
        boolean bl = matcherContext.runMatcher();
        this.totalNanoTime += System.nanoTime() - this.timeCorrection - l;
        this.getRootMatcher().accept(new DoWithMatcherVisitor(this.updateStatsAction));
        return this.createParsingResult(bl, matcherContext);
    }

    public Report getReport() {
        return new Report(this.totalRuns, this.totalMatches, this.totalMismatches, this.totalRematches, this.totalRemismatches, this.totalNanoTime, new ArrayList<RuleReport>(this.ruleReports.values()));
    }

    @Override
    public boolean match(MatcherContext<?> matcherContext) {
        long l = System.nanoTime();
        Matcher matcher = matcherContext.getMatcher();
        RuleStats ruleStats = (RuleStats)matcher.getTag();
        int n = matcherContext.getCurrentIndex();
        int n2 = -(++this.runMatches);
        int n3 = ruleStats.matchSubs;
        int n4 = ruleStats.rematchSubs;
        int n5 = ruleStats.mismatchSubs;
        int n6 = ruleStats.remismatchSubs;
        long l2 = System.nanoTime();
        this.timeCorrection += l2 - l;
        l = l2 - this.timeCorrection;
        boolean bl = matcher.match(matcherContext);
        l2 = System.nanoTime();
        ruleStats.nanoTime += l2 - this.timeCorrection - l;
        l = l2;
        n2 += this.runMatches;
        Integer n7 = (Integer)ruleStats.positionMatches.get(n);
        if (bl) {
            ruleStats.matches++;
            ruleStats.matchSubs = n3 + n2;
            if (n7 == null) {
                n7 = 1;
            } else if (n7 > 0) {
                Integer n8 = n7;
                Integer n9 = n7 = Integer.valueOf(n7 + 1);
                ruleStats.rematchSubs = n4 + n2;
            } else if (n7 < 0) {
                n7 = 0;
            }
        } else {
            ruleStats.mismatches++;
            ruleStats.mismatchSubs = n5 + n2;
            if (n7 == null) {
                n7 = -1;
            } else if (n7 < 0) {
                Integer n10 = n7;
                Integer n11 = n7 = Integer.valueOf(n7 - 1);
                ruleStats.remismatchSubs = n6 + n2;
            } else if (n7 > 0) {
                n7 = 0;
            }
        }
        ruleStats.positionMatches.put(n, n7);
        this.timeCorrection += System.nanoTime() - l;
        return bl;
    }

    public static class RuleReport {
        private final Matcher matcher;
        private int matches;
        private int matchSubs;
        private int mismatches;
        private int mismatchSubs;
        private int rematches;
        private int rematchSubs;
        private int remismatches;
        private int remismatchSubs;
        private long nanoTime;

        public RuleReport(Matcher matcher) {
            this.matcher = matcher;
        }

        public Matcher getMatcher() {
            return this.matcher;
        }

        public int getInvocations() {
            return this.matches + this.mismatches;
        }

        public int getInvocationSubs() {
            return this.matchSubs + this.mismatchSubs;
        }

        public int getMatches() {
            return this.matches;
        }

        public int getMatchSubs() {
            return this.matchSubs;
        }

        public int getMismatches() {
            return this.mismatches;
        }

        public int getMismatchSubs() {
            return this.mismatchSubs;
        }

        public double getMatchShare() {
            return (double)this.matches / (double)this.getInvocations();
        }

        public double getMatchShare2() {
            return (double)this.matchSubs / (double)this.getInvocationSubs();
        }

        public int getReinvocations() {
            return this.rematches + this.remismatches;
        }

        public int getReinvocationSubs() {
            return this.rematchSubs + this.remismatchSubs;
        }

        public int getRematches() {
            return this.rematches;
        }

        public int getRematchSubs() {
            return this.rematchSubs;
        }

        public int getRemismatches() {
            return this.remismatches;
        }

        public int getRemismatchSubs() {
            return this.remismatchSubs;
        }

        public double getReinvocationShare() {
            return (double)this.getReinvocations() / (double)this.getInvocations();
        }

        public double getReinvocationShare2() {
            return (double)this.getReinvocationSubs() / (double)this.getInvocationSubs();
        }

        public long getNanoTime() {
            return this.nanoTime;
        }

        public void update(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, long l) {
            this.matches += n;
            this.matchSubs += n2;
            this.mismatches += n3;
            this.mismatchSubs += n4;
            this.rematches += n5;
            this.rematchSubs += n6;
            this.remismatches += n7;
            this.remismatchSubs += n8;
            this.nanoTime += l;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Report {
        private static final DecimalFormat fmt = new DecimalFormat("0.###");
        public static final Predicate<RuleReport> allRules = new Predicate<RuleReport>(){

            @Override
            public boolean apply(RuleReport ruleReport) {
                return true;
            }
        };
        public static final Predicate<RuleReport> namedRules = new Predicate<RuleReport>(){

            @Override
            public boolean apply(RuleReport ruleReport) {
                return ruleReport.getMatcher().hasCustomLabel();
            }
        };
        public final int totalRuns;
        public final int totalInvocations;
        public final int totalMatches;
        public final int totalMismatches;
        public final double matchShare;
        public final int reinvocations;
        public final int rematches;
        public final int remismatches;
        public final double reinvocationShare;
        public final long totalNanoTime;
        public final List<RuleReport> ruleReports;

        public Report(int n, int n2, int n3, int n4, int n5, long l, List<RuleReport> list) {
            this.totalRuns = n;
            this.totalInvocations = n2 + n3;
            this.totalMatches = n2;
            this.totalMismatches = n3;
            this.matchShare = (double)n2 / (double)this.totalInvocations;
            this.reinvocations = n4 + n5;
            this.rematches = n4;
            this.remismatches = n5;
            this.reinvocationShare = (double)this.reinvocations / (double)this.totalInvocations;
            this.totalNanoTime = l;
            this.ruleReports = list;
        }

        public String print() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Profiling Report\n");
            stringBuilder.append("----------------\n");
            stringBuilder.append(this.printBasics());
            stringBuilder.append("\n");
            stringBuilder.append("Top 20 named rules by invocations:\n");
            stringBuilder.append(this.sortByInvocations().printTopRules(20, namedRules));
            stringBuilder.append("\n");
            stringBuilder.append("Top 20 named rules by sub-invocations:\n");
            stringBuilder.append(this.sortBySubInvocations().printTopRules(20, namedRules));
            stringBuilder.append("\n");
            stringBuilder.append("Top 20 named rules by re-invocations:\n");
            stringBuilder.append(this.sortByReinvocations().printTopRules(20, namedRules));
            stringBuilder.append("\n");
            stringBuilder.append("Top 20 named rules by re-sub-invocations:\n");
            stringBuilder.append(this.sortByResubinvocations().printTopRules(20, namedRules));
            stringBuilder.append("\n");
            stringBuilder.append("Top 20 named rules by re-mismatches:\n");
            stringBuilder.append(this.sortByRemismatches().printTopRules(20, namedRules));
            stringBuilder.append("\n");
            stringBuilder.append("Top 20 named rules by re-sub-mismatches:\n");
            stringBuilder.append(this.sortByResubmismatches().printTopRules(20, namedRules));
            return stringBuilder.toString();
        }

        public String printBasics() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(String.format("Runs                     : %,15d\n", this.totalRuns));
            stringBuilder.append(String.format("Active rules             : %,15d\n", this.ruleReports.size()));
            stringBuilder.append(String.format("Total net rule time      : %,15.3f s\n", (double)this.totalNanoTime / 1.0E9));
            stringBuilder.append(String.format("Total rule invocations   : %,15d\n", this.totalInvocations));
            stringBuilder.append(String.format("Total rule matches       : %,15d\n", this.totalMatches));
            stringBuilder.append(String.format("Total rule mismatches    : %,15d\n", this.totalMismatches));
            stringBuilder.append(String.format("Total match share        : %15.2f %%\n", 100.0 * this.matchShare));
            stringBuilder.append(String.format("Rule re-invocations      : %,15d\n", this.reinvocations));
            stringBuilder.append(String.format("Rule re-matches          : %,15d\n", this.rematches));
            stringBuilder.append(String.format("Rule re-mismatches       : %,15d\n", this.remismatches));
            stringBuilder.append(String.format("Rule re-invocation share : %15.2f %%\n", 100.0 * this.reinvocationShare));
            return stringBuilder.toString();
        }

        public String printTopRules(int n, Predicate<RuleReport> predicate) {
            Preconditions.checkArgNotNull(predicate, "filter");
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Rule                           | Net-Time  |   Invocations   |     Matches     |   Mismatches    |   Time/Invoc.   | Match % |    Re-Invocs    |   Re-Matches    |   Re-Mismatch   |     Re-Invoc %    \n");
            stringBuilder.append("-------------------------------|-----------|-----------------|-----------------|-----------------|-----------------|---------|-----------------|-----------------|-----------------|-------------------\n");
            for (int i = 0; i < Math.min(this.ruleReports.size(), n); ++i) {
                RuleReport ruleReport = this.ruleReports.get(i);
                if (!predicate.apply(ruleReport)) {
                    ++n;
                    continue;
                }
                stringBuilder.append(String.format("%-30s | %6.0f ms | %6s / %6s | %6s / %6s | %6s / %6s | %,12.0f ns | %6.2f%% | %6s / %6s | %6s / %6s | %6s / %6s | %6.2f%% / %6.2f%%\n", StringUtils.left(ruleReport.getMatcher().toString() + ": " + ruleReport.getMatcher().getClass().getSimpleName().replace("Matcher", ""), 30), (double)ruleReport.getNanoTime() / 1000000.0, Utils.humanize(ruleReport.getInvocations()), Utils.humanize(ruleReport.getInvocationSubs()), Utils.humanize(ruleReport.getMatches()), Utils.humanize(ruleReport.getMatchSubs()), Utils.humanize(ruleReport.getMismatches()), Utils.humanize(ruleReport.getMismatchSubs()), (double)ruleReport.getNanoTime() / (double)ruleReport.getInvocations(), ruleReport.getMatchShare() * 100.0, Utils.humanize(ruleReport.getReinvocations()), Utils.humanize(ruleReport.getReinvocationSubs()), Utils.humanize(ruleReport.getRematches()), Utils.humanize(ruleReport.getRematchSubs()), Utils.humanize(ruleReport.getRemismatches()), Utils.humanize(ruleReport.getRemismatchSubs()), ruleReport.getReinvocationShare() * 100.0, ruleReport.getReinvocationShare2() * 100.0));
            }
            return stringBuilder.toString();
        }

        public Report sortByInvocations() {
            Collections.sort(this.ruleReports, new Comparator<RuleReport>(){

                @Override
                public int compare(RuleReport ruleReport, RuleReport ruleReport2) {
                    return Report.this.intCompare(ruleReport.getInvocations(), ruleReport2.getInvocations());
                }
            });
            return this;
        }

        public Report sortBySubInvocations() {
            Collections.sort(this.ruleReports, new Comparator<RuleReport>(){

                @Override
                public int compare(RuleReport ruleReport, RuleReport ruleReport2) {
                    return Report.this.intCompare(ruleReport.getInvocationSubs(), ruleReport2.getInvocationSubs());
                }
            });
            return this;
        }

        public Report sortByTime() {
            Collections.sort(this.ruleReports, new Comparator<RuleReport>(){

                @Override
                public int compare(RuleReport ruleReport, RuleReport ruleReport2) {
                    return Report.this.longCompare(ruleReport.getNanoTime(), ruleReport2.getNanoTime());
                }
            });
            return this;
        }

        public Report sortByTimePerInvocation() {
            Collections.sort(this.ruleReports, new Comparator<RuleReport>(){

                @Override
                public int compare(RuleReport ruleReport, RuleReport ruleReport2) {
                    return Report.this.doubleCompare((double)ruleReport.getNanoTime() / (double)ruleReport.getInvocations(), (double)ruleReport2.getNanoTime() / (double)ruleReport2.getInvocations());
                }
            });
            return this;
        }

        public Report sortByMatches() {
            Collections.sort(this.ruleReports, new Comparator<RuleReport>(){

                @Override
                public int compare(RuleReport ruleReport, RuleReport ruleReport2) {
                    return Report.this.intCompare(ruleReport.getMatches(), ruleReport2.getMatches());
                }
            });
            return this;
        }

        public Report sortByMismatches() {
            Collections.sort(this.ruleReports, new Comparator<RuleReport>(){

                @Override
                public int compare(RuleReport ruleReport, RuleReport ruleReport2) {
                    return Report.this.intCompare(ruleReport.getMismatches(), ruleReport2.getMismatches());
                }
            });
            return this;
        }

        public Report sortByReinvocations() {
            Collections.sort(this.ruleReports, new Comparator<RuleReport>(){

                @Override
                public int compare(RuleReport ruleReport, RuleReport ruleReport2) {
                    return Report.this.intCompare(ruleReport.getReinvocations(), ruleReport2.getReinvocations());
                }
            });
            return this;
        }

        public Report sortByResubinvocations() {
            Collections.sort(this.ruleReports, new Comparator<RuleReport>(){

                @Override
                public int compare(RuleReport ruleReport, RuleReport ruleReport2) {
                    return Report.this.doubleCompare(ruleReport.getReinvocationSubs(), ruleReport2.getReinvocationSubs());
                }
            });
            return this;
        }

        public Report sortByRematches() {
            Collections.sort(this.ruleReports, new Comparator<RuleReport>(){

                @Override
                public int compare(RuleReport ruleReport, RuleReport ruleReport2) {
                    return Report.this.intCompare(ruleReport.getRematches(), ruleReport2.getRematches());
                }
            });
            return this;
        }

        public Report sortByRemismatches() {
            Collections.sort(this.ruleReports, new Comparator<RuleReport>(){

                @Override
                public int compare(RuleReport ruleReport, RuleReport ruleReport2) {
                    return Report.this.intCompare(ruleReport.getRemismatches(), ruleReport2.getRemismatches());
                }
            });
            return this;
        }

        public Report sortByResubmismatches() {
            Collections.sort(this.ruleReports, new Comparator<RuleReport>(){

                @Override
                public int compare(RuleReport ruleReport, RuleReport ruleReport2) {
                    return Report.this.doubleCompare(ruleReport.getRemismatchSubs(), ruleReport2.getRemismatchSubs());
                }
            });
            return this;
        }

        private int intCompare(int n, int n2) {
            return n < n2 ? 1 : (n > n2 ? -1 : 0);
        }

        private int longCompare(long l, long l2) {
            return l < l2 ? 1 : (l > l2 ? -1 : 0);
        }

        private int doubleCompare(double d, double d2) {
            return d < d2 ? 1 : (d > d2 ? -1 : 0);
        }
    }

    private static class RuleStats {
        private int matches;
        private int mismatches;
        private int matchSubs;
        private int mismatchSubs;
        private int rematchSubs;
        private int remismatchSubs;
        private long nanoTime;
        private final Map<Integer, Integer> positionMatches = new HashMap<Integer, Integer>();

        private RuleStats() {
        }

        private void clear() {
            this.matches = 0;
            this.mismatches = 0;
            this.matchSubs = 0;
            this.mismatchSubs = 0;
            this.rematchSubs = 0;
            this.remismatchSubs = 0;
            this.nanoTime = 0L;
            this.positionMatches.clear();
        }
    }
}

