/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.support;

import java.util.Arrays;
import org.parboiled.common.Preconditions;
import org.parboiled.common.StringUtils;

public class Characters {
    private static final char[] NO_CHARS = new char[0];
    public static final Characters NONE = new Characters(false, NO_CHARS);
    public static final Characters ALL = new Characters(true, NO_CHARS);
    private final boolean subtractive;
    private final char[] chars;

    private Characters(boolean bl, char[] cArray) {
        this.subtractive = bl;
        this.chars = Preconditions.checkArgNotNull(cArray, "chars");
    }

    public boolean isSubtractive() {
        return this.subtractive;
    }

    public char[] getChars() {
        return this.chars;
    }

    public Characters add(char c) {
        return this.subtractive ? this.removeFromChars(c) : this.addToChars(c);
    }

    public Characters remove(char c) {
        return this.subtractive ? this.addToChars(c) : this.removeFromChars(c);
    }

    public boolean contains(char c) {
        return Characters.indexOf(this.chars, c) == -1 ? this.subtractive : !this.subtractive;
    }

    public Characters add(Characters characters2) {
        Preconditions.checkArgNotNull(characters2, "other");
        if (!this.subtractive && !characters2.subtractive) {
            return this.addToChars(characters2.chars);
        }
        if (this.subtractive && characters2.subtractive) {
            return this.retainAllChars(characters2.chars);
        }
        return this.subtractive ? this.removeFromChars(characters2.chars) : characters2.removeFromChars(this.chars);
    }

    public Characters remove(Characters characters2) {
        Preconditions.checkArgNotNull(characters2, "other");
        if (!this.subtractive && !characters2.subtractive) {
            return this.removeFromChars(characters2.chars);
        }
        if (this.subtractive && characters2.subtractive) {
            return new Characters(false, characters2.removeFromChars((char[])this.chars).chars);
        }
        return this.subtractive ? this.addToChars(characters2.chars) : this.retainAllChars(characters2.chars);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.subtractive ? "![" : "[");
        for (char c : this.chars) {
            stringBuilder.append(StringUtils.escape(c));
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Characters)) {
            return false;
        }
        Characters characters2 = (Characters)object;
        return this.subtractive == characters2.subtractive && Characters.equivalent(this.chars, characters2.chars);
    }

    public int hashCode() {
        int n = this.subtractive ? 1 : 0;
        n = 31 * n + Arrays.hashCode(this.chars);
        return n;
    }

    private Characters addToChars(char[] cArray) {
        Characters characters2 = this;
        for (char c : cArray) {
            characters2 = characters2.addToChars(c);
        }
        return characters2;
    }

    private Characters addToChars(char c) {
        if (Characters.indexOf(this.chars, c) != -1) {
            return this;
        }
        char[] cArray = new char[this.chars.length + 1];
        System.arraycopy(this.chars, 0, cArray, 0, this.chars.length);
        cArray[this.chars.length] = c;
        return new Characters(this.subtractive, cArray);
    }

    private Characters removeFromChars(char[] cArray) {
        Characters characters2 = this;
        for (char c : cArray) {
            characters2 = characters2.removeFromChars(c);
        }
        return characters2;
    }

    private Characters removeFromChars(char c) {
        int n = Characters.indexOf(this.chars, c);
        if (n == -1) {
            return this;
        }
        if (this.chars.length == 1) {
            return this.subtractive ? ALL : NONE;
        }
        char[] cArray = new char[this.chars.length - 1];
        System.arraycopy(this.chars, 0, cArray, 0, n);
        System.arraycopy(this.chars, n + 1, cArray, n, this.chars.length - n - 1);
        return new Characters(this.subtractive, cArray);
    }

    private Characters retainAllChars(char[] cArray) {
        Characters characters2 = this;
        for (char c : this.chars) {
            if (Characters.indexOf(cArray, c) != -1) continue;
            characters2 = characters2.removeFromChars(c);
        }
        return characters2;
    }

    private static int indexOf(char[] cArray, char c) {
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != c) continue;
            return i;
        }
        return -1;
    }

    private static boolean equivalent(char[] cArray, char[] cArray2) {
        Preconditions.checkArgNotNull(cArray, "a");
        Preconditions.checkArgNotNull(cArray2, "b");
        if (cArray == cArray2) {
            return true;
        }
        int n = cArray.length;
        if (cArray2.length != n) {
            return false;
        }
        block0: for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            for (int j = 0; j < n; ++j) {
                if (c == cArray2[j]) continue block0;
            }
            return false;
        }
        return true;
    }

    public static Characters of(char c) {
        return new Characters(false, new char[]{c});
    }

    public static Characters of(char ... cArray) {
        return cArray.length == 0 ? NONE : new Characters(false, (char[])cArray.clone());
    }

    public static Characters of(String string2) {
        return StringUtils.isEmpty(string2) ? NONE : new Characters(false, string2.toCharArray());
    }

    public static Characters allBut(char c) {
        return new Characters(true, new char[]{c});
    }

    public static Characters allBut(char ... cArray) {
        return cArray.length == 0 ? ALL : new Characters(true, (char[])cArray.clone());
    }

    public static Characters allBut(String string2) {
        return StringUtils.isEmpty(string2) ? ALL : new Characters(true, string2.toCharArray());
    }
}

