/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.support;

import java.util.LinkedList;
import org.parboiled.common.ConsoleSink;
import org.parboiled.common.Sink;
import org.parboiled.common.StringUtils;
import org.parboiled.support.DefaultValueStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebuggingValueStack<V>
extends DefaultValueStack<V> {
    public final Sink<String> log;

    public DebuggingValueStack() {
        this(new ConsoleSink());
    }

    public DebuggingValueStack(Sink<String> sink) {
        this.log = sink;
    }

    public DebuggingValueStack(Iterable<V> iterable) {
        this(iterable, new ConsoleSink());
    }

    public DebuggingValueStack(Iterable<V> iterable, Sink<String> sink) {
        super(iterable);
        this.log = sink;
    }

    @Override
    public void clear() {
        if (this.head != null) {
            super.clear();
            this.log("clear");
        }
    }

    @Override
    public void restoreSnapshot(Object object) {
        if (this.head == null && object == null || this.head != null && this.head.equals(object)) {
            return;
        }
        super.restoreSnapshot(object);
        this.log("restoreSnapshot");
    }

    @Override
    public void push(V v) {
        super.push(v);
        this.log("push");
    }

    @Override
    public void push(int n, V v) {
        super.push(n, v);
        this.log("push");
    }

    @Override
    public V pop(int n) {
        Object v = super.pop(n);
        this.log("pop");
        return v;
    }

    @Override
    public void poke(int n, V v) {
        super.poke(n, v);
        this.log("poke");
    }

    @Override
    public void swap() {
        super.swap();
        this.log("swap");
    }

    @Override
    public void swap3() {
        super.swap3();
        this.log("swap3");
    }

    @Override
    public void swap4() {
        super.swap4();
        this.log("swap4");
    }

    @Override
    public void swap5() {
        super.swap5();
        this.log("swap5");
    }

    @Override
    public void swap6() {
        super.swap6();
        this.log("swap6");
    }

    protected void log(String string2) {
        this.log.receive(string2);
        this.log.receive(StringUtils.repeat(' ', 15 - string2.length()));
        this.log.receive(": ");
        LinkedList linkedList = new LinkedList();
        for (Object v : this) {
            linkedList.addFirst(v);
        }
        this.log.receive(StringUtils.join(linkedList, ", "));
        this.log.receive("\n");
    }
}

