/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.support;

import java.util.HashSet;
import java.util.Set;
import org.parboiled.Context;
import org.parboiled.Node;
import org.parboiled.Rule;
import org.parboiled.common.Predicate;
import org.parboiled.common.Predicates;
import org.parboiled.common.Tuple2;
import org.parboiled.matchers.Matcher;
import org.parboiled.matchers.MatcherUtils;
import org.parboiled.support.MatcherPath;
import org.parboiled.trees.GraphUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Filters {
    public static final Predicate<Node<Object>> SKIP_EMPTY_OPTS = new Predicate<Node<Object>>(){

        @Override
        public boolean apply(Node<Object> node) {
            return GraphUtils.hasChildren(node) || node.getEndIndex() != node.getStartIndex() || !"Optional".equals(node.getLabel());
        }
    };
    public static final Predicate<Node<Object>> SKIP_EMPTY_ZOMS = new Predicate<Node<Object>>(){

        @Override
        public boolean apply(Node<Object> node) {
            return GraphUtils.hasChildren(node) || node.getEndIndex() != node.getStartIndex() || !"ZeroOrMore".equals(node.getLabel());
        }
    };
    public static final Predicate<Node<Object>> SKIP_EMPTY_OPTS_AND_ZOMS = Predicates.and(SKIP_EMPTY_OPTS, SKIP_EMPTY_ZOMS);

    public static Predicate<Matcher> preventLoops() {
        return new Predicate<Matcher>(){
            private final Set<Matcher> visited = new HashSet<Matcher>();

            @Override
            public boolean apply(Matcher matcher) {
                if (this.visited.contains(matcher = MatcherUtils.unwrap(matcher))) {
                    return false;
                }
                this.visited.add(matcher);
                return true;
            }
        };
    }

    public static Predicate<Tuple2<Context<?>, Boolean>> lines(final int n, final int n2) {
        return new Predicate<Tuple2<Context<?>, Boolean>>(){

            @Override
            public boolean apply(Tuple2<Context<?>, Boolean> tuple23) {
                int n3 = ((Context)tuple23.a).getInputBuffer().getPosition((int)((Context)tuple23.a).getCurrentIndex()).line;
                return n <= n3 && n3 <= n2;
            }
        };
    }

    public static Predicate<Tuple2<Context<?>, Boolean>> fromLine(final int n) {
        return new Predicate<Tuple2<Context<?>, Boolean>>(){

            @Override
            public boolean apply(Tuple2<Context<?>, Boolean> tuple23) {
                return ((Context)tuple23.a).getInputBuffer().getPosition((int)((Context)tuple23.a).getCurrentIndex()).line >= n;
            }
        };
    }

    public static Predicate<Tuple2<Context<?>, Boolean>> untilLine(final int n) {
        return new Predicate<Tuple2<Context<?>, Boolean>>(){

            @Override
            public boolean apply(Tuple2<Context<?>, Boolean> tuple23) {
                return ((Context)tuple23.a).getInputBuffer().getPosition((int)((Context)tuple23.a).getCurrentIndex()).line <= n;
            }
        };
    }

    public static Predicate<Tuple2<Context<?>, Boolean>> rules(final Rule ... ruleArray) {
        return new Predicate<Tuple2<Context<?>, Boolean>>(){

            @Override
            public boolean apply(Tuple2<Context<?>, Boolean> tuple23) {
                MatcherPath matcherPath = ((Context)tuple23.a).getPath();
                for (Rule rule2 : ruleArray) {
                    if (!matcherPath.contains((Matcher)rule2)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Predicate<Tuple2<Context<?>, Boolean>> onlyRules(final Rule ... ruleArray) {
        return new Predicate<Tuple2<Context<?>, Boolean>>(){

            @Override
            public boolean apply(Tuple2<Context<?>, Boolean> tuple23) {
                for (Rule rule2 : ruleArray) {
                    if (((Context)tuple23.a).getMatcher() != rule2) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Predicate<Tuple2<Context<?>, Boolean>> rulesBelow(final Rule ... ruleArray) {
        return new Predicate<Tuple2<Context<?>, Boolean>>(){

            @Override
            public boolean apply(Tuple2<Context<?>, Boolean> tuple23) {
                MatcherPath matcherPath = ((Context)tuple23.a).getPath();
                for (Rule rule2 : ruleArray) {
                    Matcher matcher = (Matcher)rule2;
                    if (((Context)tuple23.a).getMatcher() == matcher || !matcherPath.contains(matcher)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Predicate<Tuple2<Context<?>, Boolean>> onlyMatches() {
        return new Predicate<Tuple2<Context<?>, Boolean>>(){

            @Override
            public boolean apply(Tuple2<Context<?>, Boolean> tuple23) {
                return (Boolean)tuple23.b;
            }
        };
    }

    public static Predicate<Tuple2<Context<?>, Boolean>> onlyMismatches() {
        return new Predicate<Tuple2<Context<?>, Boolean>>(){

            @Override
            public boolean apply(Tuple2<Context<?>, Boolean> tuple23) {
                return (Boolean)tuple23.b == false;
            }
        };
    }
}

