/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.support;

import java.util.Collection;
import java.util.List;
import org.parboiled.Node;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.common.Preconditions;
import org.parboiled.common.Predicate;
import org.parboiled.common.Predicates;
import org.parboiled.common.StringUtils;
import org.parboiled.support.LabelPrefixPredicate;
import org.parboiled.support.NodeFormatter;
import org.parboiled.support.ParsingResult;
import org.parboiled.trees.GraphUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParseTreeUtils {
    private ParseTreeUtils() {
    }

    public static <V> Node<V> findNodeByPath(Node<V> node, String string2) {
        Preconditions.checkArgNotNull(string2, "path");
        return node != null && GraphUtils.hasChildren(node) ? ParseTreeUtils.findNodeByPath(node.getChildren(), string2) : null;
    }

    public static <V> Node<V> findNodeByPath(List<Node<V>> list, String string2) {
        Preconditions.checkArgNotNull(string2, "path");
        if (list != null && !list.isEmpty()) {
            int n = string2.indexOf(47);
            String string3 = n != -1 ? string2.substring(0, n) : string2;
            int n2 = 0;
            int n3 = 1;
            if (string3.startsWith("last:")) {
                string3 = string3.substring(5);
                n2 = list.size() - 1;
                n3 = -1;
            }
            for (int i = n2; 0 <= i && i < list.size(); i += n3) {
                Node<V> node = list.get(i);
                if (!StringUtils.startsWith(node.getLabel(), string3)) continue;
                return n == -1 ? node : ParseTreeUtils.findNodeByPath(node, string2.substring(n + 1));
            }
        }
        return null;
    }

    public static <V, C extends Collection<Node<V>>> C collectNodesByPath(Node<V> node, String string2, C c) {
        Preconditions.checkArgNotNull(string2, "path");
        Preconditions.checkArgNotNull(c, "collection");
        return node != null && GraphUtils.hasChildren(node) ? ParseTreeUtils.collectNodesByPath(node.getChildren(), string2, c) : c;
    }

    public static <V, C extends Collection<Node<V>>> C collectNodesByPath(List<Node<V>> list, String string2, C c) {
        Preconditions.checkArgNotNull(string2, "path");
        Preconditions.checkArgNotNull(c, "collection");
        if (list != null && !list.isEmpty()) {
            int n = string2.indexOf(47);
            String string3 = n != -1 ? string2.substring(0, n) : string2;
            for (Node<V> node : list) {
                if (!StringUtils.startsWith(node.getLabel(), string3)) continue;
                if (n == -1) {
                    c.add(node);
                    continue;
                }
                ParseTreeUtils.collectNodesByPath(node, string2.substring(n + 1), c);
            }
        }
        return c;
    }

    public static <V> Node<V> findNode(Node<V> node, Predicate<Node<V>> predicate) {
        Preconditions.checkArgNotNull(predicate, "predicate");
        if (node != null) {
            Node<V> node2;
            if (predicate.apply(node)) {
                return node;
            }
            if (GraphUtils.hasChildren(node) && (node2 = ParseTreeUtils.findNode(node.getChildren(), predicate)) != null) {
                return node2;
            }
        }
        return null;
    }

    public static <V> Node<V> findNode(List<Node<V>> list, Predicate<Node<V>> predicate) {
        Preconditions.checkArgNotNull(predicate, "predicate");
        if (list != null && !list.isEmpty()) {
            for (Node<V> node : list) {
                Node<V> node2 = ParseTreeUtils.findNode(node, predicate);
                if (node2 == null) continue;
                return node2;
            }
        }
        return null;
    }

    public static <V> Node<V> findNodeByLabel(Node<V> node, String string2) {
        return ParseTreeUtils.findNode(node, new LabelPrefixPredicate(string2));
    }

    public static <V> Node<V> findNodeByLabel(List<Node<V>> list, String string2) {
        return ParseTreeUtils.findNode(list, new LabelPrefixPredicate(string2));
    }

    public static <V> Node<V> findLastNode(Node<V> node, Predicate<Node<V>> predicate) {
        Preconditions.checkArgNotNull(predicate, "predicate");
        if (node != null) {
            Node<V> node2;
            if (predicate.apply(node)) {
                return node;
            }
            if (GraphUtils.hasChildren(node) && (node2 = ParseTreeUtils.findLastNode(node.getChildren(), predicate)) != null) {
                return node2;
            }
        }
        return null;
    }

    public static <V> Node<V> findLastNode(List<Node<V>> list, Predicate<Node<V>> predicate) {
        Preconditions.checkArgNotNull(predicate, "predicate");
        if (list != null && !list.isEmpty()) {
            int n = list.size();
            for (int i = n - 1; i >= 0; --i) {
                Node<V> node = ParseTreeUtils.findLastNode(list.get(i), predicate);
                if (node == null) continue;
                return node;
            }
        }
        return null;
    }

    public static <V, C extends Collection<Node<V>>> C collectNodes(Node<V> node, Predicate<Node<V>> predicate, C c) {
        Preconditions.checkArgNotNull(predicate, "predicate");
        Preconditions.checkArgNotNull(c, "collection");
        return node != null && GraphUtils.hasChildren(node) ? ParseTreeUtils.collectNodes(node.getChildren(), predicate, c) : c;
    }

    public static String getNodeText(Node<?> node, InputBuffer inputBuffer) {
        Preconditions.checkArgNotNull(node, "node");
        Preconditions.checkArgNotNull(inputBuffer, "inputBuffer");
        if (node.hasError()) {
            StringBuilder stringBuilder = new StringBuilder();
            block6: for (int i = node.getStartIndex(); i < node.getEndIndex(); ++i) {
                char c = inputBuffer.charAt(i);
                switch (c) {
                    case '\ufdea': {
                        ++i;
                        continue block6;
                    }
                    case '\ufdeb': 
                    case '\uffff': {
                        continue block6;
                    }
                    case '\ufded': {
                        ++i;
                        while (inputBuffer.charAt(i) != '\ufdee') {
                            ++i;
                        }
                        continue block6;
                    }
                    case '\ufdec': 
                    case '\ufdee': 
                    case '\ufdef': {
                        throw new IllegalStateException();
                    }
                    default: {
                        stringBuilder.append(c);
                    }
                }
            }
            return stringBuilder.toString();
        }
        return inputBuffer.extract(node.getStartIndex(), node.getEndIndex());
    }

    public static <V, C extends Collection<Node<V>>> C collectNodes(List<Node<V>> list, Predicate<Node<V>> predicate, C c) {
        Preconditions.checkArgNotNull(predicate, "predicate");
        Preconditions.checkArgNotNull(c, "collection");
        if (list != null && !list.isEmpty()) {
            for (Node<V> node : list) {
                if (predicate.apply(node)) {
                    c.add(node);
                }
                ParseTreeUtils.collectNodes(node, predicate, c);
            }
        }
        return c;
    }

    public static <V> String printNodeTree(ParsingResult<V> parsingResult) {
        Preconditions.checkArgNotNull(parsingResult, "parsingResult");
        return ParseTreeUtils.printNodeTree(parsingResult, Predicates.<Node<V>>alwaysTrue(), Predicates.<Node<V>>alwaysTrue());
    }

    public static <V> String printNodeTree(ParsingResult<V> parsingResult, Predicate<Node<V>> predicate, Predicate<Node<V>> predicate2) {
        Preconditions.checkArgNotNull(parsingResult, "parsingResult");
        Preconditions.checkArgNotNull(predicate, "nodeFilter");
        Preconditions.checkArgNotNull(predicate2, "subTreeFilter");
        return GraphUtils.printTree(parsingResult.parseTreeRoot, new NodeFormatter(parsingResult.inputBuffer), predicate, predicate2);
    }
}

