/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class FixedHelpFormatter
extends HelpFormatter {
    protected StringBuffer renderOptions(StringBuffer sb, int width, Options options, int leftPad, int descPad) {
        StringBuffer optBuf;
        String lpad = this.createPadding(leftPad);
        String dpad = this.createPadding(descPad);
        ArrayList<StringBuffer> prefixList = new ArrayList<StringBuffer>();
        List optList = options.helpOptions();
        Collections.sort(optList, this.getOptionComparator());
        int max = 0;
        for (Option option : optList) {
            optBuf = new StringBuffer(8);
            if (option.getOpt() == null) {
                optBuf.append(lpad).append("   ").append(this.getLongOptPrefix()).append(option.getLongOpt());
            } else {
                optBuf.append(lpad).append(this.getOptPrefix()).append(option.getOpt());
                if (option.hasLongOpt()) {
                    optBuf.append(',').append(this.getLongOptPrefix()).append(option.getLongOpt());
                }
            }
            if (option.hasArg()) {
                if (option.hasArgName()) {
                    if (option.isRequired()) {
                        optBuf.append(" <").append(option.getArgName()).append('>');
                    } else {
                        optBuf.append(" [").append(option.getArgName()).append(']');
                    }
                } else {
                    optBuf.append(' ');
                }
            }
            prefixList.add(optBuf);
            max = optBuf.length() > max ? optBuf.length() : max;
        }
        int x = 0;
        Iterator i = optList.iterator();
        while (i.hasNext()) {
            Option option = (Option)i.next();
            if ((optBuf = new StringBuffer(((StringBuffer)prefixList.get(x++)).toString())).length() < max) {
                optBuf.append(this.createPadding(max - optBuf.length()));
            }
            optBuf.append(dpad);
            int nextLineTabStop = max + descPad;
            if (option.getDescription() != null) {
                optBuf.append(option.getDescription());
            }
            this.renderWrappedText(sb, width, nextLineTabStop, optBuf.toString());
            if (!i.hasNext()) continue;
            sb.append(this.getNewLine());
        }
        return sb;
    }
}

