/*
 * Decompiled with CFR 0.152.
 */
package org.openjax.json;

import java.util.List;
import java.util.Map;
import org.openjax.json.JsonStrings;

public final class JSON {
    private static String encode(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof String) {
            return JsonStrings.escape((String)obj).insert(0, '\"').append('\"').toString();
        }
        if (obj instanceof Boolean || obj instanceof Number) {
            return obj.toString();
        }
        if (obj instanceof List) {
            return JSON.toString((List)obj).replaceAll("\n", "\n  ");
        }
        if (obj instanceof Map) {
            return JSON.toString((Map)obj).replaceAll("\n", "\n  ");
        }
        throw new IllegalArgumentException("Illegal object of class: " + obj.getClass().getName());
    }

    public static String toString(Map<String, ?> object) {
        StringBuilder builder = new StringBuilder("{");
        if (object != null) {
            for (Map.Entry<String, ?> entry : object.entrySet()) {
                builder.append("\n  \"").append((CharSequence)JsonStrings.escape(entry.getKey())).append("\": ").append(JSON.encode(entry.getValue())).append(',');
            }
        }
        if (builder.length() > 1) {
            builder.setCharAt(builder.length() - 1, '\n');
        }
        return builder.append('}').toString();
    }

    public static String toString(List<?> array) {
        if (array == null) {
            return "null";
        }
        StringBuilder builder = new StringBuilder("[");
        boolean backUp = false;
        for (int i = 0; i < array.size(); ++i) {
            Object member = array.get(i);
            String s = JSON.encode(member);
            if (member instanceof Map || member instanceof List) {
                if (i > 0) {
                    builder.append(' ');
                } else {
                    backUp = true;
                }
            } else {
                builder.append("\n  ");
            }
            builder.append(backUp ? s.replaceAll("\n  ", "\n") : s).append(',');
        }
        if (builder.length() > 1) {
            if (backUp) {
                builder.setLength(builder.length() - 1);
            } else {
                builder.setCharAt(builder.length() - 1, '\n');
            }
        }
        return builder.append(']').toString();
    }

    private JSON() {
    }
}

