/*
 * Decompiled with CFR 0.152.
 */
package org.openjax.json;

import java.io.IOException;
import java.util.Objects;
import org.openjax.json.JsonHandler;
import org.openjax.json.JsonParseException;
import org.openjax.json.JsonReader;

public class JsonParser {
    private final JsonReader reader;

    public JsonParser(JsonReader reader) {
        this.reader = Objects.requireNonNull(reader);
    }

    public boolean parse(JsonHandler handler) throws IOException, JsonParseException {
        int start;
        if (this.reader.getPosition() == 0) {
            handler.startDocument();
        }
        while ((start = this.reader.readTokenStart()) != -1) {
            boolean abort;
            int end = this.reader.getPosition();
            if (end - start == 1 && JsonReader.isStructural(this.reader.buf()[start])) {
                abort = !handler.structural(this.reader.buf()[start]);
            } else if (JsonReader.isWhitespace(this.reader.buf()[start])) {
                abort = !handler.whitespace(this.reader.buf(), start, end);
            } else {
                boolean bl = abort = !handler.characters(this.reader.buf(), start, end);
            }
            if (abort) continue;
            return abort;
        }
        handler.endDocument();
        return true;
    }
}

