/*
 * Decompiled with CFR 0.152.
 */
package org.openjax.json;

public final class JsonStrings {
    public static StringBuilder escape(String string) {
        StringBuilder builder = new StringBuilder(string.length());
        int len = string.length();
        block8: for (int i = 0; i < len; ++i) {
            char ch = string.charAt(i);
            switch (ch) {
                case '\"': 
                case '\\': {
                    builder.append('\\').append(ch);
                    continue block8;
                }
                case '\n': {
                    builder.append("\\n");
                    continue block8;
                }
                case '\r': {
                    builder.append("\\r");
                    continue block8;
                }
                case '\t': {
                    builder.append("\\t");
                    continue block8;
                }
                case '\b': {
                    builder.append("\\b");
                    continue block8;
                }
                case '\f': {
                    builder.append("\\f");
                    continue block8;
                }
                default: {
                    if (ch <= '\u001f') {
                        builder.append(String.format("\\u%04x", ch));
                        continue block8;
                    }
                    builder.append(ch);
                }
            }
        }
        return builder;
    }

    public static String unescapeForString(String string) {
        StringBuilder builder = new StringBuilder(string.length());
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            int ch = string.charAt(i);
            if (ch == 92) {
                if ((ch = string.charAt(++i)) == 34 || ch == 92) {
                    builder.append('\\');
                } else if (ch == 110) {
                    ch = 10;
                } else if (ch == 114) {
                    ch = 13;
                } else if (ch == 116) {
                    ch = 9;
                } else if (ch == 98) {
                    ch = 8;
                } else if (ch == 102) {
                    ch = 12;
                } else if (ch == 117) {
                    ++i;
                    char[] unicode = new char[4];
                    for (int j = 0; j < unicode.length; ++j) {
                        unicode[j] = string.charAt(i + j);
                    }
                    i += unicode.length - 1;
                    ch = (char)Integer.parseInt(new String(unicode), 16);
                }
            }
            builder.append((char)ch);
        }
        return builder.toString();
    }

    public static String unescape(String string) {
        StringBuilder builder = new StringBuilder(string.length());
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            int ch = string.charAt(i);
            if (ch == 92) {
                if ((ch = string.charAt(++i)) == 110) {
                    ch = 10;
                } else if (ch == 114) {
                    ch = 13;
                } else if (ch == 116) {
                    ch = 9;
                } else if (ch == 98) {
                    ch = 8;
                } else if (ch == 102) {
                    ch = 12;
                } else if (ch == 117) {
                    ++i;
                    char[] unicode = new char[4];
                    for (int j = 0; j < unicode.length; ++j) {
                        unicode[j] = string.charAt(i + j);
                    }
                    i += unicode.length - 1;
                    ch = (char)Integer.parseInt(new String(unicode), 16);
                }
            }
            builder.append((char)ch);
        }
        return builder.toString();
    }

    private JsonStrings() {
    }
}

