/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.quality.CheckstyleExtension;
import org.gradle.api.plugins.quality.CheckstylePlugin;
import org.openrewrite.gradle.AbstractRewriteTask;
import org.openrewrite.gradle.DefaultRewriteExtension;
import org.openrewrite.gradle.ResolveRewriteDependenciesTask;
import org.openrewrite.gradle.RewriteClearCacheTask;
import org.openrewrite.gradle.RewriteDiscoverTask;
import org.openrewrite.gradle.RewriteDryRunTask;
import org.openrewrite.gradle.RewriteRunTask;

public class RewritePlugin
implements Plugin<Project> {
    public void apply(Project project) {
        boolean isRootProject;
        boolean bl = isRootProject = project == project.getRootProject();
        if (!isRootProject && project.getRootProject().getPluginManager().hasPlugin("org.openrewrite.rewrite")) {
            return;
        }
        DefaultRewriteExtension extension = (DefaultRewriteExtension)project.getExtensions().create("rewrite", DefaultRewriteExtension.class, new Object[]{project});
        Configuration rewriteConf = (Configuration)project.getConfigurations().maybeCreate("rewrite");
        ResolveRewriteDependenciesTask resolveRewriteDependenciesTask = ((ResolveRewriteDependenciesTask)project.getTasks().create("rewriteResolveDependencies", ResolveRewriteDependenciesTask.class)).setExtension(extension).setConfiguration(rewriteConf);
        RewriteRunTask rewriteRun = (RewriteRunTask)((Object)((AbstractRewriteTask)((Object)((RewriteRunTask)project.getTasks().create("rewriteRun", RewriteRunTask.class)).setExtension(extension))).setResolveDependenciesTask(resolveRewriteDependenciesTask));
        RewriteDryRunTask rewriteDryRun = (RewriteDryRunTask)((Object)((AbstractRewriteTask)((Object)((RewriteDryRunTask)project.getTasks().create("rewriteDryRun", RewriteDryRunTask.class)).setExtension(extension))).setResolveDependenciesTask(resolveRewriteDependenciesTask));
        ((AbstractRewriteTask)((Object)((RewriteDiscoverTask)project.getTasks().create("rewriteDiscover", RewriteDiscoverTask.class)).setExtension(extension))).setResolveDependenciesTask(resolveRewriteDependenciesTask);
        ((AbstractRewriteTask)((Object)((RewriteClearCacheTask)project.getTasks().create("rewriteClearCache", RewriteClearCacheTask.class)).setExtension(extension))).setResolveDependenciesTask(resolveRewriteDependenciesTask);
        if (isRootProject) {
            project.allprojects(subproject -> RewritePlugin.configureProject(subproject, extension, rewriteDryRun, rewriteRun));
        } else {
            RewritePlugin.configureProject(project, extension, rewriteDryRun, rewriteRun);
        }
    }

    private static void configureProject(Project project, DefaultRewriteExtension extension, RewriteDryRunTask rewriteDryRun, RewriteRunTask rewriteRun) {
        project.getPlugins().all(plugin -> {
            if (plugin instanceof CheckstylePlugin) {
                CheckstyleExtension checkstyleExtension = (CheckstyleExtension)project.getExtensions().getByType(CheckstyleExtension.class);
                extension.checkstyleConfigProvider = () -> ((CheckstyleExtension)checkstyleExtension).getConfigFile();
                extension.checkstylePropertiesProvider = () -> ((CheckstyleExtension)checkstyleExtension).getConfigProperties();
            }
            if (!(plugin instanceof JavaBasePlugin)) {
                return;
            }
            JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
            javaConvention.getSourceSets().all(sourceSet -> {
                Task compileTask = project.getTasks().getByPath(sourceSet.getCompileJavaTaskName());
                rewriteRun.dependsOn(new Object[]{compileTask});
                rewriteDryRun.dependsOn(new Object[]{compileTask});
            });
        });
    }
}

