/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.util.GradleVersion;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrewrite.gradle.GradleSourceSetSpec;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010%\n\u0002\b\f\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010 \u001a\u00020\u0000J\u0010\u0010!\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0006J\u0010\u0010\u0005\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0006J\u0018\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020\u00062\b\b\u0001\u0010#\u001a\u00020\u0006J\u0018\u0010&\u001a\u00020\"2\u0006\u0010%\u001a\u00020\u00062\b\b\u0001\u0010#\u001a\u00020\u0006J\u0010\u0010\u0015\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0006J\u0010\u0010\u0018\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0006J;\u0010'\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u00062\b\b\u0002\u0010(\u001a\u00020)2\b\b\u0002\u0010*\u001a\u00020)2\u0017\u0010+\u001a\u0013\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\"0,\u00a2\u0006\u0002\b-J'\u0010.\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u00062\u0017\u0010+\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\"0,\u00a2\u0006\u0002\b-J\u0016\u0010/\u001a\u00020\"2\u0006\u0010%\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u0006R \u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR&\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0015\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\b\"\u0004\b\u0017\u0010\nR \u0010\u0018\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\b\"\u0004\b\u001a\u0010\nR\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00000\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/openrewrite/gradle/GradleProjectSpec;", "", "dir", "Ljava/io/File;", "(Ljava/io/File;)V", "checkstyleXml", "", "getCheckstyleXml", "()Ljava/lang/String;", "setCheckstyleXml", "(Ljava/lang/String;)V", "groovyBuildScript", "getGroovyBuildScript", "setGroovyBuildScript", "otherGradleScripts", "", "getOtherGradleScripts", "()Ljava/util/Map;", "setOtherGradleScripts", "(Ljava/util/Map;)V", "propertiesFiles", "rewriteYaml", "getRewriteYaml", "setRewriteYaml", "settingsGradle", "getSettingsGradle", "setSettingsGradle", "sourceSets", "", "Lorg/openrewrite/gradle/GradleSourceSetSpec;", "subprojects", "textFiles", "build", "buildGradle", "", "text", "otherGradleScript", "name", "propertiesFile", "sourceSet", "sourceCharset", "Ljava/nio/charset/Charset;", "resourceCharset", "init", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "subproject", "textFile", "plugin"})
@SourceDebugExtension(value={"SMAP\nGradleProjectSpec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleProjectSpec.kt\norg/openrewrite/gradle/GradleProjectSpec\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,304:1\n1855#2,2:305\n*S KotlinDebug\n*F\n+ 1 GradleProjectSpec.kt\norg/openrewrite/gradle/GradleProjectSpec\n*L\n128#1:305,2\n*E\n"})
public final class GradleProjectSpec {
    @NotNull
    private final File dir;
    @NotNull
    private final List<GradleProjectSpec> subprojects;
    @NotNull
    private final List<GradleSourceSetSpec> sourceSets;
    @Language(value="groovy")
    @Nullable
    private String groovyBuildScript;
    @NotNull
    private Map<String, String> otherGradleScripts;
    @Language(value="groovy")
    @Nullable
    private String settingsGradle;
    @Language(value="yaml")
    @Nullable
    private String rewriteYaml;
    @Language(value="xml")
    @Nullable
    private String checkstyleXml;
    @NotNull
    private final Map<String, String> propertiesFiles;
    @NotNull
    private final Map<String, String> textFiles;

    public GradleProjectSpec(@NotNull File dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        this.dir = dir;
        this.subprojects = new ArrayList();
        this.sourceSets = new ArrayList();
        this.otherGradleScripts = new LinkedHashMap();
        this.propertiesFiles = new LinkedHashMap();
        this.textFiles = new LinkedHashMap();
    }

    @Nullable
    public final String getGroovyBuildScript() {
        return this.groovyBuildScript;
    }

    public final void setGroovyBuildScript(@Nullable String string) {
        this.groovyBuildScript = string;
    }

    public final void buildGradle(@Language(value="groovy") @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.groovyBuildScript = StringsKt.trimIndent((String)text);
    }

    @NotNull
    public final Map<String, String> getOtherGradleScripts() {
        return this.otherGradleScripts;
    }

    public final void setOtherGradleScripts(@NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.otherGradleScripts = map;
    }

    public final void otherGradleScript(@NotNull String name, @Language(value="groovy") @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.otherGradleScripts.put(name, StringsKt.trimIndent((String)text));
    }

    @Nullable
    public final String getSettingsGradle() {
        return this.settingsGradle;
    }

    public final void setSettingsGradle(@Nullable String string) {
        this.settingsGradle = string;
    }

    public final void settingsGradle(@Language(value="groovy") @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.settingsGradle = StringsKt.trimIndent((String)text);
    }

    @Nullable
    public final String getRewriteYaml() {
        return this.rewriteYaml;
    }

    public final void setRewriteYaml(@Nullable String string) {
        this.rewriteYaml = string;
    }

    public final void rewriteYaml(@Language(value="yaml") @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.rewriteYaml = StringsKt.trimIndent((String)text);
    }

    @Nullable
    public final String getCheckstyleXml() {
        return this.checkstyleXml;
    }

    public final void setCheckstyleXml(@Nullable String string) {
        this.checkstyleXml = string;
    }

    public final void checkstyleXml(@Language(value="xml") @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.checkstyleXml = StringsKt.trimIndent((String)text);
    }

    public final void propertiesFile(@NotNull String name, @Language(value="properties") @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.propertiesFiles.put(name, text);
    }

    public final void textFile(@NotNull String name, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.textFiles.put(name, text);
    }

    @NotNull
    public final GradleProjectSpec subproject(@NotNull String name, @NotNull Function1<? super GradleProjectSpec, Unit> init) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(init, (String)"init");
        GradleProjectSpec gradleProjectSpec = new GradleProjectSpec(new File(this.dir, name));
        init.invoke((Object)gradleProjectSpec);
        GradleProjectSpec subproject = gradleProjectSpec;
        this.subprojects.add(subproject);
        return subproject;
    }

    @NotNull
    public final GradleSourceSetSpec sourceSet(@NotNull String name, @NotNull Charset sourceCharset, @NotNull Charset resourceCharset, @NotNull Function1<? super GradleSourceSetSpec, Unit> init) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)sourceCharset, (String)"sourceCharset");
        Intrinsics.checkNotNullParameter((Object)resourceCharset, (String)"resourceCharset");
        Intrinsics.checkNotNullParameter(init, (String)"init");
        GradleSourceSetSpec gradleSourceSetSpec = new GradleSourceSetSpec(name, sourceCharset, resourceCharset);
        init.invoke((Object)gradleSourceSetSpec);
        GradleSourceSetSpec sourceSet = gradleSourceSetSpec;
        this.sourceSets.add(sourceSet);
        return sourceSet;
    }

    public static /* synthetic */ GradleSourceSetSpec sourceSet$default(GradleProjectSpec gradleProjectSpec, String string, Charset charset, Charset charset2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            Charset charset3 = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset3, (String)"UTF_8");
            charset = charset3;
        }
        if ((n & 4) != 0) {
            Charset charset4 = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset4, (String)"UTF_8");
            charset2 = charset4;
        }
        return gradleProjectSpec.sourceSet(string, charset, charset2, (Function1<? super GradleSourceSetSpec, Unit>)function1);
    }

    @NotNull
    public final GradleProjectSpec build() {
        File file;
        Files.createDirectories(this.dir.toPath(), new FileAttribute[0]);
        Path settings = this.dir.toPath().resolve("settings.gradle");
        ArrayList<String> lines = new ArrayList<String>();
        if (this.settingsGradle == null) {
            String gradleVersionString = System.getProperty("org.openrewrite.test.gradleVersion", "8.0");
            GradleVersion gradleVersion = GradleVersion.version((String)gradleVersionString);
            if (gradleVersion.compareTo(GradleVersion.version((String)"5.0")) > 0) {
                lines.add(" pluginManagement {\n    repositories {\n        gradlePluginPortal()\n        mavenLocal()\n        mavenCentral()\n        google()\n        // jcenter is currently only required for AGP 3.*\n        jcenter()\n    }\n}\n\ndependencyResolutionManagement {\n    repositories {\n        gradlePluginPortal()\n        google()\n        mavenLocal()\n        mavenCentral()\n        maven {\n            url = uri(\"https://oss.sonatype.org/content/repositories/snapshots\")\n        }\n        // jcenter is currently only required for AGP 3.*\n        jcenter()\n    }\n}");
            }
            lines.add("rootProject.name = \"" + this.dir.getName() + '\"');
            if (!this.subprojects.isEmpty()) {
                Iterable $this$forEach$iv = this.subprojects;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    GradleProjectSpec subproject = (GradleProjectSpec)element$iv;
                    boolean bl = false;
                    lines.add("include('" + subproject.dir.getName() + "')");
                }
            }
        } else {
            String string = this.settingsGradle;
            Intrinsics.checkNotNull((Object)string);
            lines.add(string);
        }
        Files.write(settings, (Iterable<? extends CharSequence>)lines, new OpenOption[0]);
        if (this.groovyBuildScript != null) {
            File file2 = new File(this.dir, "build.gradle");
            String string = this.groovyBuildScript;
            Intrinsics.checkNotNull((Object)string);
            FilesKt.writeText$default((File)file2, (String)string, null, (int)2, null);
        }
        for (Map.Entry<String, String> entry : this.otherGradleScripts.entrySet()) {
            FilesKt.writeText$default((File)new File(this.dir, entry.getKey()), (String)entry.getValue(), null, (int)2, null);
        }
        if (this.rewriteYaml != null) {
            File file3 = new File(this.dir, "rewrite.yml");
            String string = this.rewriteYaml;
            Intrinsics.checkNotNull((Object)string);
            FilesKt.writeText$default((File)file3, (String)string, null, (int)2, null);
        }
        if (this.checkstyleXml != null) {
            Iterator<Object> iterator = new File(this.dir, "config/checkstyle/checkstyle.xml");
            Iterator<Map.Entry<String, String>> iterator2 = iterator;
            boolean bl = false;
            ((File)((Object)iterator2)).getParentFile().mkdirs();
            String string = this.checkstyleXml;
            Intrinsics.checkNotNull((Object)string);
            FilesKt.writeText$default(iterator2, (String)string, null, (int)2, null);
        }
        for (Map.Entry entry : this.propertiesFiles.entrySet()) {
            File $this$build_u24lambda_u242 = file = new File(this.dir, (String)entry.getKey());
            boolean bl = false;
            $this$build_u24lambda_u242.getParentFile().mkdirs();
            FilesKt.writeText$default((File)$this$build_u24lambda_u242, (String)((String)entry.getValue()), null, (int)2, null);
        }
        for (Map.Entry<String, String> entry : this.textFiles.entrySet()) {
            File $this$build_u24lambda_u243 = file = new File(this.dir, entry.getKey());
            boolean bl = false;
            $this$build_u24lambda_u243.getParentFile().mkdirs();
            FilesKt.writeText$default((File)$this$build_u24lambda_u243, (String)entry.getValue(), null, (int)2, null);
        }
        for (GradleSourceSetSpec gradleSourceSetSpec : this.sourceSets) {
            gradleSourceSetSpec.build(new File(this.dir, "src"));
        }
        for (GradleProjectSpec gradleProjectSpec : this.subprojects) {
            gradleProjectSpec.build();
        }
        return this;
    }
}

