/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.decoder;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.UnmodifiableComponent;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecoder;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.slf4j.Logger;

public abstract class AbstractMessageDecoder
extends AbstractInitializableComponent
implements MessageDecoder,
UnmodifiableComponent {
    @Nonnull
    public static final String BASE_PROTOCOL_MESSAGE_LOGGER_CATEGORY = "PROTOCOL_MESSAGE";
    @Nonnull
    private Logger protocolMessageLog = LoggerFactory.getLogger((String)"PROTOCOL_MESSAGE");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractMessageDecoder.class);
    @Nullable
    private MessageContext messageContext;
    @Nonnull
    private String protocolMessageLoggerSubCategory;

    @Override
    @Nullable
    public MessageContext getMessageContext() {
        return this.messageContext;
    }

    protected void setMessageContext(@Nullable MessageContext context) {
        this.messageContext = context;
    }

    @Override
    public void decode() throws MessageDecodingException {
        this.checkComponentActive();
        this.doDecode();
        this.logDecodedMessage();
    }

    @Nonnull
    protected Logger getProtocolMessageLogger() {
        return this.protocolMessageLog;
    }

    @Nonnull
    protected String getProtocolMessageLoggerSubCategory() {
        return this.protocolMessageLoggerSubCategory;
    }

    protected void setProtocolMessageLoggerSubCategory(@Nullable String category) {
        this.protocolMessageLoggerSubCategory = StringSupport.trimOrNull((String)category);
        this.protocolMessageLog = this.protocolMessageLoggerSubCategory != null ? LoggerFactory.getLogger((String)("PROTOCOL_MESSAGE." + this.protocolMessageLoggerSubCategory)) : LoggerFactory.getLogger((String)BASE_PROTOCOL_MESSAGE_LOGGER_CATEGORY);
    }

    protected void logDecodedMessage() {
        if (this.protocolMessageLog.isDebugEnabled()) {
            String serializedMessage = this.serializeMessageForLogging(this.getMessageToLog());
            if (serializedMessage == null) {
                this.log.debug("Serialized decoded protocol message was null, nothing to log");
                return;
            }
            this.protocolMessageLog.debug("\n" + serializedMessage);
        }
    }

    @Nullable
    protected Object getMessageToLog() {
        MessageContext mc = this.getMessageContext();
        return mc != null ? mc.getMessage() : null;
    }

    @Nullable
    protected String serializeMessageForLogging(@Nullable Object message) {
        return message != null ? message.toString() : null;
    }

    protected abstract void doDecode() throws MessageDecodingException;
}

