/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opensaml.saml.metadata.resolver.filter;

import javax.annotation.Nullable;

import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.primitive.StringSupport;

/**
 * Abstract base class for {@link MetadataFilter}.
 * 
 * @since 5.0.0
 */
public abstract class AbstractMetadataFilter extends AbstractInitializableComponent implements MetadataFilter {

    /** Filter type for logging/reporting. */
    @Nullable @NotEmpty private String filterType;
    
    /** {@inheritDoc} */
    @Nullable @NotEmpty public String getType() {
        return filterType;
    }
    
    /**
     * Set filter type for reporting/logging.
     * 
     * @param type filter type
     */
    public void setType(@Nullable @NotEmpty final String type) {
        filterType = StringSupport.trimOrNull(type);
    }

}