/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.binding.impl;

import com.google.common.base.Function;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.messaging.context.SAMLConsentContext;
import org.opensaml.saml.saml2.core.RequestAbstractType;

public class ExtractConsentFromRequestHandler
extends AbstractMessageHandler<RequestAbstractType> {
    @Nonnull
    private Function<MessageContext<RequestAbstractType>, SAMLConsentContext> consentContextStrategy = new ChildContextLookup(SAMLConsentContext.class, true);

    public synchronized void setConsentContextLookupStrategy(@Nonnull Function<MessageContext<RequestAbstractType>, SAMLConsentContext> strategy) {
        this.consentContextStrategy = (Function)Constraint.isNotNull(strategy, (String)"SAMLConsentContext lookup strategy cannot be null");
    }

    protected void doInvoke(@Nonnull MessageContext<RequestAbstractType> messageContext) throws MessageHandlerException {
        RequestAbstractType request = (RequestAbstractType)messageContext.getMessage();
        if (request == null) {
            throw new MessageHandlerException("Request was not found");
        }
        SAMLConsentContext consentContext = (SAMLConsentContext)this.consentContextStrategy.apply(messageContext);
        if (consentContext == null) {
            throw new MessageHandlerException("SAMLConsentContext to populate not found");
        }
        consentContext.setConsent(request.getConsent());
    }
}

