/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.impl;

import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ParentContextLookup;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.criterion.ProfileRequestContextCriterion;
import org.opensaml.saml.common.messaging.context.AbstractSAMLEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataLookupParametersContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLProtocolContext;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.criterion.ProtocolCriterion;
import org.opensaml.saml.metadata.criteria.entity.DetectDuplicateEntityIDsCriterion;
import org.opensaml.saml.metadata.resolver.DetectDuplicateEntityIDs;
import org.opensaml.saml.metadata.resolver.RoleDescriptorResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.slf4j.Logger;

public class SAMLMetadataLookupHandler
extends AbstractMessageHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SAMLMetadataLookupHandler.class);
    @NonnullAfterInit
    private RoleDescriptorResolver metadataResolver;
    @Nonnull
    private Class<? extends AbstractSAMLEntityContext> entityContextClass = SAMLPeerEntityContext.class;
    @Nullable
    private Function<MessageContext, SAMLMetadataContext> copyContextStrategy;
    @Nullable
    private Function<MessageContext, ProfileRequestContext> profileRequestContextLookupStrategy = new ParentContextLookup(ProfileRequestContext.class);

    public void setCopyContextStrategy(@Nullable Function<MessageContext, SAMLMetadataContext> strategy) {
        this.checkSetterPreconditions();
        this.copyContextStrategy = strategy;
    }

    public void setEntityContextClass(@Nonnull Class<? extends AbstractSAMLEntityContext> clazz) {
        this.checkSetterPreconditions();
        this.entityContextClass = (Class)Constraint.isNotNull(clazz, (String)"SAML entity context class may not be null");
    }

    public void setRoleDescriptorResolver(@Nonnull RoleDescriptorResolver resolver) {
        this.checkSetterPreconditions();
        this.metadataResolver = (RoleDescriptorResolver)Constraint.isNotNull((Object)resolver, (String)"RoleDescriptorResolver cannot be null");
    }

    public void setProfileRequestContextLookupStrategy(@Nullable Function<MessageContext, ProfileRequestContext> strategy) {
        this.checkSetterPreconditions();
        this.profileRequestContextLookupStrategy = strategy;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.metadataResolver == null) {
            throw new ComponentInitializationException("RoleDescriptorResolver cannot be null");
        }
    }

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        QName role;
        this.checkComponentActive();
        AbstractSAMLEntityContext entityCtx = (AbstractSAMLEntityContext)messageContext.getSubcontext(this.entityContextClass);
        String entityID = entityCtx != null ? entityCtx.getEntityId() : null;
        QName qName = role = entityCtx != null ? entityCtx.getRole() : null;
        if (entityCtx == null || entityID == null || role == null) {
            this.log.info("{} SAML entity context class '{}' missing or did not contain an entityID or role", (Object)this.getLogPrefix(), (Object)this.entityContextClass.getName());
            return;
        }
        SAMLMetadataContext existingMetadataCtx = this.resolveExisting(messageContext, entityID, role);
        if (existingMetadataCtx != null) {
            this.log.info("{} Resolved existing metadata context, re-using it", (Object)this.getLogPrefix());
            entityCtx.addSubcontext((BaseContext)existingMetadataCtx);
            return;
        }
        CriteriaSet criteria = this.buildLookupCriteria(messageContext, entityID, role);
        try {
            RoleDescriptor roleMetadata = (RoleDescriptor)this.metadataResolver.resolveSingle((Object)criteria);
            if (roleMetadata == null) {
                ProtocolCriterion protocolCriterion = (ProtocolCriterion)criteria.get(ProtocolCriterion.class);
                if (protocolCriterion != null) {
                    this.log.info("{} No metadata returned for {} in role {} with protocol {}", new Object[]{this.getLogPrefix(), entityCtx.getEntityId(), entityCtx.getRole(), protocolCriterion.getProtocol()});
                } else {
                    this.log.info("{} No metadata returned for {} in role {}", new Object[]{this.getLogPrefix(), entityCtx.getEntityId(), entityCtx.getRole()});
                }
                return;
            }
            SAMLMetadataContext metadataCtx = new SAMLMetadataContext();
            metadataCtx.setEntityDescriptor((EntityDescriptor)roleMetadata.getParent());
            metadataCtx.setRoleDescriptor(roleMetadata);
            entityCtx.addSubcontext((BaseContext)metadataCtx);
            this.log.debug("{} {} added to MessageContext as child of {}", new Object[]{this.getLogPrefix(), SAMLMetadataContext.class.getName(), this.entityContextClass.getName()});
        }
        catch (ResolverException e) {
            this.log.error("{} ResolverException thrown during metadata lookup", (Object)this.getLogPrefix(), (Object)e);
        }
    }

    @Nonnull
    protected CriteriaSet buildLookupCriteria(@Nonnull MessageContext messageContext, @Nonnull String entityID, @Nonnull QName role) {
        ProfileRequestContext prc;
        DetectDuplicateEntityIDs detect;
        String protocol;
        EntityIdCriterion entityIdCriterion = new EntityIdCriterion(entityID);
        EntityRoleCriterion roleCriterion = new EntityRoleCriterion(role);
        ProtocolCriterion protocolCriterion = null;
        SAMLProtocolContext protocolCtx = (SAMLProtocolContext)messageContext.getSubcontext(SAMLProtocolContext.class);
        if (protocolCtx != null && (protocol = protocolCtx.getProtocol()) != null) {
            protocolCriterion = new ProtocolCriterion(protocol);
        }
        SAMLMetadataLookupParametersContext lookupParamsContext = (SAMLMetadataLookupParametersContext)messageContext.getSubcontext(SAMLMetadataLookupParametersContext.class);
        DetectDuplicateEntityIDsCriterion detectDuplicatesCriterion = null;
        if (lookupParamsContext != null && (detect = lookupParamsContext.getDetectDuplicateEntityIDs()) != null) {
            detectDuplicatesCriterion = new DetectDuplicateEntityIDsCriterion(detect);
        }
        ProfileRequestContextCriterion prcCriterion = null;
        if (this.profileRequestContextLookupStrategy != null && (prc = this.profileRequestContextLookupStrategy.apply(messageContext)) != null) {
            prcCriterion = new ProfileRequestContextCriterion(prc);
        }
        CriteriaSet criteria = new CriteriaSet(new Criterion[]{entityIdCriterion, protocolCriterion, roleCriterion, detectDuplicatesCriterion, prcCriterion});
        return criteria;
    }

    @Nullable
    protected SAMLMetadataContext resolveExisting(@Nonnull MessageContext messageContext, @Nonnull String entityID, @Nonnull QName role) {
        if (this.copyContextStrategy == null) {
            return null;
        }
        assert (this.copyContextStrategy != null);
        SAMLMetadataContext existing = this.copyContextStrategy.apply(messageContext);
        if (existing != null) {
            EntityDescriptor existingEntity = existing.getEntityDescriptor();
            RoleDescriptor existingRole = existing.getRoleDescriptor();
            if (existingEntity != null && existingRole != null) {
                if (Objects.equals(existingEntity.getEntityID(), entityID) && (Objects.equals(existingRole.getElementQName(), role) || Objects.equals(existingRole.getSchemaType(), role))) {
                    this.log.debug("{} Found an existing and suitable SAMLMetadataContext from which to copy ", (Object)this.getLogPrefix());
                    SAMLMetadataContext copy = new SAMLMetadataContext();
                    copy.setEntityDescriptor(existing.getEntityDescriptor());
                    copy.setRoleDescriptor(existing.getRoleDescriptor());
                    return copy;
                }
                this.log.debug("{} Existing SAMLMetadataContext was resolved, but was either the entityID or role did not match the entity context data", (Object)this.getLogPrefix());
            }
            this.log.debug("{} Existing SAMLMetadataContext was resolved, but was missing EntityDescriptor or RoleDescriptor data", (Object)this.getLogPrefix());
        } else {
            this.log.debug("{} No existing SAMLMetadataContext was resolved", (Object)this.getLogPrefix());
        }
        return null;
    }
}

