/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.aaa;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.aaa.AAAContext;
import org.osgl.aaa.AAAPersistentService;
import org.osgl.aaa.Auditor;
import org.osgl.aaa.AuthorizationService;
import org.osgl.aaa.DynamicPermissionCheckHelper;
import org.osgl.aaa.NoAccessException;
import org.osgl.aaa.Permission;
import org.osgl.aaa.Principal;
import org.osgl.aaa.Privilege;
import org.osgl.aaa.Role;
import org.osgl.aaa.impl.SimplePrincipal;
import org.osgl.aaa.impl.SimplePrivilege;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;
import osgl.version.Version;

public enum AAA {

    public static final Version VERSION = Version.get();
    public static final Logger logger = LogManager.get(AAA.class);
    public static final String SYSTEM = "__sys";
    public static final int SUPER_USER = 9999;
    private static final Map<Lang.T2<Permission, Class>, DynamicPermissionCheckHelper> dynamicCheckers = C.newMap((Object[])new Object[0]);
    private static final ThreadLocal<AAAContext> context = new ThreadLocal();
    private static final Permission NULL_PERMISSION = null;
    private static AAAContext defaultContext;
    private static final DynamicPermissionCheckHelper NULL_DPCH;

    public static void setDefaultContext(AAAContext context) {
        defaultContext = (AAAContext)$.requireNotNull((Object)context);
    }

    public static void setContext(AAAContext context) {
        if (null == context) {
            AAA.clearContext();
        } else {
            AAA.context.set(context);
        }
    }

    public static void clearContext() {
        AAAContext ctx = context.get();
        if (null != ctx) {
            ctx.setCurrentPrincipal(null);
        }
        context.remove();
    }

    public static AAAContext context() {
        AAAContext current = context.get();
        return null != current ? current : defaultContext;
    }

    public static <T> void registerDynamicPermissionChecker(DynamicPermissionCheckHelper<T> checker, Class<T> clz) {
        List<Permission> l = checker.permissions();
        if (l.isEmpty()) {
            dynamicCheckers.put(AAA.dpchKey(NULL_PERMISSION, clz), checker);
        } else {
            for (Permission p : l) {
                dynamicCheckers.put(AAA.dpchKey(p, clz), checker);
            }
        }
    }

    public static boolean hasPermission(Permission permission) {
        return AAA.hasPermission(null, permission, true, null);
    }

    public static boolean hasPermission(String permissionName) {
        return AAA.hasPermission(null, permissionName, true, null);
    }

    public static boolean hasPermission(Enum<?> permissionEnum) {
        return AAA.hasPermission(null, permissionEnum.name(), true, null);
    }

    public static boolean hasPermission(Object guardedResource, Permission permission) {
        return AAA.hasPermission(guardedResource, permission, true, null);
    }

    public static boolean hasPermission(Object guardedResource, String permissionName) {
        return AAA.hasPermission(guardedResource, permissionName, true, null);
    }

    public static boolean hasPermission(Object guardedResource, Enum<?> permissionEnum) {
        return AAA.hasPermission(guardedResource, permissionEnum.name(), true, null);
    }

    public static boolean hasPermission(Object guardedResource, Principal principal, Permission permission) {
        return AAA.hasPermission(guardedResource, principal, permission, null);
    }

    public static boolean hasPermission(Object guardedResource, Principal principal, String permissionName) {
        return AAA.hasPermission(guardedResource, principal, permissionName, null);
    }

    public static boolean hasPermission(Object guardedResource, Principal principal, Enum<?> permissionEnum) {
        return AAA.hasPermission(guardedResource, principal, permissionEnum.name(), null);
    }

    public static boolean hasPermission(Object guardedResource, Permission permission, boolean allowSystem) {
        return AAA.hasPermission(guardedResource, permission, allowSystem, null);
    }

    public static boolean hasPermission(Object guardedResource, String permissionName, boolean allowSystem) {
        return AAA.hasPermission(guardedResource, permissionName, allowSystem, null);
    }

    public static boolean hasPermission(Object guardedResource, Enum<?> permissionEnum, boolean allowSystem) {
        return AAA.hasPermission(guardedResource, permissionEnum.name(), allowSystem, null);
    }

    public static boolean hasPermission(Object guardedResource, Permission permission, boolean allowSystem, AAAContext context) {
        context = AAA.ensureContext(context);
        Principal principal = context.getPrincipal(allowSystem);
        return AAA.hasPermission(guardedResource, principal, permission, context);
    }

    public static boolean hasPermission(Object guardedResource, String permissionName, boolean allowSystem, AAAContext context) {
        context = AAA.ensureContext(context);
        Principal principal = context.getPrincipal(allowSystem);
        return AAA.hasPermission(guardedResource, principal, permissionName, context);
    }

    public static boolean hasPermission(Object guardedResource, Enum<?> permissionEnum, boolean allowSystem, AAAContext context) {
        context = AAA.ensureContext(context);
        Principal principal = context.getPrincipal(allowSystem);
        return AAA.hasPermission(guardedResource, principal, permissionEnum.name(), context);
    }

    public static boolean hasPermission(Object guardedResource, Principal principal, Permission permission, AAAContext context) {
        if (AAA.checkSuperUser(principal = AAA.ensurePrincipal(principal, context = AAA.ensureContext(context)), context)) {
            return true;
        }
        guardedResource = AAA.tryGetGuardedResource(guardedResource, context);
        AuthorizationService auth = context.getAuthorizationService();
        Collection<Permission> allPermissions = auth.getAllPermissions(principal, context);
        boolean hasAccess = allPermissions.contains(permission);
        if (!hasAccess) {
            return false;
        }
        if (!permission.isDynamic() || AAA.isSystem(principal)) {
            return true;
        }
        E.illegalStateIf((null == guardedResource ? 1 : 0) != 0, (String)"Cannot determine guarded resource for dynamic permission");
        Class<?> resourceType = guardedResource.getClass();
        DynamicPermissionCheckHelper dpch = AAA.dynamicPermissionCheckHelper(permission, resourceType);
        return dpch.isAssociated(guardedResource, principal);
    }

    public static boolean hasPermission(Object guardedResource, Principal principal, String permissionName, AAAContext context) {
        AAAPersistentService db = (context = AAA.ensureContext(context)).getPersistentService();
        Permission perm = db.findByName(permissionName, Permission.class);
        return null != perm && AAA.hasPermission(guardedResource, principal, perm, context);
    }

    public static boolean hasPermission(Object guardedResource, Principal principal, Enum<?> permissionEnum, AAAContext context) {
        return AAA.hasPermission(guardedResource, principal, permissionEnum.name(), context);
    }

    public static void requirePermission(Permission permission) throws NoAccessException {
        AAA.requirePermission(null, permission, true, null);
    }

    public static void requirePermission(String permissionName) throws NoAccessException {
        AAA.requirePermission(null, permissionName, true, null);
    }

    public static void requirePermission(Enum<?> permissionEnum) throws NoAccessException {
        AAA.requirePermission(null, permissionEnum.name(), true, null);
    }

    public static void requirePermission(Permission permission, boolean allowSystem) throws NoAccessException {
        AAA.requirePermission(null, permission, allowSystem);
    }

    public static void requirePermission(String permissionName, boolean allowSystem) throws NoAccessException {
        AAA.requirePermission(null, permissionName, allowSystem);
    }

    public static void requirePermission(Enum<?> permissionEnum, boolean allowSystem) throws NoAccessException {
        AAA.requirePermission(null, permissionEnum.name(), allowSystem);
    }

    public static void requirePermission(Permission permission, AAAContext context) throws NoAccessException {
        AAA.requirePermission(null, permission, true, context);
    }

    public static void requirePermission(String permissionName, AAAContext context) throws NoAccessException {
        AAA.requirePermission(null, permissionName, true, context);
    }

    public static void requirePermission(Enum<?> permissionEnum, AAAContext context) throws NoAccessException {
        AAA.requirePermission(null, permissionEnum.name(), true, context);
    }

    public static void requirePermission(Permission permission, boolean allowSystem, AAAContext context) throws NoAccessException {
        AAA.requirePermission(null, permission, allowSystem, context);
    }

    public static void requirePermission(String permissionName, boolean allowSystem, AAAContext context) throws NoAccessException {
        AAA.requirePermission(null, permissionName, allowSystem, context);
    }

    public static void requirePermission(Enum<?> permissionEnum, boolean allowSystem, AAAContext context) throws NoAccessException {
        AAA.requirePermission(null, permissionEnum.name(), allowSystem, context);
    }

    public static void requirePermission(Object guardedResource, Permission permission) throws NoAccessException {
        AAA.requirePermission(guardedResource, permission, true, null);
    }

    public static void requirePermission(Object guardedResource, String permissionName) throws NoAccessException {
        AAA.requirePermission(guardedResource, permissionName, true, null);
    }

    public static void requirePermission(Object guardedResource, Enum<?> permissionEnum) throws NoAccessException {
        AAA.requirePermission(guardedResource, permissionEnum.name(), true, null);
    }

    public static void requirePermission(Object guardedResource, Permission permission, AAAContext context) throws NoAccessException {
        AAA.requirePermission(guardedResource, permission, true, context);
    }

    public static void requirePermission(Object guardedResource, String permissionName, AAAContext context) throws NoAccessException {
        AAA.requirePermission(guardedResource, permissionName, true, context);
    }

    public static void requirePermission(Object guardedResource, Enum<?> permissionEnum, AAAContext context) throws NoAccessException {
        AAA.requirePermission(guardedResource, permissionEnum.name(), true, context);
    }

    public static void requirePermission(Object guardedResource, Permission permission, boolean allowSystem) {
        AAA.requirePermission(guardedResource, permission, allowSystem, null);
    }

    public static void requirePermission(Object guardedResource, String permissionName, boolean allowSystem) {
        AAA.requirePermission(guardedResource, permissionName, allowSystem, null);
    }

    public static void requirePermission(Object guardedResource, Enum<?> permissionEnum, boolean allowSystem) {
        AAA.requirePermission(guardedResource, permissionEnum.name(), allowSystem, null);
    }

    public static void requirePermission(Object guardedResource, Permission permission, boolean allowSystem, AAAContext context) {
        context = AAA.ensureContext(context);
        Principal user = context.getPrincipal(allowSystem);
        AAA.requirePermission(guardedResource, user, permission, context);
    }

    public static void requirePermission(Object guardedResource, String permissionName, boolean allowSystem, AAAContext context) {
        context = AAA.ensureContext(context);
        Principal user = context.getPrincipal(allowSystem);
        AAA.requirePermission(guardedResource, user, permissionName, context);
    }

    public static void requirePermission(Object guardedResource, Enum<?> permissionEnum, boolean allowSystem, AAAContext context) {
        context = AAA.ensureContext(context);
        Principal user = context.getPrincipal(allowSystem);
        AAA.requirePermission(guardedResource, user, permissionEnum.name(), context);
    }

    public static void requirePermission(Object guardedResource, Principal principal, Permission permission, AAAContext context) {
        context = AAA.ensureContext(context);
        Auditor auditor = context.getAuditor();
        boolean hasPermission = AAA.hasPermission(guardedResource, principal, permission, context);
        auditor.audit(guardedResource, principal, permission.getName(), null, hasPermission, null);
        if (!hasPermission) {
            AAA.noAccess();
        }
    }

    public static void requirePermission(Object guardedResource, Principal principal, String permissionName, AAAContext context) {
        context = AAA.ensureContext(context);
        Permission permission = context.getPersistentService().findByName(permissionName, Permission.class);
        AAA.requirePermission(guardedResource, principal, permission, context);
    }

    public static void requirePermission(Object guardedResource, Principal principal, Enum<?> permissionEnum, AAAContext context) {
        context = AAA.ensureContext(context);
        Permission permission = context.getPersistentService().findByName(permissionEnum.name(), Permission.class);
        AAA.requirePermission(guardedResource, principal, permission, context);
    }

    public static boolean hasPrivilege(Privilege privilege) {
        return AAA.hasPrivilege(privilege, true, null);
    }

    public static boolean hasPrivilege(String privilegeName) {
        return AAA.hasPrivilege(privilegeName, true, null);
    }

    public static boolean hasPrivilege(Enum<?> privilegeEnum) {
        return AAA.hasPrivilege(privilegeEnum.name(), true, null);
    }

    public static boolean hasPrivilege(int privilegeLevel) {
        return AAA.hasPrivilege(privilegeLevel, true, null);
    }

    public static boolean hasPrivilege(Privilege privilege, boolean allowSystem) {
        return AAA.hasPrivilege(privilege, allowSystem, null);
    }

    public static boolean hasPrivilege(String privilegeName, boolean allowSystem) {
        return AAA.hasPrivilege(privilegeName, allowSystem, null);
    }

    public static boolean hasPrivilege(Enum<?> privilegeEnum, boolean allowSystem) {
        return AAA.hasPrivilege(privilegeEnum.name(), allowSystem, null);
    }

    public static boolean hasPrivilege(int privilegeLevel, boolean allowSystem) {
        return AAA.hasPrivilege(privilegeLevel, allowSystem, null);
    }

    public static boolean hasPrivilege(Privilege privilege, boolean allowSystem, AAAContext context) {
        Principal user = (context = AAA.ensureContext(context)).getPrincipal(allowSystem);
        return null != user && AAA.hasPrivilege(user, privilege, context);
    }

    public static boolean hasPrivilege(String privilegeName, boolean allowSystem, AAAContext context) {
        Principal user = (context = AAA.ensureContext(context)).getPrincipal(allowSystem);
        return null != user && AAA.hasPrivilege(user, privilegeName, context);
    }

    public static boolean hasPrivilege(Enum<?> privilegeEnum, boolean allowSystem, AAAContext context) {
        return AAA.hasPrivilege(privilegeEnum.name(), allowSystem, context);
    }

    public static boolean hasPrivilege(int privilegeLevel, boolean allowSystem, AAAContext context) {
        context = AAA.ensureContext(context);
        Principal user = context.getPrincipal(allowSystem);
        return AAA.hasPrivilege(user, privilegeLevel, context);
    }

    public static boolean hasPrivilege(Principal principal, Privilege privilege, AAAContext context) {
        return AAA.hasPrivilege(principal, privilege.getLevel(), context);
    }

    public static boolean hasPrivilege(Principal principal, String privilegeName, AAAContext context) {
        context = AAA.ensureContext(context);
        AAAPersistentService persistentService = context.getPersistentService();
        return AAA.hasPrivilege(principal, persistentService.findByName(privilegeName, Privilege.class), context);
    }

    public static boolean hasPrivilege(Principal principal, Enum<?> privilegeEnum, AAAContext context) {
        return AAA.hasPrivilege(principal, privilegeEnum.name(), context);
    }

    public static boolean hasPrivilege(Principal principal, int privilegeLevel, AAAContext context) {
        AuthorizationService auth = context.getAuthorizationService();
        Privilege userPrivilege = auth.getPrivilege(principal, context);
        return null != userPrivilege && userPrivilege.getLevel() >= privilegeLevel;
    }

    public static void requirePrivilege(Privilege privilege) {
        AAA.requirePrivilege(privilege, true, null);
    }

    public static void requirePrivilege(Enum<?> privilegeEnum) {
        AAA.requirePrivilege(privilegeEnum.name(), true, null);
    }

    public static void requirePrivilege(String privilegeName) {
        AAA.requirePrivilege(privilegeName, true, null);
    }

    public static void requirePrivilege(int privilegeLevel) {
        AAA.requirePrivilege(privilegeLevel, true);
    }

    public static void requirePrivilege(Privilege privilege, boolean allowSystem) {
        AAA.requirePrivilege(privilege, allowSystem, null);
    }

    public static void requirePrivilege(String privilegeName, boolean allowSystem) {
        AAA.requirePrivilege(privilegeName, allowSystem, null);
    }

    public static void requirePrivilege(Enum<?> privilegeEnum, boolean allowSystem) {
        AAA.requirePrivilege(privilegeEnum.name(), allowSystem, null);
    }

    public static void requirePrivilege(int privilegeLevel, boolean allowSystem) {
        AAA.requirePrivilege(privilegeLevel, allowSystem, null);
    }

    public static void requirePrivilege(Privilege privilege, AAAContext context) {
        AAA.requirePrivilege(privilege, true, context);
    }

    public static void requirePrivilege(String privilegeName, AAAContext context) {
        AAA.requirePrivilege(privilegeName, true, context);
    }

    public static void requirePrivilege(Enum<?> privilegeEnum, AAAContext context) {
        AAA.requirePrivilege(privilegeEnum.name(), true, context);
    }

    public static void requirePrivilege(int privilegeLevel, AAAContext context) {
        AAA.requirePrivilege(privilegeLevel, true, context);
    }

    public static void requirePrivilege(Privilege privilege, boolean allowSystem, AAAContext context) {
        context = AAA.ensureContext(context);
        Principal user = context.getPrincipal(allowSystem);
        AAA.requirePrivilege(user, privilege, context);
    }

    public static void requirePrivilege(String privilegeName, boolean allowSystem, AAAContext context) {
        context = AAA.ensureContext(context);
        Principal user = context.getPrincipal(allowSystem);
        AAA.requirePrivilege(user, privilegeName, context);
    }

    public static void requirePrivilege(Enum<?> privilegeEnum, boolean allowSystem, AAAContext context) {
        AAA.requirePrivilege(privilegeEnum.name(), allowSystem, context);
    }

    public static void requirePrivilege(int privilegeLevel, boolean allowSystem, AAAContext context) {
        context = AAA.ensureContext(context);
        Principal user = context.getPrincipal(allowSystem);
        AAA.requirePrivilege(user, privilegeLevel, context);
    }

    public static void requirePrivilege(Principal principal, Privilege privilege, AAAContext context) {
        AAA.requirePrivilege(principal, privilege.getLevel(), privilege.getName(), context);
    }

    public static void requirePrivilege(Principal principal, String privilegeName, AAAContext context) {
        context = AAA.ensureContext(context);
        AAAPersistentService persistentService = context.getPersistentService();
        Privilege privilege = persistentService.findByName(privilegeName, Privilege.class);
        AAA.requirePrivilege(principal, privilege.getLevel(), privilege.getName(), context);
    }

    public static void requirePrivilege(Principal principal, Enum<?> privilegeEnum, AAAContext context) {
        AAA.requirePermission(privilegeEnum, privilegeEnum.name(), context);
    }

    public static void requirePrivilege(Principal principal, int privilegeLevel, AAAContext context) {
        context = AAA.ensureContext(context);
        Privilege privilege = context.findPrivilege(privilegeLevel);
        AAA.requirePrivilege(principal, privilegeLevel, privilege.getName(), context);
    }

    private static void requirePrivilege(Principal principal, int privilegeLevel, String privilegeName, AAAContext context) {
        boolean authorized = AAA.hasPrivilege(principal, privilegeLevel, context);
        Auditor auditor = context.getAuditor();
        auditor.audit(null, principal, null, privilegeName, authorized, "");
        if (!authorized) {
            AAA.noAccess();
        }
    }

    public static boolean hasPermissionOrPrivilege(Permission permission, Privilege privilege) {
        return AAA.hasPrivilege(privilege) || AAA.hasPermission(permission);
    }

    public static boolean hasPermissionOrPrivilege(String permissionName, String privilegeName) {
        return AAA.hasPrivilege(privilegeName) || AAA.hasPermission(permissionName);
    }

    public static boolean hasPermissionOrPrivilege(String permissionName, int privilegeLevel) {
        return AAA.hasPrivilege(privilegeLevel) || AAA.hasPermission(permissionName);
    }

    public static boolean hasPermissionOrPrivilege(Enum<?> permissionEnum, Enum<?> privilegeEnum) {
        return AAA.hasPrivilege(privilegeEnum) || AAA.hasPermission(permissionEnum);
    }

    public static boolean hasPermissionOrPrivilege(Enum<?> permissionEnum, int privilegeLevel) {
        return AAA.hasPrivilege(privilegeLevel) || AAA.hasPermission(permissionEnum);
    }

    public static boolean hasPermissionOrPrivilege(Permission permission, Privilege privilege, AAAContext context) {
        return AAA.hasPermissionOrPrivilege(null, permission, privilege, true, context);
    }

    public static boolean hasPermissionOrPrivilege(String permissionName, String privilegeName, AAAContext context) {
        return AAA.hasPermissionOrPrivilege(null, permissionName, privilegeName, true, context);
    }

    public static boolean hasPermissionOrPrivilege(String permissionName, int privilegeLevel, AAAContext context) {
        return AAA.hasPermissionOrPrivilege(null, permissionName, privilegeLevel, true, context);
    }

    public static boolean hasPermissionOrPrivilege(Enum<?> permissionEnum, Enum<?> privilegeEnum, AAAContext context) {
        return AAA.hasPermissionOrPrivilege(null, permissionEnum, privilegeEnum, true, context);
    }

    public static boolean hasPermissionOrPrivilege(Enum<?> permissionEnum, int privilegeLevel, AAAContext context) {
        return AAA.hasPermissionOrPrivilege(null, permissionEnum, privilegeLevel, true, context);
    }

    public static boolean hasPermissionOrPrivilege(Permission permission, Privilege privilege, boolean allowSystem, AAAContext context) {
        return AAA.hasPrivilege(privilege, allowSystem, context) || AAA.hasPermission(null, permission, allowSystem, context);
    }

    public static boolean hasPermissionOrPrivilege(String permissionName, String privilegeName, boolean allowSystem, AAAContext context) {
        return AAA.hasPrivilege(privilegeName, allowSystem, context) || AAA.hasPermission(null, permissionName, allowSystem, context);
    }

    public static boolean hasPermissionOrPrivilege(String permissionName, int privilegeLevel, boolean allowSystem, AAAContext context) {
        return AAA.hasPrivilege(privilegeLevel, allowSystem, context) || AAA.hasPermission(null, permissionName, allowSystem, context);
    }

    public static boolean hasPermissionOrPrivilege(Enum<?> permissionEnum, Enum<?> privilegeEnum, boolean allowSystem, AAAContext context) {
        return AAA.hasPrivilege(privilegeEnum, allowSystem, context) || AAA.hasPermission(null, permissionEnum, allowSystem, context);
    }

    public static boolean hasPermissionOrPrivilege(Enum<?> permissionEnum, int privilegeLevel, boolean allowSystem, AAAContext context) {
        return AAA.hasPrivilege(privilegeLevel, allowSystem, context) || AAA.hasPermission(null, permissionEnum, allowSystem, context);
    }

    public static boolean hasPermissionOrPrivilege(Object guardedResource, Permission permission, Privilege privilege) {
        return AAA.hasPrivilege(privilege) || AAA.hasPermission(guardedResource, permission);
    }

    public static boolean hasPermissionOrPrivilege(Object guardedResource, String permissionName, String privilegeName) {
        return AAA.hasPrivilege(privilegeName) || AAA.hasPermission(guardedResource, permissionName);
    }

    public static boolean hasPermissionOrPrivilege(Object guardedResource, String permissionName, int privilegeLevel) {
        return AAA.hasPrivilege(privilegeLevel) || AAA.hasPermission(guardedResource, permissionName);
    }

    public static boolean hasPermissionOrPrivilege(Object guardedResource, Enum<?> permissionEnum, Enum<?> privilegeEnum) {
        return AAA.hasPrivilege(privilegeEnum) || AAA.hasPermission(guardedResource, permissionEnum);
    }

    public static boolean hasPermissionOrPrivilege(Object guardedResource, Enum<?> permissionEnum, int privilegeLevel) {
        return AAA.hasPrivilege(privilegeLevel) || AAA.hasPermission(guardedResource, permissionEnum);
    }

    public static boolean hasPermissionOrPrivilege(Object guardedResource, Permission permission, Privilege privilege, AAAContext context) {
        return AAA.hasPrivilege(privilege) || AAA.hasPermission(guardedResource, permission);
    }

    public static boolean hasPermissionOrPrivilege(Object guardedResource, String permissionName, String privilegeName, AAAContext context) {
        return AAA.hasPermissionOrPrivilege(guardedResource, permissionName, privilegeName, true, context);
    }

    public static boolean hasPermissionOrPrivilege(Object guardedResource, String permissionName, int privilegeLevel, AAAContext context) {
        return AAA.hasPermissionOrPrivilege(guardedResource, permissionName, privilegeLevel, true, context);
    }

    public static boolean hasPermissionOrPrivilege(Object guardedResource, Enum<?> permissionEnum, Enum<?> privilegeEnum, AAAContext context) {
        return AAA.hasPermissionOrPrivilege(guardedResource, permissionEnum, privilegeEnum, true, context);
    }

    public static boolean hasPermissionOrPrivilege(Object guardedResource, Enum<?> permissionEnum, int privilegeLevel, AAAContext context) {
        return AAA.hasPermissionOrPrivilege(guardedResource, permissionEnum, privilegeLevel, true, context);
    }

    public static boolean hasPermissionOrPrivilege(Object guardedResource, Permission permission, Privilege privilege, boolean allowSystem) {
        return AAA.hasPrivilege(privilege, allowSystem) || AAA.hasPermission(guardedResource, permission, allowSystem);
    }

    public static boolean hasPermissionOrPrivilege(Object guardedResource, String permissionName, String privilegeName, boolean allowSystem) {
        return AAA.hasPrivilege(privilegeName, allowSystem) || AAA.hasPermission(guardedResource, permissionName, allowSystem);
    }

    public static boolean hasPermissionOrPrivilege(Object guardedResource, String permissionName, int privilegeLevel, boolean allowSystem) {
        return AAA.hasPrivilege(privilegeLevel, allowSystem) || AAA.hasPermission(guardedResource, permissionName, allowSystem);
    }

    public static boolean hasPermissionOrPrivilege(Object guardedResource, Enum<?> permissionEnum, Enum<?> privilegeEnum, boolean allowSystem) {
        return AAA.hasPrivilege(privilegeEnum, allowSystem) || AAA.hasPermission(guardedResource, permissionEnum, allowSystem);
    }

    public static boolean hasPermissionOrPrivilege(Object guardedResource, Enum<?> permissionEnum, int privilegeLevel, boolean allowSystem) {
        return AAA.hasPrivilege(privilegeLevel, allowSystem) || AAA.hasPermission(guardedResource, permissionEnum, allowSystem);
    }

    public static boolean hasPermissionOrPrivilege(Object guardedResource, Permission permission, Privilege privilege, boolean allowSystem, AAAContext context) {
        return AAA.hasPrivilege(privilege, allowSystem, context) || AAA.hasPermission(guardedResource, permission, allowSystem, context);
    }

    public static boolean hasPermissionOrPrivilege(Object guardedResource, String permissionName, String privilegeName, boolean allowSystem, AAAContext context) {
        return AAA.hasPrivilege(privilegeName, allowSystem, context) || AAA.hasPermission(guardedResource, permissionName, allowSystem, context);
    }

    public static boolean hasPermissionOrPrivilege(Object guardedResource, String permissionName, int privilegeLevel, boolean allowSystem, AAAContext context) {
        return AAA.hasPrivilege(privilegeLevel, allowSystem, context) || AAA.hasPermission(guardedResource, permissionName, allowSystem, context);
    }

    public static boolean hasPermissionOrPrivilege(Object guardedResource, Enum<?> permissionEnum, Enum<?> privilegeEnum, boolean allowSystem, AAAContext context) {
        return AAA.hasPrivilege(privilegeEnum, allowSystem, context) || AAA.hasPermission(guardedResource, permissionEnum, allowSystem, context);
    }

    public static boolean hasPermissionOrPrivilege(Object guardedResource, Enum<?> permissionEnum, int privilegeLevel, boolean allowSystem, AAAContext context) {
        return AAA.hasPrivilege(privilegeLevel, allowSystem, context) || AAA.hasPermission(guardedResource, permissionEnum, allowSystem, context);
    }

    public static boolean hasPermissionOrPrivilege(Object guardedResource, Principal principal, Permission permission, Privilege privilege, AAAContext context) {
        return AAA.hasPrivilege(principal, privilege, context) || AAA.hasPermission(guardedResource, principal, permission, context);
    }

    public static boolean hasPermissionOrPrivilege(Object guardedResource, Principal principal, String permissionName, String privilegeName, AAAContext context) {
        return AAA.hasPrivilege(principal, privilegeName, context) || AAA.hasPermission(guardedResource, principal, permissionName, context);
    }

    public static boolean hasPermissionOrPrivilege(Object guardedResource, Principal principal, String permissionName, int privilegeLevel, AAAContext context) {
        return AAA.hasPrivilege(principal, privilegeLevel, context) || AAA.hasPermission(guardedResource, principal, permissionName, context);
    }

    public static boolean hasPermissionOrPrivilege(Object guardedResource, Principal principal, Enum<?> permissionEnum, Enum<?> privilegeEnum, AAAContext context) {
        return AAA.hasPrivilege(principal, privilegeEnum, context) || AAA.hasPermission(guardedResource, principal, permissionEnum, context);
    }

    public static boolean hasPermissionOrPrivilege(Object guardedResource, Principal principal, Enum<?> permissionEnum, int privilegeLevel, AAAContext context) {
        return AAA.hasPrivilege(principal, privilegeLevel, context) || AAA.hasPermission(guardedResource, principal, permissionEnum, context);
    }

    public static void requirePermissionOrPrivilege(Permission permission, Privilege privilege) {
        AAA.requirePermissionOrPrivilege(null, permission, privilege, true, null);
    }

    public static void requirePermissionOrPrivilege(String permissionName, String privilegeLevel) {
        AAA.requirePermissionOrPrivilege(null, permissionName, privilegeLevel, true, null);
    }

    public static void requirePermissionOrPrivilege(String permissionName, int privilegeLevel) {
        AAA.requirePermissionOrPrivilege(null, permissionName, privilegeLevel, true, null);
    }

    public static void requirePermissionOrPrivilege(Enum<?> permissionEnum, Enum<?> privilegeEnum) {
        AAA.requirePermissionOrPrivilege(null, permissionEnum.name(), privilegeEnum.name(), true, null);
    }

    public static void requirePermissionOrPrivilege(Enum<?> permissionEnum, int privilegeLevel) {
        AAA.requirePermissionOrPrivilege(null, permissionEnum.name(), privilegeLevel, true, null);
    }

    public static void requirePermissionOrPrivilege(Permission permission, Privilege privilege, AAAContext context) {
        AAA.requirePermissionOrPrivilege(null, permission, privilege, true, context);
    }

    public static void requirePermissionOrPrivilege(String permissionName, String privilegeLevel, AAAContext context) {
        AAA.requirePermissionOrPrivilege(null, permissionName, privilegeLevel, true, context);
    }

    public static void requirePermissionOrPrivilege(String permissionName, int privilegeLevel, AAAContext context) {
        AAA.requirePermissionOrPrivilege(null, permissionName, privilegeLevel, true, context);
    }

    public static void requirePermissionOrPrivilege(Enum<?> permissionEnum, Enum<?> privilegeEnum, AAAContext context) {
        AAA.requirePermissionOrPrivilege(null, permissionEnum.name(), privilegeEnum.name(), true, context);
    }

    public static void requirePermissionOrPrivilege(Enum<?> permissionEnum, int privilegeLevel, AAAContext context) {
        AAA.requirePermissionOrPrivilege(null, permissionEnum.name(), privilegeLevel, true, context);
    }

    public static void requirePermissionOrPrivilege(Permission permission, Privilege privilege, boolean allowSystem, AAAContext context) {
        AAA.requirePermissionOrPrivilege(null, permission, privilege, allowSystem, context);
    }

    public static void requirePermissionOrPrivilege(String permissionName, String privilegeLevel, boolean allowSystem, AAAContext context) {
        AAA.requirePermissionOrPrivilege(null, permissionName, privilegeLevel, allowSystem, context);
    }

    public static void requirePermissionOrPrivilege(String permissionName, int privilegeLevel, boolean allowSystem, AAAContext context) {
        AAA.requirePermissionOrPrivilege(null, permissionName, privilegeLevel, allowSystem, context);
    }

    public static void requirePermissionOrPrivilege(Enum<?> permissionEnum, Enum<?> privilegeEnum, boolean allowSystem, AAAContext context) {
        AAA.requirePermissionOrPrivilege(null, permissionEnum.name(), privilegeEnum.name(), allowSystem, context);
    }

    public static void requirePermissionOrPrivilege(Enum<?> permissionEnum, int privilegeLevel, boolean allowSystem, AAAContext context) {
        AAA.requirePermissionOrPrivilege(null, permissionEnum.name(), privilegeLevel, allowSystem, context);
    }

    public static void requirePermissionOrPrivilege(Object guardedResource, Permission permission, Privilege privilege) {
        AAA.requirePermissionOrPrivilege(guardedResource, permission, privilege, true, null);
    }

    public static void requirePermissionOrPrivilege(Object guardedResource, String permissionName, String privilegeLevel) {
        AAA.requirePermissionOrPrivilege(guardedResource, permissionName, privilegeLevel, true, null);
    }

    public static void requirePermissionOrPrivilege(Object guardedResource, String permissionName, int privilegeLevel) {
        AAA.requirePermissionOrPrivilege(guardedResource, permissionName, privilegeLevel, true, null);
    }

    public static void requirePermissionOrPrivilege(Object guardedResource, Enum<?> permissionEnum, Enum<?> privilegeEnum) {
        AAA.requirePermissionOrPrivilege(guardedResource, permissionEnum.name(), privilegeEnum.name(), true, null);
    }

    public static void requirePermissionOrPrivilege(Object guardedResource, Enum<?> permissionEnum, int privilegeLevel) {
        AAA.requirePermissionOrPrivilege(guardedResource, permissionEnum.name(), privilegeLevel, true, null);
    }

    public static void requirePermissionOrPrivilege(Object guardedResource, Permission permission, Privilege privilege, AAAContext context) {
        AAA.requirePermissionOrPrivilege(guardedResource, permission, privilege, true, context);
    }

    public static void requirePermissionOrPrivilege(Object guardedResource, String permissionName, String privilegeLevel, AAAContext context) {
        AAA.requirePermissionOrPrivilege(guardedResource, permissionName, privilegeLevel, true, context);
    }

    public static void requirePermissionOrPrivilege(Object guardedResource, String permissionName, int privilegeLevel, AAAContext context) {
        AAA.requirePermissionOrPrivilege(guardedResource, permissionName, privilegeLevel, true, context);
    }

    public static void requirePermissionOrPrivilege(Object guardedResource, Enum<?> permissionEnum, Enum<?> privilegeEnum, AAAContext context) {
        AAA.requirePermissionOrPrivilege(guardedResource, permissionEnum.name(), privilegeEnum.name(), true, context);
    }

    public static void requirePermissionOrPrivilege(Object guardedResource, Enum<?> permissionEnum, int privilegeLevel, AAAContext context) {
        AAA.requirePermissionOrPrivilege(guardedResource, permissionEnum.name(), privilegeLevel, true, context);
    }

    public static void requirePermissionOrPrivilege(Object guardedResource, Permission permission, Privilege privilege, boolean allowSystem) {
        AAA.requirePermissionOrPrivilege(guardedResource, permission, privilege, allowSystem, null);
    }

    public static void requirePermissionOrPrivilege(Object guardedResource, String permissionName, String privilegeLevel, boolean allowSystem) {
        AAA.requirePermissionOrPrivilege(guardedResource, permissionName, privilegeLevel, allowSystem, null);
    }

    public static void requirePermissionOrPrivilege(Object guardedResource, String permissionName, int privilegeLevel, boolean allowSystem) {
        AAA.requirePermissionOrPrivilege(guardedResource, permissionName, privilegeLevel, allowSystem, null);
    }

    public static void requirePermissionOrPrivilege(Object guardedResource, Enum<?> permissionEnum, Enum<?> privilegeEnum, boolean allowSystem) {
        AAA.requirePermissionOrPrivilege(guardedResource, permissionEnum.name(), privilegeEnum.name(), allowSystem, null);
    }

    public static void requirePermissionOrPrivilege(Object guardedResource, Enum<?> permissionEnum, int privilegeLevel, boolean allowSystem) {
        AAA.requirePermissionOrPrivilege(guardedResource, permissionEnum.name(), privilegeLevel, allowSystem, null);
    }

    public static void requirePermissionOrPrivilege(Object guardedResource, Permission permission, Privilege privilege, boolean allowSystem, AAAContext context) {
        AAA.requirePermissionOrPrivilege(guardedResource, AAA.ensureContext(context).getPrincipal(allowSystem), permission, privilege, context);
    }

    public static void requirePermissionOrPrivilege(Object guardedResource, String permissionName, String privilegeLevel, boolean allowSystem, AAAContext context) {
        AAA.requirePermissionOrPrivilege(guardedResource, AAA.ensureContext(context).getPrincipal(allowSystem), permissionName, privilegeLevel, context);
    }

    public static void requirePermissionOrPrivilege(Object guardedResource, String permissionName, int privilegeLevel, boolean allowSystem, AAAContext context) {
        AAA.requirePermissionOrPrivilege(guardedResource, AAA.ensureContext(AAA.context()).getPrincipal(allowSystem), permissionName, privilegeLevel, context);
    }

    public static void requirePermissionOrPrivilege(Object guardedResource, Enum<?> permissionEnum, Enum<?> privilegeEnum, boolean allowSystem, AAAContext context) {
        AAA.requirePermissionOrPrivilege(guardedResource, context.getPrincipal(allowSystem), permissionEnum.name(), privilegeEnum.name(), context);
    }

    public static void requirePermissionOrPrivilege(Object guardedResource, Enum<?> permissionEnum, int privilegeLevel, boolean allowSystem, AAAContext context) {
        context = AAA.ensureContext(context);
        AAA.requirePermissionOrPrivilege(guardedResource, context.getPrincipal(allowSystem), permissionEnum.name(), privilegeLevel, context);
    }

    public static void requirePermissionOrPrivilege(Object guardedResource, Principal user, Permission permission, Privilege privilege, AAAContext context) {
        context = AAA.ensureContext(context);
        boolean authorized = AAA.hasPermissionOrPrivilege(guardedResource, user, permission, privilege, context);
        Auditor auditor = context.getAuditor();
        auditor.audit(guardedResource, user, permission.getName(), privilege.getName(), authorized, "");
        if (!authorized) {
            AAA.noAccess();
        }
    }

    public static void requirePermissionOrPrivilege(Object guardedResource, Principal user, String permissionName, String privilegeLevel, AAAContext context) {
        context = AAA.ensureContext(context);
        boolean authorized = AAA.hasPermissionOrPrivilege(guardedResource, user, permissionName, privilegeLevel, context);
        Auditor auditor = context.getAuditor();
        auditor.audit(guardedResource, user, permissionName, privilegeLevel, authorized, "");
        if (!authorized) {
            AAA.noAccess();
        }
    }

    public static void requirePermissionOrPrivilege(Object guardedResource, Principal principal, String permissionName, int privilegeLevel, AAAContext context) {
        context = AAA.ensureContext(context);
        boolean authorized = AAA.hasPermissionOrPrivilege(guardedResource, principal, permissionName, privilegeLevel, context);
        Auditor auditor = context.getAuditor();
        auditor.audit(guardedResource, principal, permissionName, context.findPrivilege(privilegeLevel).getName(), authorized, "");
        if (!authorized) {
            AAA.noAccess();
        }
    }

    public static void requirePermissionOrPrivilege(Object guardedResource, Principal principal, Enum<?> permissionEnum, Enum<?> privilegeEnum, AAAContext context) {
        AAA.requirePermissionOrPrivilege(guardedResource, principal, permissionEnum.name(), privilegeEnum.name(), context);
    }

    public static void requirePermissionOrPrivilege(Object guardedResource, Principal principal, Enum<?> permissionEnum, int privilegeLevel, AAAContext context) {
        AAA.requirePermissionOrPrivilege(guardedResource, principal, permissionEnum.name(), privilegeLevel, context);
    }

    public static Principal createSuperUser() {
        return AAA.createSuperUser("su");
    }

    public static Principal createSuperUser(String userName) {
        return new SimplePrincipal.Builder(userName).grantPrivilege(new SimplePrivilege("root", 9999)).toPrincipal();
    }

    private static Lang.T2<Permission, Class> dpchKey(Permission p, Class c) {
        return $.T2((Object)p, (Object)c);
    }

    private static AAAContext ensureContext(AAAContext context) {
        context = null == context ? AAA.context() : context;
        E.illegalStateIf((null == context ? 1 : 0) != 0, (String)"cannot determine the AAA context");
        return context;
    }

    private static Principal ensurePrincipal(Principal principal, AAAContext context) {
        if (null == principal) {
            principal = context.getCurrentPrincipal();
            E.illegalArgumentIf((null == principal ? 1 : 0) != 0, (String)"principal cannot be null");
        }
        return principal;
    }

    private static Object tryGetGuardedResource(Object guardedResource, AAAContext context) {
        return null != guardedResource ? guardedResource : context.getGuardedTarget();
    }

    private static DynamicPermissionCheckHelper searchForDynamicPermissionCheckHelper(Permission p, Class<?> c) {
        while (c != Object.class && c != null) {
            DynamicPermissionCheckHelper dc = AAA.searchDpchFromInterfaces(p, c);
            if (null != dc) {
                return dc;
            }
            c = c.getSuperclass();
        }
        return null;
    }

    private static DynamicPermissionCheckHelper searchDpchFromInterfaces(Permission p, Class<?> c) {
        DynamicPermissionCheckHelper dc;
        Object[] intfs = c.getInterfaces();
        C.List cl = C.listOf((Object[])intfs).append(c);
        for (Class c0 : cl) {
            dc = dynamicCheckers.get(AAA.dpchKey(p, c0));
            if (null == dc) continue;
            return dc;
        }
        if (NULL_PERMISSION != p) {
            for (Class c0 : cl) {
                dc = dynamicCheckers.get(AAA.dpchKey(NULL_PERMISSION, c0));
                if (null == dc) continue;
                return dc;
            }
        }
        return null;
    }

    private static DynamicPermissionCheckHelper dynamicPermissionCheckHelper(Permission p, Class<?> c) {
        Lang.T2<Permission, Class> key = AAA.dpchKey(p, c);
        DynamicPermissionCheckHelper dc = dynamicCheckers.get(key);
        if (null == dc) {
            dc = AAA.searchForDynamicPermissionCheckHelper(p, c);
            if (null == dc) {
                dc = NULL_DPCH;
            }
            dynamicCheckers.put(key, dc);
        }
        return dc;
    }

    private static boolean checkSuperUser(Principal principal, AAAContext context) {
        return context.allowSuperUser() && context.isSuperUser(principal);
    }

    private static boolean isSystem(Principal principal) {
        return S.eq((String)SYSTEM, (String)principal.getName());
    }

    private static void noAccess() {
        throw new NoAccessException();
    }

    public static Privilege findPrivilege(int level) {
        return AAA.ensureContext(null).findPrivilege(level);
    }

    public static Iterable<Privilege> allPrivileges() {
        return AAA.ensureContext(null).allPrivileges();
    }

    public static Iterable<Permission> allPermissions() {
        return AAA.ensureContext(null).allPermissions();
    }

    public static Iterable<Role> allRoles() {
        return AAA.ensureContext(null).allRoles();
    }

    public static Iterable<String> allPrivilegeNames() {
        return AAA.ensureContext(null).allPrivilegeNames();
    }

    public static Iterable<String> allPermissionNames() {
        return AAA.ensureContext(null).allPermissionNames();
    }

    public static Iterable<String> allRoleNames() {
        return AAA.ensureContext(null).allRoleNames();
    }

    static {
        NULL_DPCH = new DynamicPermissionCheckHelper(){

            public List<Permission> permissions() {
                return C.list();
            }

            public boolean isAssociated(Object guardedResource, Principal principal) {
                return false;
            }
        };
    }
}

