/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.aaa.impl;

import java.util.Collection;
import java.util.Set;
import org.osgl.aaa.AAAObject;
import org.osgl.aaa.Permission;
import org.osgl.aaa.impl.AAAObjectBase;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;

public class SimplePermission
extends AAAObjectBase
implements Permission {
    private boolean dynamic;
    private Set<Permission> implied = C.newSet();

    public SimplePermission() {
    }

    public SimplePermission(String name, boolean isDynamic) {
        this(name, null, isDynamic);
    }

    public SimplePermission(String name, Collection<? extends Permission> implied) {
        this(name, implied, false);
    }

    public SimplePermission(String name, Collection<? extends Permission> implied, boolean dynamic) {
        super(name);
        this.dynamic = dynamic;
        if (null != implied && !implied.isEmpty()) {
            this.implied.addAll(implied);
        }
    }

    @Override
    public boolean isDynamic() {
        return this.dynamic;
    }

    @Override
    public Set<Permission> implied() {
        if (null == this.implied) {
            return C.Set();
        }
        C.Set set = C.newSet();
        set.addAll(this.implied);
        set.add(this);
        return set;
    }

    public Set<Permission> getImplied() {
        return this.implied;
    }

    public static class Builder {
        protected String name;
        protected boolean dynamic;
        protected C.List<Permission> implied = C.newList();

        public Builder(String name) {
            E.illegalArgumentIf((boolean)S.blank((String)name));
            this.name = name;
        }

        public Builder dynamic(boolean dynamic) {
            this.dynamic = dynamic;
            return this;
        }

        public Builder addImplied(Permission perm) {
            E.NPE((Object)perm);
            if (!this.implied.contains((Object)perm)) {
                this.implied.add((Object)perm);
            }
            return this;
        }

        public Builder removeImplied(String permName) {
            E.NPE((Object)permName);
            this.implied = this.implied.remove(AAAObject.F.nameMatcher(permName));
            return this;
        }

        public Builder removeAllImplied() {
            this.implied.clear();
            return this;
        }

        public Permission toPermission() {
            return new SimplePermission(this.name, (Collection<? extends Permission>)this.implied, this.dynamic);
        }
    }
}

