/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.cache.CacheService;
import org.osgl.exception.NotAppliedException;
import org.osgl.exception.UnexpectedIOException;
import org.osgl.http.Current;
import org.osgl.http.Http;
import org.osgl.http.HttpConfig;
import org.osgl.http.util.Path;
import org.osgl.logging.L;
import org.osgl.logging.Logger;
import org.osgl.storage.ISObject;
import org.osgl.util.C;
import org.osgl.util.Charsets;
import org.osgl.util.Codec;
import org.osgl.util.Crypto;
import org.osgl.util.E;
import org.osgl.util.FastStr;
import org.osgl.util.IO;
import org.osgl.util.ListBuilder;
import org.osgl.util.S;
import org.osgl.web.util.UserAgent;

public class H {
    protected static final Logger logger = L.get(Http.class);

    public static Status status(int n) {
        return Status.valueOf(n);
    }

    public static Format format(String name) {
        return Format.valueOf(name);
    }

    public static Format format(String name, String contentType) {
        return Format.valueOf(name, contentType);
    }

    H() {
    }

    public static void cleanUp() {
        Current.clear();
    }

    public static abstract class Response<T extends Response> {
        private State state = State.NONE;
        protected volatile OutputStream outputStream;
        protected volatile Writer writer;
        private Object context;
        private String contentType;

        public T context(Object context) {
            this.context = $.notNull((Object)context);
            return this.me();
        }

        public <CONTEXT> CONTEXT context() {
            return (CONTEXT)this.context;
        }

        protected abstract Class<T> _impl();

        public boolean writerCreated() {
            return this.state == State.WRITER;
        }

        protected abstract OutputStream createOutputStream();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createWriter() {
            if (null != this.writer) {
                return;
            }
            Response response = this;
            synchronized (response) {
                if (null != this.writer) {
                    return;
                }
                this.outputStream = this.createOutputStream();
                String charset = this.characterEncoding();
                Charset cs = null == charset ? Charsets.UTF_8 : Charset.forName(charset);
                this.writer = new OutputStreamWriter(this.outputStream, cs);
            }
        }

        public OutputStream outputStream() throws IllegalStateException, UnexpectedIOException {
            return this.state.outputStream(this);
        }

        public Writer writer() throws IllegalStateException, UnexpectedIOException {
            return this.state.writer(this);
        }

        public PrintWriter printWriter() {
            Writer w = this.writer();
            if (w instanceof PrintWriter) {
                return (PrintWriter)w;
            }
            return new PrintWriter(w);
        }

        public abstract String characterEncoding();

        public abstract T characterEncoding(String var1);

        public abstract T contentLength(long var1);

        protected abstract void _setContentType(String var1);

        public T contentType(String type) {
            this._setContentType(type);
            this.contentType = type;
            return this.me();
        }

        public T initContentType(String type) {
            return (T)(null == this.contentType ? this.contentType(type) : this);
        }

        public T contentDisposition(String filename, boolean inline) {
            String type;
            String string = type = inline ? "inline" : "attachment";
            if (S.blank((String)filename)) {
                this.header("Content-Disposition", type);
            } else if (Response.canAsciiEncode(filename)) {
                String contentDisposition = "%s; filename=\"%s\"";
                this.header("Content-Disposition", S.fmt((String)contentDisposition, (Object[])new Object[]{type, filename}));
            } else {
                String encoding = this.characterEncoding();
                String contentDisposition = "%1$s; filename*=" + encoding + "''%2$s; filename=\"%2$s\"";
                try {
                    this.header("Content-Disposition", S.fmt((String)contentDisposition, (Object[])new Object[]{type, URLEncoder.encode(filename, encoding)}));
                }
                catch (UnsupportedEncodingException e) {
                    throw E.encodingException((UnsupportedEncodingException)e);
                }
            }
            return this.me();
        }

        public T prepareDownload(String filename) {
            return this.contentDisposition(filename, false);
        }

        public T etag(String etag) {
            this.header("Etag", etag);
            return this.me();
        }

        protected abstract void _setLocale(Locale var1);

        public T locale(Locale locale) {
            this._setLocale(locale);
            return this.me();
        }

        public abstract Locale locale();

        public abstract void addCookie(Cookie var1);

        public abstract boolean containsHeader(String var1);

        public abstract T sendError(int var1, String var2);

        public T sendError(int sc, String msg, Object ... args) {
            return this.sendError(sc, S.fmt((String)msg, (Object[])args));
        }

        public abstract T sendError(int var1);

        public abstract T sendRedirect(String var1);

        public abstract T header(String var1, String var2);

        public abstract T status(int var1);

        public T status(Status s) {
            this.status(s.code());
            return this.me();
        }

        public abstract T addHeader(String var1, String var2);

        public T addHeaderIfNotAdded(String name, String value) {
            if (!this.containsHeader(name)) {
                this.addHeader(name, value);
            }
            return this.me();
        }

        public T writeBinary(ISObject binary) {
            IO.copy((InputStream)binary.asInputStream(), (OutputStream)this.outputStream(), (boolean)false);
            return this.me();
        }

        public T writeContent(String s) {
            try {
                IO.write((byte[])s.getBytes(this.characterEncoding()), (OutputStream)this.outputStream());
            }
            catch (UnsupportedEncodingException e) {
                throw E.encodingException((UnsupportedEncodingException)e);
            }
            return this.me();
        }

        public abstract T writeContent(ByteBuffer var1);

        public T writeText(String content) {
            this._setContentType(Format.TXT.contentType());
            return this.writeContent(content);
        }

        public T writeHtml(String content) {
            this._setContentType(Format.HTML.contentType());
            return this.writeContent(content);
        }

        public T writeJSON(String content) {
            this._setContentType(Format.JSON.contentType());
            return this.writeContent(content);
        }

        public abstract void commit();

        public static <T extends Response> T current() {
            return (T)Current.response();
        }

        public static <T extends Response> void current(T response) {
            Current.response(response);
        }

        protected T me() {
            return (T)this;
        }

        private static boolean canAsciiEncode(String string) {
            CharsetEncoder asciiEncoder = Charset.forName("US-ASCII").newEncoder();
            return asciiEncoder.canEncode(string);
        }

        private static enum State {
            NONE,
            STREAM{

                @Override
                Writer writer(Response resp) {
                    throw new IllegalStateException("writer() already called");
                }
            }
            ,
            WRITER{

                @Override
                OutputStream outputStream(Response resp) {
                    throw new IllegalStateException("outputStream() already called");
                }
            };


            OutputStream outputStream(Response resp) {
                resp.outputStream = resp.createOutputStream();
                resp.state = State.STREAM;
                return resp.outputStream;
            }

            Writer writer(Response resp) {
                resp.createWriter();
                resp.state = State.WRITER;
                return resp.writer;
            }
        }
    }

    public static abstract class Request<T extends Request> {
        private static SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
        private Format accept;
        private Format contentType;
        private String ip;
        private int port = -1;
        private State state = State.NONE;
        private Object context;
        private String etag;
        private String referer;
        protected volatile InputStream inputStream;
        protected volatile Reader reader;
        private Map<String, Cookie> cookies = C.newMap((Object[])new Object[0]);
        private String domain;
        private String encoding;
        private C.List<Locale> locales;
        private long len = -2L;
        private String user;
        private String password;

        protected abstract Class<T> _impl();

        public T context(Object context) {
            this.context = $.notNull((Object)context);
            return this.me();
        }

        public <CONTEXT> CONTEXT context() {
            return (CONTEXT)this.context;
        }

        public abstract Method method();

        public abstract T method(Method var1);

        public abstract String header(String var1);

        public abstract Iterable<String> headers(String var1);

        public Format accept() {
            if (null == this.accept) {
                this.resolveAcceptFormat();
            }
            return this.accept;
        }

        public T accept(Format fmt) {
            this.accept = (Format)$.notNull((Object)fmt);
            return this.me();
        }

        public T accept(MediaType mediaType) {
            this.accept = mediaType.format();
            return this.me();
        }

        public String referrer() {
            if (null == this.referer) {
                this.referer = this.header("Referer");
                if (null == this.referer) {
                    this.referer = "";
                }
            }
            return this.referer;
        }

        public String referer() {
            return this.referrer();
        }

        public String etag() {
            if (null == this.etag) {
                this.etag = this.method().safe() ? this.header("If-None-Match") : this.header("If-Match");
            }
            return this.etag;
        }

        public boolean etagMatches(String etag) {
            String etag0 = this.etag();
            return null != etag0 && S.eq((String)etag0, (String)etag);
        }

        public boolean isAjax() {
            return S.eq((String)this.header("X-Requested-With"), (String)"XMLHttpRequest");
        }

        public abstract String path();

        public abstract String contextPath();

        public String fullPath() {
            return Path.url(this.path(), this);
        }

        public String url() {
            return this.fullPath();
        }

        public String fullUrl() {
            return Path.fullUrl(this.path(), this);
        }

        public abstract String query();

        public abstract boolean secure();

        public String scheme() {
            return this.secure() ? "https" : "http";
        }

        protected void _setCookie(String name, Cookie cookie) {
            this.cookies.put(name, cookie);
        }

        public String domain() {
            if (null == this.domain) {
                this.resolveHostPort();
            }
            return this.domain;
        }

        public int port() {
            if (-1 == this.port) {
                this.resolveHostPort();
            }
            return this.port;
        }

        protected abstract String _ip();

        private static boolean ipOk(String s) {
            return S.notEmpty((String)s) && S.neq((String)"unknown", (String)s);
        }

        private void resolveIp() {
            int pos;
            String rmt = this._ip();
            if (!HttpConfig.isXForwardedAllowed(rmt)) {
                this.ip = rmt;
                return;
            }
            String s = this.header("X-Forwarded-For");
            if (!Request.ipOk(s)) {
                if (HttpConfig.allowExtensiveRemoteAddrResolving()) {
                    s = this.header("Proxy-Client-ip");
                    if (!(Request.ipOk(s) || Request.ipOk(s = this.header("Wl-Proxy-Client-Ip")) || Request.ipOk(s = this.header("HTTP_CLIENT_IP")) || Request.ipOk(s = this.header("HTTP_X_FORWARDED_FOR")))) {
                        this.ip = rmt;
                        return;
                    }
                } else {
                    this.ip = rmt;
                    return;
                }
            }
            if (s.length() > 15 && (pos = s.indexOf(",")) > 0) {
                s = s.substring(0, pos);
            }
            this.ip = s;
        }

        private void resolveHostPort() {
            String host = this.header("X-Forwarded-Host");
            if (S.empty((String)host)) {
                host = this.header("Host");
            }
            if (null != host) {
                FastStr fs = FastStr.unsafeOf((String)host);
                if (fs.contains(':')) {
                    this.domain = fs.beforeFirst(':').toString();
                    try {
                        this.port = Integer.parseInt(fs.afterFirst(':').toString());
                    }
                    catch (NumberFormatException e) {
                        this.port = this.defPort();
                    }
                } else {
                    this.domain = host;
                    this.port = this.defPort();
                }
            } else {
                this.domain = "";
                this.port = this.defPort();
            }
        }

        private int defPort() {
            return this.secure() ? 443 : 80;
        }

        public String ip() {
            if (null == this.ip) {
                this.resolveIp();
            }
            return this.ip;
        }

        public String userAgentStr() {
            return this.header("User-Agent");
        }

        public UserAgent userAgent() {
            return UserAgent.parse((String)this.userAgentStr());
        }

        protected abstract void _initCookieMap();

        public Cookie cookie(String name) {
            if (this.cookies.isEmpty()) {
                this._initCookieMap();
            }
            return this.cookies.get(name);
        }

        public List<Cookie> cookies() {
            if (this.cookies.isEmpty()) {
                this._initCookieMap();
            }
            return C.list(this.cookies.values());
        }

        private T resolveAcceptFormat() {
            String accept = this.header("Accept");
            this.accept = Format.resolve(accept);
            return (T)this;
        }

        public boolean isModified(String etag, long since) {
            String browserEtag = this.header("If-None-Match");
            if (null == browserEtag) {
                return true;
            }
            if (!S.eq((String)browserEtag, (String)etag)) {
                return true;
            }
            String s = this.header("If-Modified-Since");
            if (null == s) {
                return true;
            }
            try {
                Date browserDate = dateFormat.parse(s);
                if (browserDate.getTime() >= since) {
                    return false;
                }
            }
            catch (ParseException ex) {
                logger.error((Throwable)ex, "Can't parse date: %s", new Object[]{s});
            }
            return true;
        }

        private void parseContentTypeAndEncoding() {
            String type = this.header("Content-Type");
            if (null == type) {
                this.contentType = Format.HTML;
                this.encoding = "utf-8";
            } else {
                String[] encodingInfoParts;
                String[] contentTypeParts = type.split(";");
                String _contentType = contentTypeParts[0].trim().toLowerCase();
                String _encoding = "utf-8";
                if (contentTypeParts.length >= 2 && (encodingInfoParts = contentTypeParts[1].split("=")).length == 2 && encodingInfoParts[0].trim().equalsIgnoreCase("charset") && S.notBlank((String)(_encoding = encodingInfoParts[1].trim())) && (_encoding.startsWith("\"") && _encoding.endsWith("\"") || _encoding.startsWith("'") && _encoding.endsWith("'"))) {
                    _encoding = _encoding.substring(1, _encoding.length() - 1).trim();
                }
                this.contentType = Format.resolve(_contentType);
                this.encoding = _encoding;
            }
        }

        public Format contentType() {
            if (null == this.contentType) {
                this.parseContentTypeAndEncoding();
            }
            return this.contentType;
        }

        public String characterEncoding() {
            if (null == this.encoding) {
                this.parseContentTypeAndEncoding();
            }
            return this.encoding;
        }

        private void parseLocales() {
            String[] sa;
            String s = this.header("Accept-Language");
            if (S.blank((String)s)) {
                this.locales = C.list((Object)HttpConfig.defaultLocale());
                return;
            }
            s = S.str((Object)s).remove((Osgl.Function)new Osgl.F1<Character, Boolean>(){

                public Boolean apply(Character character) {
                    char c = character.charValue();
                    return c == ' ' || c == '\t';
                }
            }).toString();
            ListBuilder lb = ListBuilder.create();
            for (String s0 : sa = s.split(",")) {
                Locale locale;
                String[] arr = s0.trim().split(";");
                String[] l = arr[0].split("-");
                switch (l.length) {
                    case 2: {
                        locale = new Locale(l[0], l[1]);
                        break;
                    }
                    case 3: {
                        locale = new Locale(l[0], l[1], l[2]);
                        break;
                    }
                    default: {
                        locale = new Locale(l[0]);
                    }
                }
                lb.add((Object)locale);
            }
            if (lb.isEmpty()) {
                lb.add((Object)HttpConfig.defaultLocale());
            }
            this.locales = lb.toList();
        }

        public Locale locale() {
            if (null == this.locales) {
                this.parseLocales();
            }
            return (Locale)this.locales.get(0);
        }

        public C.List<Locale> locales() {
            if (null == this.locales) {
                this.parseLocales();
            }
            return this.locales;
        }

        public long contentLength() {
            if (this.len > -2L) {
                return this.len;
            }
            String s = this.header("Content-Length");
            if (S.blank((String)s)) {
                this.len = -1L;
            } else {
                try {
                    this.len = Long.parseLong(s);
                }
                catch (NumberFormatException e) {
                    this.len = -1L;
                    logger.error("Error parsing content-length: %s", new Object[]{s});
                }
            }
            return this.len;
        }

        public boolean readerCreated() {
            return this.state == State.READER;
        }

        protected abstract InputStream createInputStream();

        public InputStream inputStream() throws IllegalStateException {
            return this.state.inputStream(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createReader() {
            if (null != this.reader) {
                return;
            }
            Request request = this;
            synchronized (request) {
                if (null != this.reader) {
                    return;
                }
                this.createInputStream();
                String charset = this.characterEncoding();
                Charset cs = null == charset ? Charsets.UTF_8 : Charset.forName(charset);
                this.reader = new InputStreamReader(this.inputStream(), cs);
            }
        }

        public Reader reader() throws IllegalStateException {
            return this.state.reader(this);
        }

        public abstract String paramVal(String var1);

        public abstract String[] paramVals(String var1);

        public abstract Iterable<String> paramNames();

        private void parseAuthorization() {
            if (null != this.user) {
                return;
            }
            this.user = "";
            this.password = "";
            String s = this.header("Authorization");
            if (null != s && s.startsWith("Basic")) {
                String data = s.substring(6);
                String[] decodedData = new String(Codec.decodeBASE64((String)data)).split(":");
                this.user = decodedData.length > 0 ? decodedData[0] : null;
                this.password = decodedData.length > 1 ? decodedData[1] : null;
            }
        }

        public String user() {
            if (null == this.user) {
                this.parseAuthorization();
            }
            return this.user;
        }

        public String password() {
            if (null == this.password) {
                this.parseAuthorization();
            }
            return this.password;
        }

        protected final T me() {
            return (T)this;
        }

        public static <T extends Request> T current() {
            return (T)Current.request();
        }

        public static <T extends Request> void current(T request) {
            Current.request(request);
        }

        static {
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        }

        private static enum State {
            NONE,
            STREAM{

                @Override
                Reader reader(Request req) {
                    throw new IllegalStateException("reader() already called");
                }
            }
            ,
            READER{

                @Override
                InputStream inputStream(Request req) {
                    throw new IllegalStateException("inputStream() already called");
                }
            };


            InputStream inputStream(Request req) {
                req.inputStream = req.createInputStream();
                req.state = State.STREAM;
                return req.inputStream;
            }

            Reader reader(Request req) {
                req.createReader();
                req.state = State.READER;
                return req.reader;
            }
        }
    }

    public static final class Flash
    extends KV<Flash> {
        private static final Pattern _PARSER = Session.access$300();
        private static final long serialVersionUID = 5609789840171619780L;
        private Map<String, String> out = C.newMap((Object[])new Object[0]);

        @Override
        public Flash put(String key, String value) {
            this.out.put(key, value);
            return (Flash)super.put(key, value);
        }

        @Override
        public Flash put(String key, Object value) {
            return this.put(key, null == value ? null : value.toString());
        }

        public Flash now(String key, String value) {
            return (Flash)super.put(key, value);
        }

        public Flash error(String message) {
            return this.put("error", message);
        }

        public Flash error(String message, Object ... args) {
            return this.put("error", S.fmt((String)message, (Object[])args));
        }

        public String error() {
            return this.get("error");
        }

        public Flash success(String message) {
            return this.put("success", message);
        }

        public Flash success(String message, Object ... args) {
            return this.put("success", S.fmt((String)message, (Object[])args));
        }

        public String success() {
            return this.get("success");
        }

        public Flash discard(String key) {
            this.out.remove(key);
            return this;
        }

        public Flash discard() {
            this.out.clear();
            return this;
        }

        public Flash keep(String key) {
            if (super.containsKey(key)) {
                this.out.put(key, this.get(key));
            }
            return this;
        }

        public Flash keep() {
            this.out.putAll(this.data);
            return this;
        }

        public KV out() {
            return new KV(this.out);
        }

        public static Flash current() {
            return Current.flash();
        }

        public static void current(Flash flash) {
            Current.flash(flash);
        }

        public static Flash resolve(Cookie flashCookie) {
            String value;
            Flash flash = new Flash();
            if (null != flashCookie && S.notBlank((String)(value = flashCookie.value()))) {
                String s = Codec.decodeUrl((String)value, (Charset)Charsets.UTF_8);
                Matcher m = _PARSER.matcher(s);
                while (m.find()) {
                    flash.data.put(m.group(1), m.group(2));
                }
            }
            return flash;
        }

        public Cookie serialize(String flashKey) {
            if (this.out.isEmpty()) {
                return new Cookie(flashKey).maxAge(0);
            }
            StringBuilder sb = S.builder();
            for (String key : this.out.keySet()) {
                sb.append("\u0000");
                sb.append(key);
                sb.append(":");
                sb.append(this.out.get(key));
                sb.append("\u0000");
            }
            String value = Codec.encodeUrl((String)sb.toString(), (Charset)Charsets.UTF_8);
            return new Cookie(flashKey).value(value);
        }
    }

    public static final class Session
    extends KV<Session> {
        public static final String KEY_ID = "___ID";
        public static final String KEY_EXPIRATION = "___TS";
        public static final String KEY_AUTHENTICITY_TOKEN = "___AT";
        public static final String KEY_EXPIRE_INDICATOR = "___expired";
        public static final String KEY_FINGER_PRINT = "__FP";
        private static final long serialVersionUID = -423716328552054481L;
        private String id;
        private static volatile CacheService cs;
        private static final Pattern _PARSER;

        public String id() {
            if (null == this.id) {
                this.id = (String)this.data.get(KEY_ID);
                if (null == this.id) {
                    this.id = UUID.randomUUID().toString();
                    this.put(KEY_ID, this.id());
                }
            }
            return this.id;
        }

        @Override
        public boolean empty() {
            return super.empty() || this.containsKey(KEY_EXPIRATION) && this.size() == 1;
        }

        @Override
        public boolean isEmpty() {
            return super.empty() || this.containsKey(KEY_EXPIRATION) && this.size() == 1;
        }

        public boolean expired() {
            long expiry = this.expiry();
            if (expiry < 0L) {
                return false;
            }
            return expiry < System.currentTimeMillis();
        }

        public long expiry() {
            String s = this.get(KEY_EXPIRATION);
            if (S.blank((String)s)) {
                return -1L;
            }
            return Long.parseLong(s);
        }

        public Session expireOn(long expiry) {
            this.put(KEY_EXPIRATION, S.string((Object)expiry));
            return this;
        }

        private String k(String key) {
            return S.builder((String)this.id()).append(key).toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static CacheService cs() {
            if (null != cs) {
                return cs;
            }
            Class<H> clazz = H.class;
            synchronized (H.class) {
                if (null == cs) {
                    cs = HttpConfig.sessionCache();
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return cs;
            }
        }

        public Session cache(String key, Object obj) {
            Session.cs().put(this.k(key), obj);
            return this;
        }

        public Session cache(String key, Object obj, int expiration) {
            Session.cs().put(this.k(key), obj, expiration);
            return this;
        }

        public Session cacheFor1Hr(String key, Object obj) {
            return this.cache(key, obj, 3600);
        }

        public Session cacheFor30Min(String key, Object obj) {
            return this.cache(key, obj, 1800);
        }

        public Session cacheFor10Min(String key, Object obj) {
            return this.cache(key, obj, 600);
        }

        public Session cacheFor1Min(String key, Object obj) {
            return this.cache(key, obj, 60);
        }

        public Session evict(String key) {
            Session.cs().evict(this.k(key));
            return this;
        }

        public <T> T cached(String key) {
            return (T)Session.cs().get(this.k(key));
        }

        public <T> T cached(String key, Class<T> clz) {
            return (T)Session.cs().get(this.k(key));
        }

        public static Session current() {
            return Current.session();
        }

        public static void current(Session session) {
            Current.session(session);
        }

        public static Session resolve(Cookie sessionCookie, int ttl) {
            String value;
            Session session = new Session();
            long expiration = System.currentTimeMillis() + (long)(ttl * 1000);
            boolean hasTtl = ttl > -1;
            String string = value = null == sessionCookie ? null : sessionCookie.value();
            if (S.blank((String)value)) {
                if (hasTtl) {
                    session.expireOn(expiration);
                }
            } else {
                String data;
                String signature;
                int firstDashIndex = value.indexOf("-");
                if (firstDashIndex > -1 && S.eq((String)(signature = value.substring(0, firstDashIndex)), (String)Session.sign(data = value.substring(firstDashIndex + 1)))) {
                    String sessionData = Codec.decodeUrl((String)data, (Charset)Charsets.UTF_8);
                    Matcher matcher = _PARSER.matcher(sessionData);
                    while (matcher.find()) {
                        session.put(matcher.group(1), matcher.group(2));
                    }
                }
                if (hasTtl && session.expired()) {
                    session = new Session().expireOn(expiration);
                }
            }
            return session;
        }

        public Cookie serialize(String sessionKey) {
            boolean expired;
            long expiry = this.expiry();
            boolean hasTtl = expiry > -1L;
            boolean bl = expired = !hasTtl && expiry < System.currentTimeMillis();
            if (!this.changed() && !hasTtl) {
                return null;
            }
            if (this.empty() || expired) {
                return new Cookie(sessionKey).maxAge(0);
            }
            StringBuilder sb = S.builder();
            for (String k : this.keySet()) {
                sb.append("\u0000");
                sb.append(k);
                sb.append(":");
                sb.append(this.get(k));
                sb.append("\u0000");
            }
            String data = Codec.encodeUrl((String)sb.toString(), (Charset)Charsets.UTF_8);
            String sign = Session.sign(data);
            String value = S.builder((String)sign).append("-").append(data).toString();
            Cookie cookie = new Cookie(sessionKey).value(value);
            if (expiry > -1L) {
                int ttl = (int)((expiry - System.currentTimeMillis()) / 1000L);
                cookie.maxAge(ttl);
            }
            return cookie;
        }

        private static String sign(String s) {
            return Crypto.sign((String)s, (byte[])s.getBytes(Charsets.UTF_8));
        }

        static /* synthetic */ Pattern access$300() {
            return _PARSER;
        }

        static {
            _PARSER = Pattern.compile("\u0000([^:]*):([^\u0000]*)\u0000");
        }
    }

    public static class KV<T extends KV>
    implements Serializable {
        private static final long serialVersionUID = 891504755320699989L;
        protected Map<String, String> data = C.newMap((Object[])new Object[0]);
        private boolean dirty = false;

        private KV() {
        }

        private KV(Map<String, String> data) {
            E.NPE(data);
            this.data = data;
        }

        public T load(String key, String val) {
            E.illegalArgumentIf((boolean)key.contains(":"));
            this.data.put(key, val);
            return this.me();
        }

        public T put(String key, String val) {
            E.illegalArgumentIf((boolean)key.contains(":"));
            this.dirty = true;
            return this.load(key, val);
        }

        public T put(String key, Object val) {
            String valStr = null == val ? null : val.toString();
            return this.put(key, valStr);
        }

        public String get(String key) {
            return this.data.get(key);
        }

        public Set<String> keySet() {
            return this.data.keySet();
        }

        public boolean isEmpty() {
            return this.data.isEmpty();
        }

        public boolean dirty() {
            return this.dirty;
        }

        public boolean changed() {
            return this.dirty;
        }

        public boolean empty() {
            return this.data.isEmpty();
        }

        public boolean containsKey(String key) {
            return this.data.containsKey(key);
        }

        public boolean contains(String key) {
            return this.containsKey(key);
        }

        public int size() {
            return this.data.size();
        }

        public T remove(String key) {
            this.data.remove(key);
            return this.me();
        }

        public T clear() {
            this.data.clear();
            return this.me();
        }

        public String toString() {
            return this.data.toString();
        }

        protected T me() {
            return (T)this;
        }
    }

    public static class Cookie
    implements Serializable {
        private static final long serialVersionUID = 5325872881041347558L;
        private String name;
        private int maxAge = -1;
        private boolean secure;
        private String path;
        private String domain;
        private String value;
        private boolean httpOnly;
        private int version;
        private Date expires;
        private String comment;

        public Cookie(String name) {
            this(name, "");
        }

        public Cookie(String name, String value) {
            E.NPE((Object)name);
            this.name = name;
            this.value = null == value ? "" : value;
        }

        public Cookie(String name, String value, int maxAge, boolean secure, String path, String domain, boolean httpOnly) {
            this(name, value);
            this.maxAge = maxAge;
            this.secure = secure;
            this.path = path;
            this.domain = domain;
            this.httpOnly = httpOnly;
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        public Cookie value(String value) {
            this.value = value;
            return this;
        }

        public String domain() {
            return this.domain;
        }

        public Cookie domain(String domain) {
            this.domain = domain;
            return this;
        }

        public String path() {
            return this.path;
        }

        public Cookie path(String uri) {
            this.path = uri;
            return this;
        }

        public int maxAge() {
            return this.maxAge;
        }

        public Cookie maxAge(int maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        public Date expires() {
            if (null != this.expires) {
                return this.expires;
            }
            if (this.maxAge < 0) {
                return null;
            }
            return new Date($.ms() + (long)(this.maxAge * 1000));
        }

        public Cookie expires(Date expires) {
            this.expires = expires;
            if (null != expires && -1 == this.maxAge) {
                this.maxAge = (int)((expires.getTime() - $.ms()) / 1000L);
            }
            return this;
        }

        public boolean secure() {
            return this.secure;
        }

        public Cookie secure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public int version() {
            return this.version;
        }

        public Cookie version(int v) {
            this.version = v;
            return this;
        }

        public boolean httpOnly() {
            return this.httpOnly;
        }

        public Cookie httpOnly(boolean httpOnly) {
            this.httpOnly = httpOnly;
            return this;
        }

        public String comment() {
            return this.comment;
        }

        public Cookie comment(String comment) {
            this.comment = comment;
            return this;
        }

        private static void ensureInit() {
            if (!Current.cookieMapInitialized()) {
                Object req = Request.current();
                E.illegalStateIf((null == req ? 1 : 0) != 0);
                ((Request)req)._initCookieMap();
            }
        }

        public static void set(Cookie cookie) {
            Cookie.ensureInit();
            Current.setCookie(cookie.name(), cookie);
        }

        public static Cookie get(String name) {
            Cookie.ensureInit();
            return Current.getCookie(name);
        }

        public static Collection<Cookie> all() {
            Cookie.ensureInit();
            return Current.cookies();
        }

        public static enum F {

            public static final Osgl.F2<Cookie, Response, Void> ADD_TO_RESPONSE = new Osgl.F2<Cookie, Response, Void>(){

                public Void apply(Cookie cookie, Response response) throws NotAppliedException, Osgl.Break {
                    response.addCookie(cookie);
                    return null;
                }
            };
        }
    }

    public static enum MediaType {
        CSS,
        CSV,
        DOC,
        DOCX,
        HTML,
        JAVASCRIPT,
        JSON,
        PDF,
        TXT,
        XLS,
        XLSX,
        XML;

        private Format fmt = Format.valueOf(this.name());

        public Format format() {
            return this.fmt;
        }

        public String toString() {
            return this.fmt.contentType();
        }
    }

    public static class Format
    implements Serializable {
        private static final Map<String, Format> predefined = new LinkedHashMap<String, Format>();
        private static volatile Properties types;
        private int ordinal;
        private String name;
        private String contentType;
        public static final Format HTML;
        @Deprecated
        public static final Format html;
        public static final Format XML;
        @Deprecated
        public static final Format xml;
        public static final Format JSON;
        @Deprecated
        public static final Format json;
        public static final Format CSS;
        public static final Format JAVASCRIPT;
        public static final Format XLS;
        public static final Format xls;
        public static final Format XLSX;
        public static final Format xlsx;
        public static final Format DOC;
        public static final Format doc;
        public static final Format DOCX;
        public static final Format docx;
        public static final Format CSV;
        @Deprecated
        public static final Format csv;
        public static final Format TXT;
        @Deprecated
        public static final Format txt;
        public static final Format PDF;
        @Deprecated
        public static final Format pdf;
        public static final Format RTF;
        @Deprecated
        public static final Format rtf;
        public static final Format GIF;
        public static final Format ICO;
        public static final Format JPG;
        public static final Format BMP;
        public static final Format PNG;
        public static final Format SVG;
        public static final Format TIF;
        public static final Format MOV;
        public static final Format MP4;
        public static final Format MPG;
        public static final Format AVI;
        public static final Format FLV;
        public static final Format MP3;
        public static final Format MPA;
        public static final Format WAV;
        public static final Format FORM_URL_ENCODED;
        @Deprecated
        public static final Format form_url_encoded;
        public static final Format FORM_MULTIPART_DATA;
        @Deprecated
        public static final Format form_multipart_data;
        public static final Format BINARY;
        public static final Format UNKNOWN;
        @Deprecated
        public static final Format unknown;

        private Format(String name, String contentType) {
            this(name, contentType, true);
        }

        private Format(String name, String contentType, boolean predefined) {
            this.name = name.toLowerCase();
            this.contentType = contentType;
            if (predefined) {
                Format.predefined.put(name, this);
                this.ordinal = Format.ordinal(name);
            } else {
                this.ordinal = -1;
            }
        }

        public final String name() {
            return this.name;
        }

        public final int ordinal() {
            return this.ordinal;
        }

        public String contentType() {
            return this.contentType;
        }

        @Deprecated
        public final String toContentType() {
            return this.contentType();
        }

        public final String getName() {
            return this.name();
        }

        public final String getContentType() {
            return this.contentType();
        }

        public boolean isText() {
            return JSON == this || this.contentType.startsWith("text/") || S.eq((String)"application/json", (String)this.contentType);
        }

        public String errorMessage(String message) {
            return message;
        }

        public int hashCode() {
            if (this.ordinal != -1) {
                return this.ordinal;
            }
            return $.hc((Object)this.name, (Object)this.contentType);
        }

        public String toString() {
            return this.name();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Format) {
                Format that = (Format)obj;
                return $.eq((Object)that.name, (Object)this.name) && $.eq((Object)that.contentType, (Object)this.contentType);
            }
            return false;
        }

        private Object readResolve() {
            if (this.ordinal == -1) {
                return this;
            }
            return predefined.get(this.name);
        }

        public static Format[] values() {
            Format[] retVal = new Format[predefined.size()];
            return predefined.values().toArray(retVal);
        }

        public static List<Format> predefined() {
            return C.list(predefined.values());
        }

        public static Format of(String name) {
            return Format.valueOf(name);
        }

        public static Format of(String name, String contentType) {
            return Format.valueOf(name, contentType);
        }

        public static Format valueOf(String name) {
            if ((name = name.toLowerCase()).startsWith(".")) {
                name = S.afterLast((String)name, (String)".");
            }
            return predefined.get(name.toLowerCase());
        }

        public static Format valueOf(String name, String contentType) {
            Format retVal = Format.valueOf(name);
            if (null != retVal) {
                return retVal;
            }
            E.illegalArgumentIf((boolean)S.blank((String)name), (String)"name cannot be blank string");
            E.illegalArgumentIf((boolean)S.blank((String)contentType), (String)"content type cannot be blank string");
            name = name.toLowerCase();
            if (name.startsWith(".")) {
                name = S.afterLast((String)name, (String)".");
            }
            return new Format(name, contentType, false);
        }

        public static Format resolve(Format def, String accept) {
            E.NPE((Object)def);
            return Format.resolve_(def, accept);
        }

        public static Format resolve(Iterable<String> accepts) {
            return Format.resolve(HTML, accepts);
        }

        public static Format resolve(Format def, Iterable<String> accepts) {
            for (String s : accepts) {
                Format retVal = Format.resolve_(null, s);
                if (null == retVal) continue;
                return retVal;
            }
            return (Format)$.ifNullThen((Object)def, (Object)HTML);
        }

        public static Format resolve(String ... accepts) {
            return Format.resolve(HTML, accepts);
        }

        public static Format resolve(Format def, String ... accepts) {
            for (String s : accepts) {
                Format retVal = Format.resolve_(null, s);
                if (null == retVal) continue;
                return retVal;
            }
            return (Format)$.ifNullThen((Object)def, (Object)HTML);
        }

        public static Format resolve(String accept) {
            return Format.resolve_(UNKNOWN, accept);
        }

        public static String toContentType(String fmt) {
            Format f = predefined.get(fmt.toLowerCase());
            if (null == f) {
                f = HTML;
            }
            return f.contentType();
        }

        private static int ordinal(String s) {
            int l = s.length();
            int h = 0;
            for (int i = 0; i < l; ++i) {
                char c = s.charAt(i);
                h = 31 * h + c;
            }
            return h;
        }

        private static Format resolve_(Format def, String contentType) {
            Format fmt = def;
            if (S.blank((String)contentType)) {
                fmt = HTML;
            } else if (contentType.contains("application/xhtml") || contentType.contains("text/html") || contentType.startsWith("*/*")) {
                fmt = HTML;
            } else if (contentType.contains("application/xml") || contentType.contains("text/xml")) {
                fmt = XML;
            } else if (contentType.contains("application/json") || contentType.contains("text/javascript")) {
                fmt = JSON;
            } else if (contentType.contains("application/x-www-form-urlencoded")) {
                fmt = FORM_URL_ENCODED;
            } else if (contentType.contains("multipart/form-data") || contentType.contains("multipart/mixed")) {
                fmt = FORM_MULTIPART_DATA;
            } else if (contentType.contains("text/plain")) {
                fmt = TXT;
            } else if (contentType.contains("csv") || contentType.contains("comma-separated-values")) {
                fmt = CSV;
            } else if (contentType.contains("ms-excel")) {
                fmt = XLS;
            } else if (contentType.contains("spreadsheetml")) {
                fmt = XLSX;
            } else if (contentType.contains("pdf")) {
                fmt = PDF;
            } else if (contentType.contains("msword")) {
                fmt = DOC;
            } else if (contentType.contains("wordprocessingml")) {
                fmt = DOCX;
            } else if (contentType.contains("rtf")) {
                fmt = RTF;
            }
            return fmt;
        }

        static /* synthetic */ int access$100(Format x0) {
            return x0.ordinal;
        }

        static {
            try {
                InputStream is = H.class.getResourceAsStream("mime-types.properties");
                Properties types = new Properties();
                types.load(is);
                for (Object k : types.keySet()) {
                    String fmt = k.toString();
                    String contentType = types.getProperty(fmt);
                    new Format(fmt, contentType);
                }
            }
            catch (IOException e) {
                throw E.ioException((IOException)e);
            }
            html = HTML = Format.valueOf("html");
            xml = XML = Format.valueOf("xml");
            json = JSON = new Format("json", "application/json"){

                @Override
                public String errorMessage(String message) {
                    return S.fmt((String)"{\"error\": \"%s\"}", (Object[])new Object[]{message});
                }
            };
            CSS = new Format("css", "text/css");
            JAVASCRIPT = new Format("javascript", "application/javascript"){

                @Override
                public String errorMessage(String message) {
                    return "alert(" + message + ");";
                }
            };
            xls = XLS = Format.valueOf("xls");
            xlsx = XLSX = Format.valueOf("xlsx");
            doc = DOC = Format.valueOf("doc");
            docx = DOCX = Format.valueOf("docx");
            csv = CSV = Format.valueOf("csv");
            txt = TXT = Format.valueOf("txt");
            pdf = PDF = Format.valueOf("pdf");
            rtf = RTF = Format.valueOf("rtf");
            GIF = Format.valueOf("gif");
            ICO = Format.valueOf("ico");
            JPG = Format.valueOf("jpg");
            BMP = Format.valueOf("bmp");
            PNG = Format.valueOf("png");
            SVG = Format.valueOf("svg");
            TIF = Format.valueOf("tif");
            MOV = Format.valueOf("mov");
            MP4 = Format.valueOf("mp4");
            MPG = Format.valueOf("mpg");
            AVI = Format.valueOf("avi");
            FLV = Format.valueOf("flv");
            MP3 = Format.valueOf("mp3");
            MPA = Format.valueOf("mpa");
            WAV = Format.valueOf("wav");
            form_url_encoded = FORM_URL_ENCODED = new Format("form_url_encoded", "application/x-www-form-urlencoded");
            form_multipart_data = FORM_MULTIPART_DATA = new Format("form_multipart_data", "multipart/form-data");
            BINARY = new Format("binary", "application/octet-stream");
            unknown = UNKNOWN = new Format("unknown", "text/html"){

                @Override
                public String contentType() {
                    String s = Current.format();
                    if (!S.blank((String)s)) {
                        return 3.toContentType(s);
                    }
                    return "text/html";
                }

                @Override
                public String toString() {
                    String s = Current.format();
                    return null == s ? this.name() : s;
                }
            };
        }

        public static final class Ordinal {
            public static final int HTML = Format.access$100(HTML);
            public static final int XML = Format.access$100(XML);
            public static final int JSON = Format.access$100(JSON);
            public static final int XLS = Format.access$100(XLS);
            public static final int XLSX = Format.access$100(XLSX);
            public static final int DOC = Format.access$100(DOC);
            public static final int DOCX = Format.access$100(DOCX);
            public static final int CSV = Format.access$100(CSV);
            public static final int TXT = Format.access$100(TXT);
            public static final int PDF = Format.access$100(PDF);
            public static final int RTF = Format.access$100(RTF);
            public static final int GIF = Format.access$100(GIF);
            public static final int ICO = Format.access$100(ICO);
            public static final int JPG = Format.access$100(JPG);
            public static final int BMP = Format.access$100(BMP);
            public static final int PNG = Format.access$100(PNG);
            public static final int SVG = Format.access$100(SVG);
            public static final int TIF = Format.access$100(TIF);
            public static final int MOV = Format.access$100(MOV);
            public static final int MP4 = Format.access$100(MP4);
            public static final int MPG = Format.access$100(MPG);
            public static final int AVI = Format.access$100(AVI);
            public static final int FLV = Format.access$100(FLV);
            public static final int MP3 = Format.access$100(MP3);
            public static final int MPA = Format.access$100(MPA);
            public static final int WAV = Format.access$100(WAV);
            public static final int FORM_URL_ENCODED = Format.access$100(FORM_URL_ENCODED);
            public static final int FORM_MULTIPART_DATA = Format.access$100(FORM_MULTIPART_DATA);
        }
    }

    public static final class Header
    implements Serializable {
        private static final long serialVersionUID = -3987421318751857114L;
        private String name;
        private C.List<String> values;

        public Header(String name, String value) {
            E.NPE((Object)name);
            this.name = name;
            this.values = C.list((Object)value);
        }

        public Header(String name, String ... values) {
            E.NPE((Object)name);
            this.name = name;
            this.values = C.listOf((Object[])values);
        }

        public Header(String name, Iterable<String> values) {
            E.NPE((Object)name);
            this.name = name;
            this.values = C.list(values);
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return (String)this.values.get(0);
        }

        public C.List<String> values() {
            return this.values;
        }

        public String toString() {
            return this.values.toString();
        }

        public static final class Names {
            public static final String ACCEPT = "Accept";
            public static final String ACCEPT_CHARSET = "Accept-Charset";
            public static final String ACCEPT_ENCODING = "Accept-Encoding";
            public static final String ACCEPT_LANGUAGE = "Accept-Language";
            public static final String ACCEPT_RANGES = "Accept-Ranges";
            public static final String ACCEPT_PATCH = "Accept-Patch";
            public static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
            public static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
            public static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
            public static final String ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
            public static final String ACCESS_CONTROL_EXPOSE_HEADERS = "Access-Control-Expose-Headers";
            public static final String ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
            public static final String ACCESS_CONTROL_REQUEST_METHOD = "Access-Control-Request-Method";
            public static final String ACCESS_CONTROL_REQUEST_HEADERS = "Access-Control-Request-Headers";
            public static final String AGE = "Age";
            public static final String ALLOW = "Allow";
            public static final String AUTHORIZATION = "Authorization";
            public static final String CACHE_CONTROL = "Cache-Control";
            public static final String CONNECTION = "Connection";
            public static final String CONTENT_BASE = "Content-Base";
            public static final String CONTENT_DISPOSITION = "Content-Disposition";
            public static final String CONTENT_ENCODING = "Content-Encoding";
            public static final String CONTENT_LANGUAGE = "Content-Language";
            public static final String CONTENT_LENGTH = "Content-Length";
            public static final String CONTENT_LOCATION = "Content-Location";
            public static final String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
            public static final String CONTENT_MD5 = "Content-Md5";
            public static final String CONTENT_RANGE = "Content-Range";
            public static final String CONTENT_TYPE = "Content-Type";
            public static final String COOKIE = "Cookie";
            public static final String DATE = "Date";
            public static final String ETAG = "Etag";
            public static final String EXPECT = "Expect";
            public static final String EXPIRES = "Expires";
            public static final String FROM = "From";
            public static final String FRONT_END_HTTPS = "Front-End-Https";
            public static final String HOST = "Host";
            public static final String HTTP_CLIENT_IP = "HTTP_CLIENT_IP";
            public static final String HTTP_X_FORWARDED_FOR = "HTTP_X_FORWARDED_FOR";
            public static final String IF_MATCH = "If-Match";
            public static final String IF_MODIFIED_SINCE = "If-Modified-Since";
            public static final String IF_NONE_MATCH = "If-None-Match";
            public static final String IF_RANGE = "If-Range";
            public static final String IF_UNMODIFIED_SINCE = "If-Unmodified-Since";
            public static final String LAST_MODIFIED = "Last-Modified";
            public static final String LOCATION = "Location";
            public static final String MAX_FORWARDS = "Max-Forwards";
            public static final String ORIGIN = "Origin";
            public static final String PRAGMA = "Pragma";
            public static final String PROXY_AUTHENTICATE = "Proxy-Authenticate";
            public static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
            public static final String PROXY_CLIENT_IP = "Proxy-Client-ip";
            public static final String PROXY_CONNECTION = "Proxy_Connection";
            public static final String RANGE = "Range";
            public static final String REFERER = "Referer";
            public static final String RETRY_AFTER = "Retry-After";
            public static final String RLNCLIENTIPADDR = "rlnclientipaddr";
            public static final String SEC_WEBSOCKET_KEY1 = "Sec-Websocket-Key1";
            public static final String SEC_WEBSOCKET_KEY2 = "Sec-Websocket-Key2";
            public static final String SEC_WEBSOCKET_LOCATION = "Sec-Websocket-Location";
            public static final String SEC_WEBSOCKET_ORIGIN = "Sec-Websocket-Rrigin";
            public static final String SEC_WEBSOCKET_PROTOCOL = "Sec-Websocket-Protocol";
            public static final String SEC_WEBSOCKET_VERSION = "Sec-Websocket-Version";
            public static final String SEC_WEBSOCKET_KEY = "Sec-Websocket-Key";
            public static final String SEC_WEBSOCKET_ACCEPT = "Sec-Websocket-Accept";
            public static final String SERVER = "Server";
            public static final String SET_COOKIE = "Set-Cookie";
            public static final String SET_COOKIE2 = "Set-Cookie2";
            public static final String TE = "TE";
            public static final String TRAILER = "Trailer";
            public static final String TRANSFER_ENCODING = "Transfer-Encoding";
            public static final String UPGRADE = "Upgrade";
            public static final String USER_AGENT = "User-Agent";
            public static final String VARY = "Vary";
            public static final String VIA = "Via";
            public static final String WARNING = "Warning";
            public static final String WEBSOCKET_LOCATION = "Websocket-Location";
            public static final String WEBSOCKET_ORIGIN = "Webwocket-Origin";
            public static final String WEBSOCKET_PROTOCOL = "Websocket-Protocol";
            public static final String WL_PROXY_CLIENT_IP = "Wl-Proxy-Client-Ip";
            public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
            public static final String X_REQUESTED_WITH = "X-Requested-With";
            public static final String X_FORWARDED_HOST = "X-Forwarded-Host";
            public static final String X_FORWARDED_FOR = "X-Forwarded-For";
            public static final String X_FORWARDED_PROTO = "X-Forwarded-Proto";
            public static final String X_FORWARDED_SSL = "X-Forwarded-Ssl";
            public static final String X_HTTP_METHOD_OVERRIDE = "X-Http-Method-Override";
            public static final String X_URL_SCHEME = "X-Url-Scheme";
            public static final String X_XSRF_TOKEN = "X-Xsrf-Token";

            private Names() {
            }
        }
    }

    public static final class Status
    implements Serializable,
    Comparable<Status> {
        private static final Map<Integer, Status> predefinedStatus = new LinkedHashMap<Integer, Status>();
        private static final long serialVersionUID = -286619406116817809L;
        private int code;
        public static final Status CONTINUE = new Status(100);
        public static final Status SWITCHING_PROTOCOLS = new Status(101);
        public static final Status PROCESSING = new Status(102);
        public static final Status CHECKPOINT = new Status(103);
        public static final Status OK = new Status(200);
        public static final Status CREATED = new Status(201);
        public static final Status ACCEPTED = new Status(202);
        public static final Status NON_AUTHORITATIVE_INFORMATION = new Status(203);
        public static final Status NO_CONTENT = new Status(204);
        public static final Status RESET_CONTENT = new Status(205);
        public static final Status PARTIAL_CONTENT = new Status(206);
        public static final Status MULTI_STATUS = new Status(207);
        public static final Status ALREADY_REPORTED = new Status(208);
        public static final Status IM_USED = new Status(226);
        public static final Status FOUND_AJAX = new Status(278);
        public static final Status MULTIPLE_CHOICES = new Status(300);
        public static final Status MOVED_PERMANENTLY = new Status(301);
        public static final Status FOUND = new Status(302);
        @Deprecated
        public static final Status MOVED_TEMPORARILY = new Status(302);
        public static final Status SEE_OTHER = new Status(303);
        public static final Status NOT_MODIFIED = new Status(304);
        public static final Status USE_PROXY = new Status(305);
        public static final Status TEMPORARY_REDIRECT = new Status(307);
        public static final Status RESUME_INCOMPLETE = new Status(308);
        public static final Status BAD_REQUEST = new Status(400);
        public static final Status UNAUTHORIZED = new Status(401);
        public static final Status PAYMENT_REQUIRED = new Status(402);
        public static final Status FORBIDDEN = new Status(403);
        public static final Status NOT_FOUND = new Status(404);
        public static final Status METHOD_NOT_ALLOWED = new Status(405);
        public static final Status NOT_ACCEPTABLE = new Status(406);
        public static final Status PROXY_AUTHENTICATION_REQUIRED = new Status(407);
        public static final Status REQUEST_TIMEOUT = new Status(408);
        public static final Status CONFLICT = new Status(409);
        public static final Status GONE = new Status(410);
        public static final Status LENGTH_REQUIRED = new Status(411);
        public static final Status PRECONDITION_FAILED = new Status(412);
        public static final Status REQUEST_ENTITY_TOO_LARGE = new Status(413);
        public static final Status REQUEST_URI_TOO_LONG = new Status(414);
        public static final Status UNSUPPORTED_MEDIA_TYPE = new Status(415);
        public static final Status REQUESTED_RANGE_NOT_SATISFIABLE = new Status(416);
        public static final Status EXPECTATION_FAILED = new Status(417);
        public static final Status I_AM_A_TEAPOT = new Status(418);
        @Deprecated
        public static final Status INSUFFICIENT_SPACE_ON_RESOURCE = new Status(419);
        @Deprecated
        public static final Status METHOD_FAILURE = new Status(420);
        @Deprecated
        public static final Status DESTINATION_LOCKED = new Status(421);
        public static final Status UNPROCESSABLE_ENTITY = new Status(422);
        public static final Status LOCKED = new Status(423);
        public static final Status FAILED_DEPENDENCY = new Status(424);
        public static final Status UPGRADE_REQUIRED = new Status(426);
        public static final Status PRECONDITION_REQUIRED = new Status(428);
        public static final Status TOO_MANY_REQUESTS = new Status(429);
        public static final Status REQUEST_HEADER_FIELDS_TOO_LARGE = new Status(431);
        public static final Status INTERNAL_SERVER_ERROR = new Status(500);
        public static final Status NOT_IMPLEMENTED = new Status(501);
        public static final Status BAD_GATEWAY = new Status(502);
        public static final Status SERVICE_UNAVAILABLE = new Status(503);
        public static final Status GATEWAY_TIMEOUT = new Status(504);
        public static final Status HTTP_VERSION_NOT_SUPPORTED = new Status(505);
        public static final Status VARIANT_ALSO_NEGOTIATES = new Status(506);
        public static final Status INSUFFICIENT_STORAGE = new Status(507);
        public static final Status LOOP_DETECTED = new Status(508);
        public static final Status BANDWIDTH_LIMIT_EXCEEDED = new Status(509);
        public static final Status NOT_EXTENDED = new Status(510);
        public static final Status NETWORK_AUTHENTICATION_REQUIRED = new Status(511);

        private Status(int code) {
            this(code, true);
        }

        private Status(int code, boolean predefined) {
            this.code = code;
            if (predefined) {
                predefinedStatus.put(code, this);
            }
        }

        public final int code() {
            return this.code;
        }

        public boolean isError() {
            return this.isClientError() || this.isServerError();
        }

        public boolean isServerError() {
            return this.code / 100 == 5;
        }

        public boolean isClientError() {
            return this.code / 100 == 4;
        }

        public boolean isSuccess() {
            return this.code / 100 == 2;
        }

        public boolean isRedirect() {
            return this.code / 100 == 3;
        }

        public boolean isInformational() {
            return this.code / 100 == 1;
        }

        public String toString() {
            return Integer.toString(this.code);
        }

        public int hashCode() {
            return this.code;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Status) {
                Status that = (Status)obj;
                return that.code() == this.code;
            }
            return false;
        }

        @Override
        public int compareTo(Status o) {
            return this.code - o.code;
        }

        protected final Object clone() throws CloneNotSupportedException {
            throw new CloneNotSupportedException();
        }

        private Object readResolve() {
            Status predefined = predefinedStatus.get(this.code);
            return null != predefined ? predefined : this;
        }

        public static Status of(int n) {
            return Status.valueOf(n);
        }

        public static Status valueOf(int n) {
            E.illegalArgumentIf((n < 100 || n > 599 ? 1 : 0) != 0, (String)"invalid http status code: %s", (Object[])new Object[]{n});
            Status retVal = predefinedStatus.get(n);
            if (null == retVal) {
                retVal = new Status(n, false);
            }
            return retVal;
        }

        public static List<Status> predefined() {
            return C.list(predefinedStatus.values());
        }
    }

    public static enum Method {
        GET,
        HEAD,
        POST,
        DELETE,
        PUT,
        PATCH,
        TRACE,
        OPTIONS,
        CONNECT;

        private static EnumSet<Method> unsafeMethods;
        private static EnumSet<Method> actionMethods;

        public boolean safe() {
            return !this.unsafe();
        }

        public boolean unsafe() {
            return unsafeMethods.contains((Object)this);
        }

        public static Method valueOfIgnoreCase(String method) {
            return Method.valueOf(method.toUpperCase());
        }

        public static EnumSet<Method> actionMethods() {
            return actionMethods.clone();
        }

        static {
            unsafeMethods = EnumSet.of(POST, DELETE, PUT, PATCH);
            actionMethods = EnumSet.of(GET, POST, PUT, DELETE);
        }
    }
}

