/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.storage;

import java.util.Calendar;
import org.osgl.storage.KeyNameProvider;
import org.osgl.util.E;
import org.osgl.util.S;

public interface KeyGenerator {
    public String getKey(String var1, KeyNameProvider var2);

    public static enum Predefined implements KeyGenerator
    {
        PLAIN{

            @Override
            protected String tmpl() {
                return null;
            }
        }
        ,
        BY_DATE{

            @Override
            protected String tmpl() {
                return "%1$tY/%1$tm/%1$td/%2$s";
            }
        }
        ,
        BY_HOUR{

            @Override
            protected String tmpl() {
                return "%1$tY/%1$tm/%1$td/%1$tH/%2$s";
            }
        }
        ,
        BY_MINUTE{

            @Override
            protected String tmpl() {
                return "%1$tY/%1$tm/%1$td/%1$tH/%1$tM/%2$s";
            }
        }
        ,
        BY_SECOND{

            @Override
            protected String tmpl() {
                return "%1$tY/%1$tm/%1$td/%1$tH/%1$tM/%1$tS/%2$s";
            }
        }
        ,
        BY_DATETIME{

            @Override
            protected String tmpl() {
                return "%1$tY/%1$tm/%1$td/%1$tH/%1$tM/%1$tS/%2$s";
            }
        };


        protected abstract String tmpl();

        @Override
        public String getKey(String name, KeyNameProvider keyNameProvider) {
            String tmpl;
            if (S.blank((String)name)) {
                name = keyNameProvider.newKeyName();
            }
            if (S.blank((String)(tmpl = this.tmpl()))) {
                return name;
            }
            return S.fmt((String)tmpl, (Object[])new Object[]{Calendar.getInstance(), name});
        }

        public static KeyGenerator valueOfIgnoreCase(String s) {
            E.NPE((Object)s);
            if (BY_DATE.name().equalsIgnoreCase(s) || "byDate".equalsIgnoreCase(s) || "date".equalsIgnoreCase(s)) {
                return BY_DATE;
            }
            if (BY_HOUR.name().equalsIgnoreCase(s) || "byHour".equalsIgnoreCase(s) || "hour".equalsIgnoreCase(s)) {
                return BY_HOUR;
            }
            if (BY_MINUTE.name().equalsIgnoreCase(s) || "byMinute".equalsIgnoreCase(s) || "minute".equalsIgnoreCase(s) || "min".equalsIgnoreCase(s)) {
                return BY_MINUTE;
            }
            if (PLAIN.name().equalsIgnoreCase(s)) {
                return PLAIN;
            }
            if ("BY_DATETIME".equalsIgnoreCase(s) || "byDateTime".equalsIgnoreCase(s) || "dateTime".equalsIgnoreCase(s) || BY_SECOND.name().equalsIgnoreCase(s) || "bySecond".equalsIgnoreCase(s) || "second".equalsIgnoreCase(s) || "sec".equalsIgnoreCase(s)) {
                return BY_SECOND;
            }
            return null;
        }
    }
}

