/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.storage.impl;

import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.blob.BlobContainerPermissions;
import com.microsoft.azure.storage.blob.BlobContainerPublicAccessType;
import com.microsoft.azure.storage.blob.BlobProperties;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Map;
import org.osgl.exception.ConfigurationException;
import org.osgl.storage.ISObject;
import org.osgl.storage.IStorageService;
import org.osgl.storage.impl.AzureObject;
import org.osgl.storage.impl.SObject;
import org.osgl.storage.impl.StorageServiceBase;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureService
extends StorageServiceBase<AzureObject>
implements IStorageService {
    private static Logger log = LoggerFactory.getLogger(AzureService.class);
    public static final String CONF_PROTOCOL = "storage.azure.protocol";
    public static final String CONF_ACCOUNT_NAME = "storage.azure.account.name";
    public static final String CONF_ACCOUNT_KEY = "storage.azure.account.key";
    public static final String CONF_BUCKET = "storage.azure.bucket";
    private static final String CONNECTION_PATTERN = "DefaultEndpointsProtocol={0};AccountName={1};AccountKey={2};";
    private static final String URL_PATTERN = "http://{0}.blob.core.windows.net/{1}/{2}";
    private CloudBlobClient blobClient;
    private CloudBlobContainer blobContainer;
    private String accountName;

    public AzureService(Map<String, String> conf) {
        super(conf, AzureObject.class);
    }

    @Override
    protected void configure(Map<String, String> conf) {
        super.configure(conf, "azure");
        String protocol = this.getConfValue(conf, CONF_PROTOCOL, "");
        String accountKey = this.getConfValue(conf, CONF_ACCOUNT_KEY, "");
        this.accountName = this.getConfValue(conf, CONF_ACCOUNT_NAME, "");
        this.connect(protocol, this.accountName, accountKey, conf.get(CONF_BUCKET));
    }

    private void connect(String protocol, String accountName, String accountKey, String bucketName) {
        if (bucketName == null || bucketName.trim().isEmpty()) {
            throw new ConfigurationException("Defined Azure Blog bucket is invalid.");
        }
        bucketName = bucketName.toLowerCase();
        String connectionString = MessageFormat.format(CONNECTION_PATTERN, protocol, accountName, accountKey);
        try {
            CloudStorageAccount blobAccount = CloudStorageAccount.parse((String)connectionString);
            this.blobClient = blobAccount.createCloudBlobClient();
            this.blobContainer = this.blobClient.getContainerReference(bucketName);
            boolean isBucketNotExist = this.blobContainer.createIfNotExists();
            if (isBucketNotExist) {
                log.info("New Azure Blob container created: " + bucketName);
            }
            BlobContainerPermissions containerPermissions = new BlobContainerPermissions();
            containerPermissions.setPublicAccess(BlobContainerPublicAccessType.CONTAINER);
            this.blobContainer.uploadPermissions(containerPermissions);
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            throw new ConfigurationException((Throwable)exception);
        }
    }

    @Override
    protected void doRemove(String fullPath) {
        try {
            CloudBlockBlob blob = this.blobContainer.getBlockBlobReference(fullPath);
            blob.deleteIfExists();
        }
        catch (Exception e) {
            throw E.unexpected((Throwable)e);
        }
    }

    @Override
    public String getUrl(String key) {
        return MessageFormat.format(URL_PATTERN, this.accountName, this.blobContainer.getName(), this.keyWithContextPath(key));
    }

    @Override
    protected String keyWithContextPath(String key) {
        String fullPath = super.keyWithContextPath(key);
        if (fullPath.startsWith("/")) {
            fullPath = fullPath.substring(1);
        }
        return fullPath;
    }

    @Override
    protected Map<String, String> doGetMeta(String fullPath) {
        try {
            CloudBlockBlob blob = this.blobContainer.getBlockBlobReference(fullPath);
            blob.downloadAttributes();
            C.Map meta = C.newMap((Map)blob.getMetadata());
            meta.put("content-type", blob.getProperties().getContentType());
            return meta;
        }
        catch (Exception e) {
            throw E.unexpected((Throwable)e);
        }
    }

    @Override
    protected ISObject newSObject(String key) {
        return new AzureObject(key, this);
    }

    @Override
    protected void doPut(String fullPath, ISObject stuff, Map<String, String> attrs) {
        try {
            CloudBlockBlob blob = this.blobContainer.getBlockBlobReference(fullPath);
            if (!(stuff instanceof SObject.InputStreamSObject)) {
                blob.upload(stuff.asInputStream(), stuff.getLength());
            }
            BlobProperties props = blob.getProperties();
            String contentType = attrs.remove("content-type");
            if (S.notBlank((String)contentType)) {
                props.setContentType(contentType);
            }
            blob.uploadProperties();
            blob.getMetadata().putAll(attrs);
            blob.uploadMetadata();
        }
        catch (Exception e) {
            throw E.unexpected((Throwable)e);
        }
    }

    @Override
    protected StorageServiceBase newService(Map<String, String> conf) {
        return new AzureService(conf);
    }

    @Override
    protected InputStream doGetInputStream(String fullPath) {
        try {
            CloudBlockBlob blob = this.blobContainer.getBlockBlobReference(fullPath);
            return blob.openInputStream();
        }
        catch (Exception exception) {
            throw E.unexpected((Throwable)exception);
        }
    }
}

