/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.storage.impl;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.codec.Charsets;
import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.exception.UnexpectedIOException;
import org.osgl.storage.ISObject;
import org.osgl.storage.IStorageService;
import org.osgl.util.C;
import org.osgl.util.Codec;
import org.osgl.util.E;
import org.osgl.util.IO;
import org.osgl.util.S;

public abstract class SObject
implements ISObject {
    private String key;
    private Map<String, String> attrs = new HashMap<String, String>();
    private boolean valid = true;
    private Throwable cause = null;

    SObject(String key) {
        if (null == key) {
            throw new NullPointerException();
        }
        this.key = key;
    }

    @Override
    public boolean isDumb() {
        return false;
    }

    public static SObject getInvalidObject(String key, Throwable cause) {
        SObject sobj = SObject.of(key, "");
        sobj.valid = false;
        sobj.cause = cause;
        return sobj;
    }

    public static ISObject getDumpObject(String key) {
        StringSObject sobj = new StringSObject(key, "");
        sobj.dumb = true;
        return sobj;
    }

    public static ISObject getDumpObject(String key, Map<String, String> attrs) {
        SObject sobj = SObject.of(key, "");
        sobj.setAttrs(attrs);
        return sobj;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    protected void setAttrs(Map<String, String> attrs) {
        if (null == attrs) {
            return;
        }
        this.attrs.putAll(attrs);
    }

    @Override
    public String getUrl() {
        return this.attrs.get("url");
    }

    @Override
    public String getAttribute(String key) {
        return this.attrs.get(key);
    }

    @Override
    public ISObject setAttribute(String key, String val) {
        this.attrs.put(key, val);
        return this;
    }

    @Override
    public ISObject setAttributes(Map<String, String> attrs) {
        this.setAttrs(attrs);
        return this;
    }

    @Override
    public boolean hasAttribute() {
        return !this.attrs.isEmpty();
    }

    @Override
    public Map<String, String> getAttributes() {
        return C.newMap(this.attrs);
    }

    @Override
    public boolean isEmpty() {
        String s = this.asString();
        return null == s || "".equals(s);
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public Throwable getException() {
        return this.cause;
    }

    @Override
    public void consumeOnce(Osgl.Function<InputStream, ?> consumer) {
        InputStream is = null;
        try {
            is = this.asInputStream();
            consumer.apply((Object)is);
        }
        finally {
            IO.close((Closeable)is);
        }
    }

    protected final String suffix() {
        int pos;
        String originalFilename = this.getAttribute("filename");
        if (S.notBlank((String)originalFilename) && (pos = originalFilename.lastIndexOf(".")) > -1) {
            return originalFilename.substring(pos, originalFilename.length());
        }
        return "";
    }

    public static SObject of(File file) {
        return SObject.of(file.getPath(), file);
    }

    public static SObject of(String key, File file) {
        if (file.canRead() && file.isFile()) {
            FileSObject sobj = new FileSObject(key, file);
            sobj.setAttribute("filename", file.getName());
            sobj.setAttribute("content-type", new MimetypesFileTypeMap().getContentType(file));
            return sobj;
        }
        return SObject.getInvalidObject(key, new IOException("File is a directory or not readable"));
    }

    @Deprecated
    public static SObject valueOf(String key, File f2) {
        return SObject.of(key, f2);
    }

    public static SObject of(String key, File file, Map<String, String> attributes) {
        SObject sobj = SObject.of(key, (File)$.notNull((Object)file));
        sobj.setAttributes(attributes);
        return sobj;
    }

    @Deprecated
    public static SObject valueOf(String key, File file, Map<String, String> conf) {
        return SObject.of(key, file, conf);
    }

    public static SObject of(String key, File file, String ... attrs) {
        SObject sobj = SObject.of(key, (File)$.notNull((Object)file));
        Map map = C.map((Object[])attrs);
        sobj.setAttributes(map);
        return sobj;
    }

    @Deprecated
    public static SObject valueOf(String key, File file, String ... attrs) {
        return SObject.of(key, file, attrs);
    }

    public static SObject of(InputStream is) {
        return SObject.of(SObject.randomKey(), (InputStream)$.notNull((Object)is));
    }

    public static SObject of(String key, InputStream is) {
        try {
            return new InputStreamSObject(key, (InputStream)$.notNull((Object)is));
        }
        catch (Exception e) {
            return SObject.getInvalidObject(key, e);
        }
    }

    @Deprecated
    public static SObject valueOf(String key, InputStream is) {
        return SObject.of(key, is);
    }

    public static SObject of(String key, InputStream is, Map<String, String> conf) {
        SObject sobj = SObject.of(key, is);
        sobj.setAttributes(conf);
        return sobj;
    }

    @Deprecated
    public static SObject valueOf(String key, InputStream is, Map<String, String> conf) {
        return SObject.of(key, is, conf);
    }

    public static SObject of(String key, InputStream is, String ... attrs) {
        SObject sobj = SObject.of(key, is);
        Map map = C.map((Object[])attrs);
        sobj.setAttributes(map);
        return sobj;
    }

    @Deprecated
    public static SObject valueOf(String key, InputStream is, String ... attrs) {
        return SObject.of(key, is, attrs);
    }

    public static SObject of(String content) {
        return new StringSObject(SObject.randomKey(), content);
    }

    public static SObject of(String key, String content) {
        return new StringSObject(key, (String)$.notNull((Object)content));
    }

    @Deprecated
    public static SObject valueOf(String key, String content) {
        return SObject.of(key, content);
    }

    public static SObject of(String key, String content, Map<String, String> attrs) {
        SObject sobj = SObject.of(key, content);
        sobj.setAttributes(attrs);
        return sobj;
    }

    @Deprecated
    public static SObject valueOf(String key, String content, Map<String, String> attrs) {
        return SObject.of(key, content, attrs);
    }

    public static SObject of(String key, String content, String ... attrs) {
        SObject sobj = SObject.of(key, content);
        Map map = C.map((Object[])attrs);
        sobj.setAttributes(map);
        return sobj;
    }

    @Deprecated
    public static SObject valueOf(String key, String content, String ... attrs) {
        return SObject.of(key, content, attrs);
    }

    public static SObject of(byte[] buf) {
        return SObject.of(SObject.randomKey(), (byte[])$.notNull((Object)buf));
    }

    public static SObject of(String key, byte[] buf) {
        return new ByteArraySObject(key, (byte[])$.notNull((Object)buf));
    }

    @Deprecated
    public static SObject valueOf(String key, byte[] buf) {
        return SObject.of(key, buf);
    }

    public static SObject of(String key, byte[] buf, Map<String, String> attrs) {
        SObject sobj = SObject.of(key, (byte[])$.notNull((Object)buf));
        sobj.setAttributes(attrs);
        return sobj;
    }

    @Deprecated
    public static SObject valueOf(String key, byte[] buf, Map<String, String> attrs) {
        return SObject.of(key, buf, attrs);
    }

    public static SObject of(String key, byte[] buf, String ... attrs) {
        SObject sobj = SObject.of(key, (byte[])$.notNull((Object)buf));
        Map map = C.map((Object[])attrs);
        sobj.setAttributes(map);
        return sobj;
    }

    @Deprecated
    public static SObject valueOf(String key, byte[] buf, String ... attrs) {
        return SObject.of(key, buf, attrs);
    }

    public static SObject valueOf(String key, ISObject copy) {
        SObject sobj = SObject.of(key, copy.asByteArray());
        sobj.setAttrs(copy.getAttributes());
        return sobj;
    }

    public static SObject lazyLoad(String key, IStorageService ss) {
        return new LazyLoadSObject(key, ss);
    }

    public static SObject lazyLoad(String key, IStorageService ss, Map<String, String> conf) {
        SObject sobj = SObject.lazyLoad(key, ss);
        sobj.setAttributes(conf);
        return sobj;
    }

    public static SObject lazyLoad(String key, IStorageService ss, String ... attrs) {
        SObject sobj = SObject.lazyLoad(key, ss);
        Map map = C.map((Object[])attrs);
        sobj.setAttributes(map);
        return sobj;
    }

    private static File createTempFile(String suffix) {
        try {
            return File.createTempFile("sobj_", suffix);
        }
        catch (IOException e) {
            throw E.ioException((IOException)e);
        }
    }

    private static String randomKey() {
        return Codec.encodeUrl((String)S.random());
    }

    static class LazyLoadSObject
    extends SObject {
        private volatile ISObject sobj_;
        private IStorageService ss_;

        LazyLoadSObject(String key, IStorageService ss) {
            super(key);
            E.NPE((Object)ss);
            this.ss_ = ss;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ISObject force() {
            if (null == this.sobj_) {
                LazyLoadSObject lazyLoadSObject = this;
                synchronized (lazyLoadSObject) {
                    if (null == this.sobj_) {
                        this.sobj_ = this.ss_.get(this.getKey());
                    }
                }
            }
            return this.sobj_;
        }

        @Override
        public long getLength() {
            return null == this.sobj_ ? -1L : this.sobj_.getLength();
        }

        @Override
        public File asFile() throws UnexpectedIOException {
            return this.force().asFile();
        }

        @Override
        public String asString() throws UnexpectedIOException {
            return this.force().asString();
        }

        @Override
        public String asString(Charset charset) throws UnexpectedIOException {
            return this.force().asString(charset);
        }

        @Override
        public byte[] asByteArray() throws UnexpectedIOException {
            return this.force().asByteArray();
        }

        @Override
        public InputStream asInputStream() throws UnexpectedIOException {
            return this.force().asInputStream();
        }
    }

    static class InputStreamSObject
    extends SObject {
        private final InputStream is_;

        InputStreamSObject(String key, InputStream is) {
            super(key);
            E.NPE((Object)is);
            this.is_ = is;
        }

        @Override
        public byte[] asByteArray() {
            return IO.readContent((InputStream)this.is_);
        }

        @Override
        public File asFile() {
            File tmpFile = SObject.createTempFile(this.suffix());
            IO.write((InputStream)this.is_, (File)tmpFile);
            return tmpFile;
        }

        @Override
        public InputStream asInputStream() {
            return this.is_;
        }

        @Override
        public String asString() {
            return this.asString(Charsets.UTF_8);
        }

        @Override
        public String asString(Charset charset) throws UnexpectedIOException {
            return new String(this.asByteArray(), charset);
        }

        @Override
        public long getLength() {
            throw E.unsupport();
        }
    }

    static class ByteArraySObject
    extends SObject {
        protected byte[] buf_;

        ByteArraySObject(String key, byte[] buf) {
            super(key);
            E.NPE((Object)buf);
            this.buf_ = buf;
        }

        @Override
        public byte[] asByteArray() {
            int len = this.buf_.length;
            byte[] ba = new byte[len];
            System.arraycopy(this.buf_, 0, ba, 0, len);
            return ba;
        }

        @Override
        public File asFile() {
            File tmpFile = SObject.createTempFile(this.suffix());
            IO.write((byte[])this.buf_, (File)tmpFile);
            return tmpFile;
        }

        @Override
        public InputStream asInputStream() {
            return IO.is((byte[])this.buf_);
        }

        @Override
        public String asString() {
            return this.asString(Charsets.UTF_8);
        }

        @Override
        public String asString(Charset charset) throws UnexpectedIOException {
            return new String(this.buf_, charset);
        }

        @Override
        public long getLength() {
            return this.buf_.length;
        }
    }

    static class FileSObject
    extends SObject {
        private File file_;
        private SoftReference<byte[]> cache;

        FileSObject(String key, File file) {
            super(key);
            E.NPE((Object)file);
            this.file_ = file;
        }

        private synchronized byte[] read() {
            byte[] ba;
            if (null != this.cache && null != (ba = this.cache.get())) {
                return ba;
            }
            ba = IO.readContent((File)this.file_);
            this.cache = new SoftReference<byte[]>(ba);
            return ba;
        }

        @Override
        public long getLength() {
            return this.file_.length();
        }

        @Override
        public File asFile() throws UnexpectedIOException {
            return this.file_;
        }

        @Override
        public String asString() throws UnexpectedIOException {
            return this.asString(Charsets.UTF_8);
        }

        @Override
        public String asString(Charset charset) throws UnexpectedIOException {
            return new String(this.read(), charset);
        }

        @Override
        public byte[] asByteArray() throws UnexpectedIOException {
            return this.read();
        }

        @Override
        public InputStream asInputStream() throws UnexpectedIOException {
            return IO.is((File)this.file_);
        }
    }

    static class StringSObject
    extends SObject {
        private String s_ = null;
        private boolean dumb = false;

        StringSObject(String key, String s) {
            super(key);
            this.s_ = null == s ? "" : s;
        }

        @Override
        public byte[] asByteArray() {
            return this.s_.getBytes();
        }

        @Override
        public File asFile() {
            File tmpFile = SObject.createTempFile(this.suffix());
            IO.writeContent((CharSequence)this.s_, (File)tmpFile);
            return tmpFile;
        }

        @Override
        public InputStream asInputStream() {
            return IO.is((byte[])this.asByteArray());
        }

        @Override
        public String asString() {
            return this.s_;
        }

        @Override
        public String asString(Charset charset) throws UnexpectedIOException {
            return this.s_;
        }

        @Override
        public long getLength() {
            return this.s_.length();
        }

        @Override
        public boolean isDumb() {
            return this.dumb;
        }

        public int hashCode() {
            return $.hc((Object)this.getKey());
        }

        public String toString() {
            return this.s_;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof SObject) {
                SObject that = (SObject)obj;
                return $.eq((Object)that.getKey(), (Object)this.getKey()) && $.eq((Object)that.asString().toString(), (Object)this.toString());
            }
            return false;
        }
    }
}

