/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.storage.impl;

import java.io.InputStream;
import java.util.Map;
import org.osgl.$;
import org.osgl.logging.L;
import org.osgl.logging.Logger;
import org.osgl.storage.ISObject;
import org.osgl.storage.IStorageService;
import org.osgl.storage.KeyGenerator;
import org.osgl.storage.KeyNameProvider;
import org.osgl.storage.impl.SObject;
import org.osgl.util.C;
import org.osgl.util.FastStr;
import org.osgl.util.S;

public abstract class StorageServiceBase<SOBJ_TYPE extends SObject>
implements IStorageService {
    protected static Logger logger = L.get(StorageServiceBase.class);
    public static final String CONF_GET_NO_GET = "storage.get.noGet";
    public static final String CONF_GET_META_ONLY = "storage.get.MetaOnly";
    public static final String CONF_STATIC_WEB_ENDPOINT = "storage.staticWebEndpoint";
    public static final String CONF_STORE_SUFFIX = "storage.storeSuffix";
    public static final String CONF_KEY_NAME_PROVIDER = "storage.keyNameProvider";
    private String staticWebEndpoint = null;
    private boolean staticWebEndpointIsAbsolute = false;
    private boolean loadMetaOnly = false;
    private boolean noGet = false;
    private boolean storeSuffix = true;
    private KeyNameProvider keyNameProvider = KeyNameProvider.DEF_PROVIDER;
    private Class<SOBJ_TYPE> sobjType;
    private String id;
    protected KeyGenerator keygen;
    protected String contextPath;
    protected Map<String, String> conf = C.newMap((Object[])new Object[0]);
    protected Map<String, IStorageService> subFolders = C.newMap((Object[])new Object[0]);

    public StorageServiceBase(Map<String, String> conf, Class<SOBJ_TYPE> sobjType) {
        this.sobjType = (Class)$.notNull(sobjType);
        this.configure(conf);
    }

    protected void configure(Map<String, String> conf) {
        this.configure(conf, "");
    }

    protected void configure(Map<String, String> conf, String prefix) {
        String s;
        if (!prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        this.id = this.val(conf, "storage.id", prefix);
        if (S.blank((String)this.id)) {
            this.id = "default";
        }
        this.contextPath = S.blank((String)(s = this.val(conf, "storage.context", prefix))) ? "" : StorageServiceBase.canonicalContextPath(s);
        this.staticWebEndpoint = this.val(conf, CONF_STATIC_WEB_ENDPOINT, prefix);
        if (null != this.staticWebEndpoint) {
            if (this.staticWebEndpoint.endsWith("/")) {
                this.staticWebEndpoint = this.staticWebEndpoint.substring(0, this.staticWebEndpoint.length() - 1);
            }
            boolean bl = this.staticWebEndpointIsAbsolute = this.staticWebEndpoint.startsWith("http") || this.staticWebEndpoint.startsWith("//");
            if (!this.staticWebEndpointIsAbsolute && this.staticWebEndpoint.startsWith("/")) {
                this.staticWebEndpoint = this.staticWebEndpoint.substring(1);
            }
        }
        this.loadMetaOnly = Boolean.parseBoolean(S.blank((String)(s = this.val(conf, CONF_GET_META_ONLY, prefix))) ? "false" : s);
        s = this.val(conf, CONF_GET_NO_GET, prefix);
        this.noGet = Boolean.parseBoolean(S.blank((String)s) ? "false" : s);
        s = this.val(conf, CONF_STORE_SUFFIX, prefix);
        this.storeSuffix = Boolean.parseBoolean(S.blank((String)s) ? "true" : s);
        s = this.val(conf, CONF_KEY_NAME_PROVIDER, prefix);
        if (S.notBlank((String)s)) {
            this.keyNameProvider = (KeyNameProvider)$.newInstance((String)s);
        }
        KeyGenerator keyGenerator = this.keygen = S.blank((String)(s = this.val(conf, "storage.keygen", prefix))) ? KeyGenerator.Predefined.BY_DATE : KeyGenerator.Predefined.valueOfIgnoreCase(s);
        if (null == this.keygen) {
            this.keygen = (KeyGenerator)$.newInstance((String)s);
        }
        this.conf.putAll(conf);
    }

    public void setKeyNameProvider(KeyNameProvider keyNameProvider) {
        this.keyNameProvider = (KeyNameProvider)$.notNull((Object)keyNameProvider);
    }

    public void setKeyGenerator(KeyGenerator keygen) {
        this.keygen = (KeyGenerator)$.notNull((Object)keygen);
    }

    private String val(Map<String, String> conf, String key, String prefix) {
        String val = conf.get(key);
        if (S.blank((String)val)) {
            if (key.startsWith("storage.")) {
                key = FastStr.of((String)key).insert(8, prefix).toString();
            }
            val = conf.get(key);
        }
        return val;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String contextPath() {
        return this.getContextPath();
    }

    @Override
    public String getKey(String keyName) {
        return this.keygen.getKey(keyName, this.keyNameProvider);
    }

    @Override
    public String getKey() {
        return this.keygen.getKey(null, this.keyNameProvider);
    }

    @Override
    public ISObject forceGet(String key) {
        return this.getFull(key);
    }

    @Override
    public ISObject getLazy(String key, Map<String, String> attrs) {
        SObject sobj = SObject.lazyLoad(key, this);
        sobj.setAttributes(attrs);
        return sobj;
    }

    @Override
    public String getContextPath() {
        return this.contextPath;
    }

    @Override
    public String getStaticWebEndpoint() {
        return this.staticWebEndpoint;
    }

    static String canonicalContextPath(String path) {
        if (!(path = path.trim()).startsWith("/")) {
            path = "/" + path;
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ("/".equals(path) || "".equals(path)) {
            path = "";
        }
        return path.intern();
    }

    protected String keyWithContextPath(String key) {
        if ("".equals(this.contextPath)) {
            return key;
        }
        StringBuilder sb = new StringBuilder(this.contextPath);
        if (!key.startsWith("/")) {
            sb.append("/");
        }
        sb.append(key);
        return sb.toString();
    }

    @Override
    public synchronized IStorageService subFolder(String path) {
        IStorageService ss = this.subFolders.get(path);
        if (null == ss) {
            ss = this.createSubFolder(path);
            this.subFolders.put(path, ss);
        }
        return ss;
    }

    @Override
    public final ISObject get(String key) {
        if (this.noGet) {
            return SObject.getDumpObject(key);
        }
        if (this.loadMetaOnly) {
            return SObject.getDumpObject(key, this.getMeta(key));
        }
        return this.getFull(key);
    }

    @Override
    public final ISObject getFull(String key) {
        ISObject sobj = this.newSObject(key);
        this.setDefAttributes(sobj);
        return sobj;
    }

    @Override
    public ISObject loadContent(ISObject sobj) {
        return this.getFull(sobj.getKey());
    }

    @Override
    public ISObject put(String key, ISObject stuff) {
        long len;
        String suffix;
        String originalFilename;
        String processedKey = key;
        if (this.storeSuffix && null != (originalFilename = stuff.getAttribute("filename")) && S.notBlank((String)(suffix = S.afterLast((String)originalFilename, (String)"."))) && !key.endsWith(suffix = S.concat((String)".", (String)suffix))) {
            processedKey = S.concat((String)key, (String)suffix);
        }
        if (S.eq((String)key, (String)stuff.getKey()) || S.eq((String)processedKey, (String)stuff.getKey()) && this.isManagedObject(stuff)) {
            return stuff;
        }
        Map<String, String> attrs = stuff.getAttributes();
        this.removeRuntimeAttributes(attrs);
        if (!(stuff instanceof SObject.InputStreamSObject) && 0L < (len = stuff.getLength())) {
            attrs.put("length", S.string((Object)len));
        }
        this.doPut(this.keyWithContextPath(processedKey), stuff, attrs);
        return this.getFull(processedKey);
    }

    private void removeRuntimeAttributes(Map<String, String> attrs) {
        attrs.remove("ss_id");
        attrs.remove("url");
        attrs.remove("ss_ctx");
    }

    @Override
    public boolean isManaged(ISObject sobj) {
        return S.eq((String)sobj.getAttribute("ss_id"), (String)this.id()) && S.eq((String)sobj.getAttribute("ss_ctx"), (String)this.contextPath());
    }

    @Override
    public String getUrl(String key) {
        if (null == this.staticWebEndpoint) {
            return null;
        }
        if (this.staticWebEndpointIsAbsolute) {
            return this.staticWebEndpoint + "/" + key;
        }
        return "/" + this.staticWebEndpoint + "/" + key;
    }

    protected final IStorageService createSubFolder(String path) {
        StorageServiceBase subFolder = this.newService(this.conf);
        subFolder.keygen = this.keygen;
        subFolder.contextPath = this.keyWithContextPath(path);
        if (S.notBlank((String)this.staticWebEndpoint)) {
            subFolder.staticWebEndpoint = this.staticWebEndpoint + "/" + path;
        }
        return subFolder;
    }

    protected Map<String, String> getMeta(String key) {
        return this.getMeta(key, false);
    }

    protected Map<String, String> getMeta(String key, boolean force) {
        if (this.noGet && !force) {
            return C.map((Object[])new Object[0]);
        }
        Map<String, String> map = this.doGetMeta(this.keyWithContextPath(key));
        this.setDefAttributes(key, map);
        return map;
    }

    @Override
    public final void remove(String key) {
        this.doRemove(this.keyWithContextPath(key));
    }

    final InputStream getInputStream(String key) {
        return this.doGetInputStream(this.keyWithContextPath(key));
    }

    protected final String getConfValue(Map<String, String> conf, String key, String def) {
        String val = conf.get(key);
        return null == val ? def : val;
    }

    private void setDefAttributes(ISObject sobj) {
        C.Map map = C.newMap((Object[])new Object[0]);
        this.setDefAttributes(sobj.getKey(), (Map<String, String>)map);
        sobj.setAttributes((Map<String, String>)map);
    }

    private void setDefAttributes(String key, Map<String, String> map) {
        map.put("ss_id", this.id());
        map.put("ss_ctx", this.contextPath());
        if (null != this.staticWebEndpoint) {
            map.put("url", this.getUrl(key));
        }
    }

    private boolean isManagedObject(ISObject sobj) {
        return this.serviceMatches(sobj) && this.typeMatches(sobj);
    }

    private boolean typeMatches(ISObject sobj) {
        return this.sobjType.isAssignableFrom(sobj.getClass());
    }

    private boolean serviceMatches(ISObject sobj) {
        return this.serviceIdMatches(sobj) && this.serviceContextPathMatches(sobj);
    }

    private boolean serviceIdMatches(ISObject sobj) {
        return S.eq((String)this.id(), (String)sobj.getAttribute("ss_id"));
    }

    private boolean serviceContextPathMatches(ISObject sobj) {
        return S.eq((String)this.contextPath(), (String)S.string((Object)sobj.getAttribute("ss_ctx")));
    }

    protected abstract void doRemove(String var1);

    protected abstract Map<String, String> doGetMeta(String var1);

    protected abstract InputStream doGetInputStream(String var1);

    protected abstract void doPut(String var1, ISObject var2, Map<String, String> var3);

    protected abstract ISObject newSObject(String var1);

    protected abstract StorageServiceBase newService(Map<String, String> var1);
}

