/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.storage.spring;

import java.io.IOException;
import java.util.Map;
import org.osgl.storage.IStorageService;
import org.osgl.storage.KeyGenerator;
import org.osgl.storage.impl.FileSystemService;
import org.osgl.storage.spring.StorageServiceConfigurer;
import org.osgl.storage.spring.StorageServiceConfigurerBase;
import org.osgl.util.C;
import org.osgl.util.E;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component
public class FileSystemServiceConfigurer
extends StorageServiceConfigurerBase
implements StorageServiceConfigurer {
    private String homeDir;
    private String homeUrl;

    public void setHomeDir(Resource homeDir) throws IOException {
        E.NPE((Object)homeDir);
        this.homeDir = homeDir.getFile().getAbsolutePath();
    }

    public void setHomeUrl(String homeUrl) {
        E.NPE((Object)homeUrl);
        this.homeUrl = homeUrl;
    }

    @Override
    public IStorageService getStorageService() {
        Map conf = C.map((Object[])new Object[]{"storage.fs.home.dir", this.homeDir, "storage.fs.home.url", this.homeUrl});
        FileSystemService ss = new FileSystemService(conf);
        KeyGenerator keyGenerator = this.getKeyGenerator();
        if (null != keyGenerator) {
            ss.setKeyGenerator(keyGenerator);
        }
        return ss;
    }
}

