/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nexus;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.hc.client5.http.HttpResponseException;
import org.apache.hc.client5.http.impl.classic.AbstractHttpClientResponseHandler;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.message.BasicHeader;
import org.jetbrains.annotations.Nullable;
import org.owasp.dependencycheck.data.nexus.MavenArtifact;
import org.owasp.dependencycheck.data.nexus.NexusSearch;
import org.owasp.dependencycheck.utils.DownloadFailedException;
import org.owasp.dependencycheck.utils.Downloader;
import org.owasp.dependencycheck.utils.ResourceNotFoundException;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.TooManyRequestsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class NexusV3Search
implements NexusSearch {
    private final Set<String> acceptedClassifiers = new HashSet<String>();
    private final URL rootURL;
    private final boolean useProxy;
    private final Settings settings;
    private static final Logger LOGGER = LoggerFactory.getLogger(NexusV3Search.class);

    public NexusV3Search(Settings settings, boolean useProxy) throws MalformedURLException {
        this.settings = settings;
        this.useProxy = useProxy;
        this.acceptedClassifiers.add(null);
        String searchUrl = settings.getString("analyzer.nexus.url");
        LOGGER.debug("Nexus Search URL: {}", (Object)searchUrl);
        this.rootURL = new URL(searchUrl);
    }

    @Override
    public MavenArtifact searchSha1(String sha1) throws IOException {
        if (null == sha1 || !sha1.matches("^[0-9A-Fa-f]{40}$")) {
            throw new IllegalArgumentException("Invalid SHA1 format");
        }
        ArrayList<MavenArtifact> collectedMatchingArtifacts = new ArrayList<MavenArtifact>(1);
        try (CloseableHttpClient client = Downloader.getInstance().getHttpClient(this.useProxy);){
            String continuationToken = this.retrievePageAndAddMatchingArtifact(client, collectedMatchingArtifacts, sha1, null);
            while (continuationToken != null && collectedMatchingArtifacts.isEmpty()) {
                continuationToken = this.retrievePageAndAddMatchingArtifact(client, collectedMatchingArtifacts, sha1, continuationToken);
            }
        }
        if (collectedMatchingArtifacts.isEmpty()) {
            throw new FileNotFoundException("Artifact not found in Nexus");
        }
        return (MavenArtifact)collectedMatchingArtifacts.get(0);
    }

    private String retrievePageAndAddMatchingArtifact(CloseableHttpClient client, List<MavenArtifact> collectedMatchingArtifacts, String sha1, @Nullable String continuationToken) throws IOException {
        LOGGER.debug("Search with continuation token {}", (Object)continuationToken);
        URL url = continuationToken == null ? new URL(this.rootURL, String.format("v1/search/?sha1=%s", sha1.toLowerCase())) : new URL(this.rootURL, String.format("v1/search/?sha1=%s&continuationToken=%s", sha1.toLowerCase(), continuationToken));
        LOGGER.debug("Searching Nexus url {}", (Object)url);
        NexusV3SearchResponseHandler handler = new NexusV3SearchResponseHandler(collectedMatchingArtifacts, sha1, this.acceptedClassifiers);
        try {
            return (String)Downloader.getInstance().fetchAndHandle(client, url, (HttpClientResponseHandler)handler, List.of(new BasicHeader("Accept", (Object)ContentType.APPLICATION_JSON)));
        }
        catch (DownloadFailedException | ResourceNotFoundException | TooManyRequestsException e) {
            if (LOGGER.isDebugEnabled()) {
                int responseCode = -1;
                String responseMessage = "";
                if (e.getCause() instanceof HttpResponseException) {
                    HttpResponseException cause = (HttpResponseException)e.getCause();
                    responseCode = cause.getStatusCode();
                    responseMessage = cause.getReasonPhrase();
                }
                LOGGER.debug("Could not connect to Nexus received response code: {} {}", (Object)responseCode, (Object)responseMessage);
            }
            throw new IOException("Could not connect to Nexus", e);
        }
    }

    @Override
    public boolean preflightRequest() {
        try {
            URL url = new URL(this.rootURL, "v1/status");
            String response = Downloader.getInstance().fetchContent(url, this.useProxy, StandardCharsets.UTF_8);
            if (response == null || !response.isEmpty()) {
                LOGGER.warn("Expected empty OK response (content-length 0), got {}", response == null ? "null" : Integer.valueOf(response.length()));
                return false;
            }
        }
        catch (IOException | ResourceNotFoundException | TooManyRequestsException e) {
            LOGGER.warn("Pre-flight request to Nexus failed: ", e);
            return false;
        }
        return true;
    }

    private static final class NexusV3SearchResponseHandler
    extends AbstractHttpClientResponseHandler<String> {
        private final List<MavenArtifact> matchingArtifacts;
        private final String sha1;
        private final Set<String> acceptedClassifiers;

        private NexusV3SearchResponseHandler(List<MavenArtifact> matchingArtifacts, String sha1, Set<String> acceptedClassifiers) {
            this.matchingArtifacts = matchingArtifacts;
            this.sha1 = sha1;
            this.acceptedClassifiers = acceptedClassifiers;
        }

        /*
         * Exception decompiling
         */
        @Nullable
        public String handleEntity(HttpEntity entity) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

