/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nvdcve;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.annotation.concurrent.ThreadSafe;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.utils.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DatabaseProperties {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseProperties.class);
    public static final String NVD_API_LAST_MODIFIED = "nvd.api.last.modified";
    public static final String NVD_API_LAST_CHECKED = "nvd.api.last.checked";
    public static final String NVD_CACHE_LAST_CHECKED = "nvd.cache.last.checked";
    public static final String NVD_CACHE_LAST_MODIFIED = "nvd.cache.last.modified";
    public static final String LAST_CPE_UPDATE = "LAST_CPE_UPDATE";
    public static final String VERSION = "version";
    public static final String KEV_LAST_CHECKED = "kev.checked";
    public static final String KEV_VERSION = "kev.version";
    private final Properties properties;
    private final CveDB cveDB;

    DatabaseProperties(CveDB cveDB) {
        this.cveDB = cveDB;
        this.properties = cveDB.getProperties();
    }

    public synchronized boolean isEmpty() {
        return this.properties == null || this.properties.isEmpty();
    }

    public synchronized void save(String key, String value) {
        this.properties.put(key, value);
        this.cveDB.saveProperty(key, value);
    }

    public synchronized String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public synchronized String getProperty(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    public synchronized Properties getProperties() {
        return this.properties;
    }

    public synchronized Map<String, String> getMetaData() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            String key = (String)entry.getKey();
            if (VERSION.equals(key)) continue;
            if (NVD_API_LAST_CHECKED.equals(key)) {
                map.put("NVD API Last Checked", entry.getValue().toString());
                continue;
            }
            if (NVD_API_LAST_MODIFIED.equals(key)) {
                map.put("NVD API Last Modified", entry.getValue().toString());
                continue;
            }
            if (NVD_CACHE_LAST_CHECKED.equals(key)) {
                map.put("NVD Cache Last Checked", entry.getValue().toString());
                continue;
            }
            if (!NVD_CACHE_LAST_MODIFIED.equals(key)) continue;
            map.put("NVD Cache Last Modified", entry.getValue().toString());
        }
        return map;
    }

    public ZonedDateTime getTimestamp(String key) {
        return DatabaseProperties.getTimestamp(this.properties, key);
    }

    public void save(String key, ZonedDateTime timestamp) {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ssX");
        this.save(key, dtf.format(timestamp));
    }

    public static void setTimestamp(Properties properties, String key, ZonedDateTime timestamp) {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ssX");
        properties.put(key, dtf.format(timestamp));
    }

    public static ZonedDateTime getTimestamp(Properties properties, String key) {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ssX");
        String val = properties.getProperty(key);
        if (val != null) {
            String value = properties.getProperty(key);
            return ZonedDateTime.parse(value, dtf);
        }
        return null;
    }

    public static ZonedDateTime getIsoTimestamp(Properties properties, String key) {
        DateTimeFormatter dtf = DateTimeFormatter.ISO_DATE_TIME;
        String val = properties.getProperty(key);
        if (val != null) {
            String value = properties.getProperty(key);
            return ZonedDateTime.parse(value, dtf);
        }
        return null;
    }

    public long getPropertyInSeconds(String key) {
        String value = this.getProperty(key, "0");
        return DateUtil.getEpochValueInSeconds(value);
    }
}

