/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.xml.assembly;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.owasp.dependencycheck.utils.FileUtils;
import org.owasp.dependencycheck.utils.XmlUtils;
import org.owasp.dependencycheck.xml.assembly.AssemblyData;
import org.owasp.dependencycheck.xml.assembly.GrokErrorHandler;
import org.owasp.dependencycheck.xml.assembly.GrokHandler;
import org.owasp.dependencycheck.xml.assembly.GrokParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

@ThreadSafe
public class GrokParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(GrokParser.class);
    public static final String GROK_SCHEMA = "schema/grok-assembly.1.0.xsd";

    @SuppressFBWarnings(justification="try with resources will clean up the input stream", value={"OBL_UNSATISFIED_OBLIGATION"})
    public AssemblyData parse(File file) throws GrokParseException {
        AssemblyData assemblyData;
        FileInputStream fis = new FileInputStream(file);
        try {
            assemblyData = this.parse(fis);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                LOGGER.debug("", (Throwable)ex);
                throw new GrokParseException(ex);
            }
        }
        fis.close();
        return assemblyData;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public AssemblyData parse(InputStream inputStream) throws GrokParseException {
        try (InputStream schema = FileUtils.getResourceAsStream((String)GROK_SCHEMA);){
            AssemblyData assemblyData;
            GrokHandler handler = new GrokHandler();
            SAXParser saxParser = XmlUtils.buildSecureSaxParser((InputStream[])new InputStream[]{schema});
            XMLReader xmlReader = saxParser.getXMLReader();
            xmlReader.setErrorHandler(new GrokErrorHandler());
            xmlReader.setContentHandler(handler);
            try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                InputSource in = new InputSource(reader);
                xmlReader.parse(in);
                assemblyData = handler.getAssemblyData();
            }
            return assemblyData;
        }
        catch (IOException | ParserConfigurationException ex) {
            LOGGER.debug("", (Throwable)ex);
            throw new GrokParseException(ex);
        }
        catch (SAXException ex) {
            if (ex.getMessage().contains("Cannot find the declaration of element 'assembly'.")) {
                throw new GrokParseException("Malformed grok xml?", ex);
            }
            LOGGER.debug("", (Throwable)ex);
            throw new GrokParseException(ex);
        }
    }
}

