/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.lucene;

import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

@NotThreadSafe
public final class TokenPairConcatenatingFilter
extends TokenFilter {
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private String previousWord = null;
    private boolean addSingleTerm = true;

    public TokenPairConcatenatingFilter(TokenStream stream) {
        super(stream);
    }

    public boolean incrementToken() throws IOException {
        if (this.addSingleTerm && this.previousWord != null) {
            this.addSingleTerm = false;
            this.clearAttributes();
            this.termAtt.append(this.previousWord);
            return true;
        }
        if (this.input.incrementToken()) {
            String word = new String(this.termAtt.buffer(), 0, this.termAtt.length());
            if (this.addSingleTerm) {
                this.clearAttributes();
                this.termAtt.append(word);
                this.previousWord = word;
                this.addSingleTerm = false;
            } else {
                this.clearAttributes();
                this.termAtt.append(this.previousWord).append(word);
                this.previousWord = word;
                this.addSingleTerm = true;
            }
            return true;
        }
        return false;
    }

    public void end() throws IOException {
        super.end();
        this.previousWord = null;
        this.addSingleTerm = true;
    }

    public void reset() throws IOException {
        super.reset();
        this.previousWord = null;
        this.addSingleTerm = true;
    }

    public int hashCode() {
        return new HashCodeBuilder(13, 27).appendSuper(super.hashCode()).append(this.addSingleTerm).append((Object)this.previousWord).append((Object)this.termAtt).build();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        TokenPairConcatenatingFilter rhs = (TokenPairConcatenatingFilter)((Object)obj);
        return new EqualsBuilder().appendSuper(super.equals(obj)).append(this.addSingleTerm, rhs.addSingleTerm).append((Object)this.previousWord, (Object)rhs.previousWord).append((Object)this.termAtt, (Object)rhs.termAtt).isEquals();
    }
}

