/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nexus;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.owasp.dependencycheck.data.nexus.MavenArtifact;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.URLConnectionFactory;
import org.owasp.dependencycheck.utils.XmlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@ThreadSafe
public class NexusSearch {
    private final URL rootURL;
    private final boolean useProxy;
    private final Settings settings;
    private static final Logger LOGGER = LoggerFactory.getLogger(NexusSearch.class);

    public NexusSearch(Settings settings, boolean useProxy) throws MalformedURLException {
        this.settings = settings;
        this.useProxy = useProxy;
        String searchUrl = settings.getString("analyzer.nexus.url");
        LOGGER.debug("Nexus Search URL: {}", (Object)searchUrl);
        this.rootURL = new URL(searchUrl);
    }

    public MavenArtifact searchSha1(String sha1) throws IOException {
        if (null == sha1 || !sha1.matches("^[0-9A-Fa-f]{40}$")) {
            throw new IllegalArgumentException("Invalid SHA1 format");
        }
        URL url = new URL(this.rootURL, String.format("identify/sha1/%s", sha1.toLowerCase()));
        LOGGER.debug("Searching Nexus url {}", (Object)url);
        URLConnectionFactory factory = new URLConnectionFactory(this.settings);
        HttpURLConnection conn = factory.createHttpURLConnection(url, this.useProxy);
        conn.setDoOutput(true);
        conn.addRequestProperty("Accept", "application/xml");
        conn.connect();
        switch (conn.getResponseCode()) {
            case 200: {
                try {
                    DocumentBuilder builder = XmlUtils.buildSecureDocumentBuilder();
                    Document doc = builder.parse(conn.getInputStream());
                    XPath xpath = XPathFactory.newInstance().newXPath();
                    String groupId = xpath.evaluate("/org.sonatype.nexus.rest.model.NexusArtifact/groupId", doc);
                    String artifactId = xpath.evaluate("/org.sonatype.nexus.rest.model.NexusArtifact/artifactId", doc);
                    String version = xpath.evaluate("/org.sonatype.nexus.rest.model.NexusArtifact/version", doc);
                    String link = xpath.evaluate("/org.sonatype.nexus.rest.model.NexusArtifact/artifactLink", doc);
                    String pomLink = xpath.evaluate("/org.sonatype.nexus.rest.model.NexusArtifact/pomLink", doc);
                    MavenArtifact ma = new MavenArtifact(groupId, artifactId, version);
                    if (link != null && !link.isEmpty()) {
                        ma.setArtifactUrl(link);
                    }
                    if (pomLink != null && !pomLink.isEmpty()) {
                        ma.setPomUrl(pomLink);
                    }
                    return ma;
                }
                catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
                    throw new IOException(e.getMessage(), e);
                }
            }
            case 404: {
                throw new FileNotFoundException("Artifact not found in Nexus");
            }
        }
        LOGGER.debug("Could not connect to Nexus received response code: {} {}", (Object)conn.getResponseCode(), (Object)conn.getResponseMessage());
        throw new IOException("Could not connect to Nexus");
    }

    public boolean preflightRequest() {
        try {
            URL url = new URL(this.rootURL, "status");
            URLConnectionFactory factory = new URLConnectionFactory(this.settings);
            HttpURLConnection conn = factory.createHttpURLConnection(url, this.useProxy);
            conn.addRequestProperty("Accept", "application/xml");
            conn.connect();
            if (conn.getResponseCode() != 200) {
                LOGGER.warn("Expected 200 result from Nexus, got {}", (Object)conn.getResponseCode());
                return false;
            }
            DocumentBuilder builder = XmlUtils.buildSecureDocumentBuilder();
            Document doc = builder.parse(conn.getInputStream());
            if (!"status".equals(doc.getDocumentElement().getNodeName())) {
                LOGGER.warn("Expected root node name of status, got {}", (Object)doc.getDocumentElement().getNodeName());
                return false;
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            return false;
        }
        return true;
    }
}

