/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.ThreadSafe;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.nvdcve.DatabaseProperties;
import org.owasp.dependencycheck.data.update.CachedWebDataSource;
import org.owasp.dependencycheck.data.update.exception.InvalidDataException;
import org.owasp.dependencycheck.data.update.exception.UpdateException;
import org.owasp.dependencycheck.data.update.nvd.DownloadTask;
import org.owasp.dependencycheck.data.update.nvd.NvdCveInfo;
import org.owasp.dependencycheck.data.update.nvd.ProcessTask;
import org.owasp.dependencycheck.data.update.nvd.UpdateableNvdCve;
import org.owasp.dependencycheck.utils.DateUtil;
import org.owasp.dependencycheck.utils.DownloadFailedException;
import org.owasp.dependencycheck.utils.Downloader;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class NvdCveUpdater
implements CachedWebDataSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(NvdCveUpdater.class);
    private static final int PROCESSING_THREAD_POOL_SIZE = Runtime.getRuntime().availableProcessors();
    private static final int DOWNLOAD_THREAD_POOL_SIZE = Math.round(1.5f * (float)Runtime.getRuntime().availableProcessors());
    private ExecutorService processingExecutorService = null;
    private ExecutorService downloadExecutorService = null;
    private Settings settings;
    private CveDB cveDb = null;
    private DatabaseProperties dbProperties = null;

    @Override
    public synchronized void update(Engine engine) throws UpdateException {
        this.settings = engine.getSettings();
        this.cveDb = engine.getDatabase();
        if (this.isUpdateConfiguredFalse()) {
            return;
        }
        try {
            this.dbProperties = this.cveDb.getDatabaseProperties();
            if (this.checkUpdate()) {
                this.initializeExecutorServices();
                UpdateableNvdCve updateable = this.getUpdatesNeeded();
                if (updateable.isUpdateNeeded()) {
                    this.performUpdate(updateable);
                }
                this.dbProperties.save("NVD CVE Checked", Long.toString(System.currentTimeMillis()));
            }
        }
        catch (MalformedURLException ex) {
            throw new UpdateException("NVD CVE properties files contain an invalid URL, unable to update the data to use the most current data.", ex);
        }
        catch (DownloadFailedException ex) {
            LOGGER.warn("Unable to download the NVD CVE data; the results may not include the most recent CPE/CVEs from the NVD.");
            if (this.settings.getString("proxy.server") == null) {
                LOGGER.info("If you are behind a proxy you may need to configure dependency-check to use the proxy.");
            }
            throw new UpdateException("Unable to download the NVD CVE data.", ex);
        }
        catch (DatabaseException ex) {
            throw new UpdateException("Database Exception, unable to update the data to use the most current data.", ex);
        }
        finally {
            this.shutdownExecutorServices();
        }
    }

    private boolean isUpdateConfiguredFalse() {
        try {
            if (!this.settings.getBoolean("updater.nvdcve.enabled", true)) {
                return true;
            }
        }
        catch (InvalidSettingException ex) {
            LOGGER.trace("invalid setting UPDATE_NVDCVE_ENABLED", (Throwable)ex);
        }
        boolean autoUpdate = true;
        try {
            autoUpdate = this.settings.getBoolean("autoupdate");
        }
        catch (InvalidSettingException ex) {
            LOGGER.debug("Invalid setting for auto-update; using true.");
        }
        return !autoUpdate;
    }

    protected void initializeExecutorServices() {
        this.processingExecutorService = Executors.newFixedThreadPool(PROCESSING_THREAD_POOL_SIZE);
        this.downloadExecutorService = Executors.newFixedThreadPool(DOWNLOAD_THREAD_POOL_SIZE);
        LOGGER.debug("#download   threads: {}", (Object)DOWNLOAD_THREAD_POOL_SIZE);
        LOGGER.debug("#processing threads: {}", (Object)PROCESSING_THREAD_POOL_SIZE);
    }

    private void shutdownExecutorServices() {
        if (this.processingExecutorService != null) {
            this.processingExecutorService.shutdownNow();
        }
        if (this.downloadExecutorService != null) {
            this.downloadExecutorService.shutdownNow();
        }
    }

    private boolean checkUpdate() throws UpdateException {
        boolean proceed = true;
        int validForHours = this.settings.getInt("cve.check.validforhours", 0);
        if (this.dataExists() && 0 < validForHours) {
            long msValid = (long)validForHours * 60L * 60L * 1000L;
            long lastChecked = Long.parseLong(this.dbProperties.getProperty("NVD CVE Checked", "0"));
            long now = System.currentTimeMillis();
            boolean bl = proceed = now - lastChecked > msValid;
            if (!proceed) {
                LOGGER.info("Skipping NVD check since last check was within {} hours.", (Object)validForHours);
                LOGGER.debug("Last NVD was at {}, and now {} is within {} ms.", new Object[]{lastChecked, now, msValid});
            }
        }
        return proceed;
    }

    private boolean dataExists() {
        return this.cveDb.dataExists();
    }

    private void performUpdate(UpdateableNvdCve updateable) throws UpdateException {
        Object task;
        int maxUpdates = 0;
        for (Object cve : updateable) {
            if (!((NvdCveInfo)cve).getNeedsUpdate()) continue;
            ++maxUpdates;
        }
        if (maxUpdates <= 0) {
            return;
        }
        if (maxUpdates > 3) {
            LOGGER.info("NVD CVE requires several updates; this could take a couple of minutes.");
        }
        HashSet<Future<Future<ProcessTask>>> downloadFutures = new HashSet<Future<Future<ProcessTask>>>(maxUpdates);
        for (NvdCveInfo cve : updateable) {
            if (!cve.getNeedsUpdate()) continue;
            DownloadTask downloadTask = new DownloadTask(cve, this.processingExecutorService, this.cveDb, this.settings);
            downloadFutures.add(this.downloadExecutorService.submit(downloadTask));
        }
        HashSet<Future> processFutures = new HashSet<Future>(maxUpdates);
        for (Future future : downloadFutures) {
            try {
                task = (Future)future.get();
            }
            catch (InterruptedException ex) {
                LOGGER.debug("Thread was interrupted during download", (Throwable)ex);
                Thread.currentThread().interrupt();
                throw new UpdateException("The download was interrupted", ex);
            }
            catch (ExecutionException ex) {
                LOGGER.debug("Thread was interrupted during download execution", (Throwable)ex);
                throw new UpdateException("The execution of the download was interrupted", ex);
            }
            if (task == null) {
                LOGGER.debug("Thread was interrupted during download");
                throw new UpdateException("The download was interrupted; unable to complete the update");
            }
            processFutures.add((Future)task);
        }
        for (Future future : processFutures) {
            try {
                task = (ProcessTask)future.get();
                if (((ProcessTask)task).getException() == null) continue;
                throw ((ProcessTask)task).getException();
            }
            catch (InterruptedException ex) {
                LOGGER.debug("Thread was interrupted during processing", (Throwable)ex);
                Thread.currentThread().interrupt();
                throw new UpdateException(ex);
            }
            catch (ExecutionException ex) {
                LOGGER.debug("Execution Exception during process", (Throwable)ex);
                throw new UpdateException(ex);
            }
        }
        this.dbProperties.save(updateable.get("Modified"));
        LOGGER.info("Begin database maintenance.");
        this.cveDb.cleanupDatabase();
        LOGGER.info("End database maintenance.");
    }

    protected final UpdateableNvdCve getUpdatesNeeded() throws MalformedURLException, DownloadFailedException, UpdateException {
        UpdateableNvdCve updates;
        block16: {
            LOGGER.info("starting getUpdatesNeeded() ...");
            try {
                updates = this.retrieveCurrentTimestampsFromWeb();
            }
            catch (InvalidDataException ex) {
                String msg = "Unable to retrieve valid timestamp from nvd cve downloads page";
                LOGGER.debug("Unable to retrieve valid timestamp from nvd cve downloads page", (Throwable)ex);
                throw new DownloadFailedException("Unable to retrieve valid timestamp from nvd cve downloads page", (Throwable)ex);
            }
            catch (InvalidSettingException ex) {
                LOGGER.debug("Invalid setting found when retrieving timestamps", (Throwable)ex);
                throw new DownloadFailedException("Invalid settings", (Throwable)ex);
            }
            if (updates == null) {
                throw new DownloadFailedException("Unable to retrieve the timestamps of the currently published NVD CVE data");
            }
            if (this.dbProperties != null && !this.dbProperties.isEmpty()) {
                try {
                    int startYear = this.settings.getInt("cve.startyear", 2002);
                    int endYear = Calendar.getInstance().get(1);
                    boolean needsFullUpdate = false;
                    for (int y = startYear; y <= endYear; ++y) {
                        long val = Long.parseLong(this.dbProperties.getProperty("NVD CVE " + y, "0"));
                        if (val != 0L) continue;
                        needsFullUpdate = true;
                    }
                    long lastUpdated = Long.parseLong(this.dbProperties.getProperty("NVD CVE Modified", "0"));
                    long now = System.currentTimeMillis();
                    int days = this.settings.getInt("cve.url.modified.validfordays", 7);
                    if (!needsFullUpdate && lastUpdated == updates.getTimeStamp("Modified")) {
                        updates.clear();
                        break block16;
                    }
                    if (!needsFullUpdate && DateUtil.withinDateRange(lastUpdated, now, days)) {
                        for (NvdCveInfo entry : updates) {
                            if ("Modified".equals(entry.getId())) {
                                entry.setNeedsUpdate(true);
                                continue;
                            }
                            entry.setNeedsUpdate(false);
                        }
                        break block16;
                    }
                    for (NvdCveInfo entry : updates) {
                        if ("Modified".equals(entry.getId())) {
                            entry.setNeedsUpdate(true);
                            continue;
                        }
                        long currentTimestamp = 0L;
                        try {
                            currentTimestamp = Long.parseLong(this.dbProperties.getProperty("NVD CVE " + entry.getId(), "0"));
                        }
                        catch (NumberFormatException ex) {
                            LOGGER.debug("Error parsing '{}' '{}' from nvdcve.lastupdated", new Object[]{"NVD CVE ", entry.getId(), ex});
                        }
                        if (currentTimestamp != entry.getTimestamp()) continue;
                        entry.setNeedsUpdate(false);
                    }
                }
                catch (NumberFormatException ex) {
                    LOGGER.warn("An invalid schema version or timestamp exists in the data.properties file.");
                    LOGGER.debug("", (Throwable)ex);
                }
            }
        }
        return updates;
    }

    private UpdateableNvdCve retrieveCurrentTimestampsFromWeb() throws MalformedURLException, DownloadFailedException, InvalidDataException, InvalidSettingException {
        int start = this.settings.getInt("cve.startyear");
        int end = Calendar.getInstance().get(1);
        Map<String, Long> lastModifiedDates = this.retrieveLastModifiedDates(start, end);
        UpdateableNvdCve updates = new UpdateableNvdCve();
        String baseUrl20 = this.settings.getString("cve.url-2.0.base");
        String baseUrl12 = this.settings.getString("cve.url-1.2.base");
        for (int i = start; i <= end; ++i) {
            String url = String.format(baseUrl20, i);
            updates.add(Integer.toString(i), url, String.format(baseUrl12, i), lastModifiedDates.get(url), true);
        }
        String url = this.settings.getString("cve.url-2.0.modified");
        updates.add("Modified", url, this.settings.getString("cve.url-1.2.modified"), lastModifiedDates.get(url), false);
        return updates;
    }

    private Map<String, Long> retrieveLastModifiedDates(int startYear, int endYear) throws MalformedURLException, DownloadFailedException {
        HashSet<String> urls = new HashSet<String>();
        String baseUrl20 = this.settings.getString("cve.url-2.0.base");
        for (int i = startYear; i <= endYear; ++i) {
            String url = String.format(baseUrl20, i);
            urls.add(url);
        }
        urls.add(this.settings.getString("cve.url-2.0.modified"));
        HashMap<String, Future<Long>> timestampFutures = new HashMap<String, Future<Long>>();
        for (String url : urls) {
            TimestampRetriever timestampRetriever = new TimestampRetriever(url, this.settings);
            Future<Long> future = this.downloadExecutorService.submit(timestampRetriever);
            timestampFutures.put(url, future);
        }
        HashMap<String, Long> lastModifiedDates = new HashMap<String, Long>();
        for (String url : urls) {
            long timestamp;
            Future timestampFuture = (Future)timestampFutures.get(url);
            try {
                timestamp = (Long)timestampFuture.get(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new DownloadFailedException((Throwable)e);
            }
            catch (ExecutionException | TimeoutException e) {
                throw new DownloadFailedException((Throwable)e);
            }
            lastModifiedDates.put(url, timestamp);
        }
        return lastModifiedDates;
    }

    protected synchronized void setSettings(Settings settings) {
        this.settings = settings;
    }

    private static class TimestampRetriever
    implements Callable<Long> {
        private final Settings settings;
        private final String url;

        TimestampRetriever(String url, Settings settings) {
            this.url = url;
            this.settings = settings;
        }

        @Override
        public Long call() throws Exception {
            LOGGER.debug("Checking for updates from: {}", (Object)this.url);
            try {
                Downloader downloader = new Downloader(this.settings);
                Long l = downloader.getLastModified(new URL(this.url));
                return l;
            }
            finally {
                this.settings.cleanup(false);
            }
        }
    }
}

