/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.concurrent.ThreadSafe;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.data.update.CachedWebDataSource;
import org.owasp.dependencycheck.data.update.exception.UpdateException;
import org.owasp.dependencycheck.utils.Downloader;
import org.owasp.dependencycheck.utils.ResourceNotFoundException;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.TooManyRequestsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class RetireJSDataSource
implements CachedWebDataSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(RetireJSDataSource.class);
    public static final String RETIREJS_UPDATED_ON = "RetireJSUpdatedOn";
    private Settings settings;
    private static final String DEFAULT_JS_URL = "https://raw.githubusercontent.com/Retirejs/retire.js/master/repository/jsrepository.json";

    protected RetireJSDataSource(Settings settings) {
        this.settings = settings;
    }

    public RetireJSDataSource() {
    }

    @Override
    public boolean update(Engine engine) throws UpdateException {
        this.settings = engine.getSettings();
        String url = null;
        try {
            boolean proceed;
            boolean autoupdate = this.settings.getBoolean("autoupdate", true);
            boolean enabled = this.settings.getBoolean("analyzer.retirejs.enabled", true);
            File repoFile = new File(this.settings.getDataDirectory(), "jsrepository.json");
            boolean bl = proceed = enabled && autoupdate && this.shouldUpdagte(repoFile);
            if (proceed) {
                LOGGER.debug("Begin RetireJS Update");
                url = this.settings.getString("analyzer.retirejs.repo.js.url", DEFAULT_JS_URL);
                this.initializeRetireJsRepo(this.settings, new URL(url));
            }
        }
        catch (MalformedURLException ex) {
            throw new UpdateException(String.format("Inavlid URL for RetireJS repository (%s)", url), ex);
        }
        catch (IOException ex) {
            throw new UpdateException("Unable to get the data directory", ex);
        }
        return false;
    }

    protected boolean shouldUpdagte(File repo) throws NumberFormatException {
        boolean proceed = true;
        if (repo != null && repo.isFile()) {
            int validForHours = this.settings.getInt("analyzer.retirejs.repo.validforhours", 0);
            long lastUpdatedOn = repo.lastModified();
            long now = System.currentTimeMillis();
            LOGGER.debug("Last updated: {}", (Object)lastUpdatedOn);
            LOGGER.debug("Now: {}", (Object)now);
            long msValid = (long)validForHours * 60L * 60L * 1000L;
            boolean bl = proceed = now - lastUpdatedOn > msValid;
            if (!proceed) {
                LOGGER.info("Skipping RetireJS update since last update was within {} hours.", (Object)validForHours);
            }
        }
        return proceed;
    }

    private void initializeRetireJsRepo(Settings settings, URL repoUrl) throws UpdateException {
        try {
            File dataDir = settings.getDataDirectory();
            LOGGER.debug("RetireJS Repo URL: {}", (Object)repoUrl.toExternalForm());
            Downloader downloader = new Downloader(settings);
            String filename = repoUrl.getFile().substring(repoUrl.getFile().lastIndexOf("/") + 1);
            File repoFile = new File(dataDir, filename);
            downloader.fetchFile(repoUrl, repoFile);
        }
        catch (IOException | ResourceNotFoundException | TooManyRequestsException ex) {
            throw new UpdateException("Failed to initialize the RetireJS repo", ex);
        }
    }

    @Override
    public boolean purge(Engine engine) {
        boolean result = true;
        try {
            File dataDir = engine.getSettings().getDataDirectory();
            URL repoUrl = new URL(engine.getSettings().getString("analyzer.retirejs.repo.js.url", DEFAULT_JS_URL));
            String filename = repoUrl.getFile().substring(repoUrl.getFile().lastIndexOf("/") + 1);
            File repo = new File(dataDir, filename);
            if (repo.exists()) {
                if (repo.delete()) {
                    LOGGER.info("RetireJS repo removed successfully");
                } else {
                    LOGGER.error("Unable to delete '{}'; please delete the file manually", (Object)repo.getAbsolutePath());
                    result = false;
                }
            }
        }
        catch (IOException ex) {
            LOGGER.error("Unable to delete the RetireJS repo - invalid configuration");
            result = false;
        }
        return result;
    }
}

