/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import com.github.packageurl.PackageURLBuilder;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.concurrent.ThreadSafe;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.apache.commons.io.FileUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Experimental;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.dependency.naming.GenericIdentifier;
import org.owasp.dependencycheck.dependency.naming.PurlIdentifier;
import org.owasp.dependencycheck.utils.Checksum;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
@ThreadSafe
public class SwiftPackageResolvedAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwiftPackageResolvedAnalyzer.class);
    public static final String DEPENDENCY_ECOSYSTEM = "ios";
    private static final String ANALYZER_NAME = "SWIFT Package Resolved Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INFORMATION_COLLECTION;
    public static final String SPM_RESOLVED_FILE_NAME = "Package.resolved";
    private static final FileFilter SPM_FILE_FILTER = FileFilterBuilder.newInstance().addFilenames("Package.resolved").build();

    @Override
    protected FileFilter getFileFilter() {
        return SPM_FILE_FILTER;
    }

    @Override
    protected void prepareFileTypeAnalyzer(Engine engine) {
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.swift.package.resolved.enabled";
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        try {
            engine.removeDependency(dependency);
            this.analyzeSpmResolvedDependencies(dependency, engine);
        }
        catch (IOException ex) {
            throw new AnalysisException("Problem occurred while reading dependency file: " + dependency.getActualFilePath(), ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void analyzeSpmResolvedDependencies(Dependency spmResolved, Engine engine) throws AnalysisException, IOException {
        try (FileInputStream in = FileUtils.openInputStream((File)spmResolved.getActualFile());
             JsonReader resolved = Json.createReader((InputStream)in);){
            JsonObject file = resolved.readObject();
            int fileVersion = file.getInt("version");
            switch (fileVersion) {
                case 1: {
                    this.analyzeSpmResolvedDependenciesV1(spmResolved, engine, file);
                    return;
                }
                case 2: {
                    this.analyzeSpmResolvedDependenciesV2(spmResolved, engine, file);
                    return;
                }
                default: {
                    return;
                }
            }
        }
    }

    private void analyzeSpmResolvedDependenciesV1(Dependency spmResolved, Engine engine, JsonObject resolved) {
        JsonObject object = resolved.getJsonObject("object");
        if (object == null) {
            return;
        }
        JsonArray pins = object.getJsonArray("pins");
        if (pins == null) {
            return;
        }
        pins.forEach(row -> {
            JsonObject pin = (JsonObject)row;
            String name = pin.getString("package");
            String repo = pin.getString("repositoryURL");
            String version = null;
            JsonObject state = pin.getJsonObject("state");
            if (state != null) {
                if (!state.isNull("version")) {
                    version = state.getString("version");
                } else if (!state.isNull("branch")) {
                    version = state.getString("branch");
                }
            }
            Dependency dependency = this.createDependency(spmResolved, SPM_RESOLVED_FILE_NAME, name, version, repo);
            engine.addDependency(dependency);
        });
    }

    private void analyzeSpmResolvedDependenciesV2(Dependency spmResolved, Engine engine, JsonObject resolved) {
        JsonArray pins = resolved.getJsonArray("pins");
        if (pins == null) {
            return;
        }
        pins.forEach(row -> {
            JsonObject pin = (JsonObject)row;
            String name = pin.getString("identity");
            String repo = pin.getString("location");
            String version = null;
            JsonObject state = pin.getJsonObject("state");
            if (state != null) {
                if (state.containsKey((Object)"version") && !state.isNull("version") && !state.getString("version").isEmpty()) {
                    version = state.getString("version");
                } else if (state.containsKey((Object)"branch") && !state.isNull("branch")) {
                    version = state.getString("branch");
                }
            }
            Dependency dependency = this.createDependency(spmResolved, SPM_RESOLVED_FILE_NAME, name, version, repo);
            engine.addDependency(dependency);
        });
    }

    private Dependency createDependency(Dependency parent, String source, String name, String version, String repo) {
        Dependency dependency = new Dependency(parent.getActualFile(), true);
        dependency.setEcosystem(DEPENDENCY_ECOSYSTEM);
        dependency.setName(name);
        dependency.setVersion(version);
        String packagePath = String.format("%s:%s", name, version);
        dependency.setPackagePath(packagePath);
        dependency.setDisplayFileName(packagePath);
        dependency.setSha1sum(Checksum.getSHA1Checksum((String)packagePath));
        dependency.setSha256sum(Checksum.getSHA256Checksum((String)packagePath));
        dependency.setMd5sum(Checksum.getMD5Checksum((String)packagePath));
        dependency.addEvidence(EvidenceType.VENDOR, source, "name", name, Confidence.HIGHEST);
        dependency.addEvidence(EvidenceType.PRODUCT, source, "name", name, Confidence.HIGHEST);
        dependency.addEvidence(EvidenceType.VENDOR, source, "repositoryUrl", repo, Confidence.HIGH);
        dependency.addEvidence(EvidenceType.PRODUCT, source, "repositoryUrl", repo, Confidence.HIGH);
        dependency.addEvidence(EvidenceType.VERSION, source, "version", version, Confidence.HIGHEST);
        try {
            PackageURLBuilder builder = PackageURLBuilder.aPackageURL().withType("swift").withName(dependency.getName());
            if (dependency.getVersion() != null) {
                builder.withVersion(dependency.getVersion());
            }
            PackageURL purl = builder.build();
            dependency.addSoftwareIdentifier(new PurlIdentifier(purl, Confidence.HIGHEST));
        }
        catch (MalformedPackageURLException ex) {
            LOGGER.debug("Unable to build package url for swift dependency", (Throwable)ex);
            GenericIdentifier id = dependency.getVersion() != null ? new GenericIdentifier("swift:" + dependency.getName() + "@" + dependency.getVersion(), Confidence.HIGHEST) : new GenericIdentifier("swift:" + dependency.getName(), Confidence.HIGHEST);
            dependency.addSoftwareIdentifier(id);
        }
        return dependency;
    }
}

