/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.dependency;

import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Evidence;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.utils.Filter;

@ThreadSafe
class EvidenceCollection
implements Serializable {
    private static final long serialVersionUID = 867580958972090027L;
    private final Set<Evidence> vendors = new TreeSet<Evidence>();
    private final Set<String> vendorWeightings = new TreeSet<String>();
    private final Set<Evidence> products = new TreeSet<Evidence>();
    private final Set<String> productWeightings = new TreeSet<String>();
    private final Set<Evidence> versions = new TreeSet<Evidence>();
    private static final Filter<Evidence> HIGHEST_CONFIDENCE = new Filter<Evidence>(){

        @Override
        public boolean passes(Evidence evidence) {
            return evidence.getConfidence() == Confidence.HIGHEST;
        }
    };
    private static final Filter<Evidence> HIGH_CONFIDENCE = new Filter<Evidence>(){

        @Override
        public boolean passes(Evidence evidence) {
            return evidence.getConfidence() == Confidence.HIGH;
        }
    };
    private static final Filter<Evidence> MEDIUM_CONFIDENCE = new Filter<Evidence>(){

        @Override
        public boolean passes(Evidence evidence) {
            return evidence.getConfidence() == Confidence.MEDIUM;
        }
    };
    private static final Filter<Evidence> LOW_CONFIDENCE = new Filter<Evidence>(){

        @Override
        public boolean passes(Evidence evidence) {
            return evidence.getConfidence() == Confidence.LOW;
        }
    };

    EvidenceCollection() {
    }

    public synchronized Iterable<Evidence> getIterator(EvidenceType type, Confidence confidence) {
        if (null != confidence && null != type) {
            Set<Evidence> list;
            switch (type) {
                case VENDOR: {
                    list = Collections.unmodifiableSet(new TreeSet<Evidence>(this.vendors));
                    break;
                }
                case PRODUCT: {
                    list = Collections.unmodifiableSet(new TreeSet<Evidence>(this.products));
                    break;
                }
                case VERSION: {
                    list = Collections.unmodifiableSet(new TreeSet<Evidence>(this.versions));
                    break;
                }
                default: {
                    return null;
                }
            }
            switch (confidence) {
                case HIGHEST: {
                    return HIGHEST_CONFIDENCE.filter(list);
                }
                case HIGH: {
                    return HIGH_CONFIDENCE.filter(list);
                }
                case MEDIUM: {
                    return MEDIUM_CONFIDENCE.filter(list);
                }
            }
            return LOW_CONFIDENCE.filter(list);
        }
        return null;
    }

    public synchronized void addEvidence(EvidenceType type, Evidence e) {
        if (null != type) {
            switch (type) {
                case VENDOR: {
                    this.vendors.add(e);
                    break;
                }
                case PRODUCT: {
                    this.products.add(e);
                    break;
                }
                case VERSION: {
                    this.versions.add(e);
                    break;
                }
            }
        }
    }

    public synchronized void removeEvidence(EvidenceType type, Evidence e) {
        if (null != type) {
            switch (type) {
                case VENDOR: {
                    this.vendors.remove(e);
                    break;
                }
                case PRODUCT: {
                    this.products.remove(e);
                    break;
                }
                case VERSION: {
                    this.versions.remove(e);
                    break;
                }
            }
        }
    }

    public void addEvidence(EvidenceType type, String source, String name, String value, Confidence confidence) {
        Evidence e = new Evidence(source, name, value, confidence);
        this.addEvidence(type, e);
    }

    public synchronized void addVendorWeighting(String str) {
        this.vendorWeightings.add(str.toLowerCase());
    }

    public synchronized void addProductWeighting(String str) {
        this.productWeightings.add(str.toLowerCase());
    }

    public synchronized Set<String> getVendorWeightings() {
        return Collections.unmodifiableSet(new TreeSet<String>(this.vendorWeightings));
    }

    public synchronized Set<String> getProductWeightings() {
        return Collections.unmodifiableSet(new TreeSet<String>(this.productWeightings));
    }

    public synchronized Set<Evidence> getEvidence(EvidenceType type) {
        if (null != type) {
            switch (type) {
                case VENDOR: {
                    return Collections.unmodifiableSet(new TreeSet<Evidence>(this.vendors));
                }
                case PRODUCT: {
                    return Collections.unmodifiableSet(new TreeSet<Evidence>(this.products));
                }
                case VERSION: {
                    return Collections.unmodifiableSet(new TreeSet<Evidence>(this.versions));
                }
            }
        }
        return null;
    }

    public synchronized Set<Evidence> getEvidence() {
        TreeSet<Evidence> e = new TreeSet<Evidence>(this.vendors);
        e.addAll(this.products);
        e.addAll(this.versions);
        return Collections.unmodifiableSet(e);
    }

    public synchronized boolean contains(EvidenceType type, Evidence e) {
        if (null != type) {
            switch (type) {
                case VENDOR: {
                    return this.vendors.contains(e);
                }
                case PRODUCT: {
                    return this.products.contains(e);
                }
                case VERSION: {
                    return this.versions.contains(e);
                }
            }
        }
        return false;
    }

    public synchronized boolean contains(EvidenceType type, Confidence confidence) {
        Set<Evidence> col;
        if (null == type) {
            return false;
        }
        switch (type) {
            case VENDOR: {
                col = this.vendors;
                break;
            }
            case PRODUCT: {
                col = this.products;
                break;
            }
            case VERSION: {
                col = this.versions;
                break;
            }
            default: {
                return false;
            }
        }
        for (Evidence e : col) {
            if (!e.getConfidence().equals((Object)confidence)) continue;
            return true;
        }
        return false;
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{vendors: [");
        for (Evidence e : this.vendors) {
            sb.append("'").append(e.getValue()).append("', ");
        }
        sb.append("],/nproducts: [");
        for (Evidence e : this.products) {
            sb.append("'").append(e.getValue()).append("', ");
        }
        sb.append("],/nversions: [");
        for (Evidence e : this.versions) {
            sb.append("'").append(e.getValue()).append("', ");
        }
        sb.append("]");
        return sb.toString();
    }

    public synchronized int size() {
        return this.vendors.size() + this.products.size() + this.versions.size();
    }

    public int hashCode() {
        return new HashCodeBuilder(13, 43).append(this.vendors).append(this.vendorWeightings).append(this.products).append(this.productWeightings).append(this.versions).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof EvidenceCollection)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        EvidenceCollection other = (EvidenceCollection)obj;
        return new EqualsBuilder().append(this.vendors, other.vendors).append(this.vendorWeightings, other.vendorWeightings).append(this.products, other.products).append(this.productWeightings, other.productWeightings).append(this.versions, other.versions).isEquals();
    }
}

