/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.SSLHandshakeException;
import org.apache.hc.client5.http.HttpResponseException;
import org.apache.hc.client5.http.auth.AuthCache;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.CredentialsStore;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.impl.auth.BasicAuthCache;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.impl.auth.SystemDefaultCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.BasicHttpClientResponseHandler;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.BasicHttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.jetbrains.annotations.NotNull;
import org.owasp.dependencycheck.utils.DownloadFailedException;
import org.owasp.dependencycheck.utils.ExplicitCharsetToStringResponseHandler;
import org.owasp.dependencycheck.utils.HC5CredentialHelper;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.ResourceNotFoundException;
import org.owasp.dependencycheck.utils.SaveToFileResponseHandler;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.TooManyRequestsException;
import org.owasp.dependencycheck.utils.URLConnectionFailureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Downloader {
    private final HttpClientBuilder httpClientBuilder;
    private final HttpClientBuilder httpClientBuilderExplicitNoproxy;
    private final AuthCache authCache = new BasicAuthCache();
    private final SystemDefaultCredentialsProvider credentialsProvider = new SystemDefaultCredentialsProvider();
    private Settings settings;
    private static final Logger LOGGER = LoggerFactory.getLogger(Downloader.class);
    private static final Downloader INSTANCE = new Downloader();
    private Credentials proxyCreds = null;
    private BasicScheme proxyPreEmptAuth = null;
    private AuthScope proxyAuthScope = null;
    private HttpHost proxyHttpHost = null;

    private Downloader() {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        this.httpClientBuilder = HttpClientBuilder.create().useSystemProperties().setConnectionManager((HttpClientConnectionManager)connectionManager).setConnectionManagerShared(true);
        this.httpClientBuilderExplicitNoproxy = HttpClientBuilder.create().useSystemProperties().setConnectionManager((HttpClientConnectionManager)connectionManager).setConnectionManagerShared(true).setProxySelector(new ProxySelector(){

            @Override
            public List<Proxy> select(URI uri) {
                return Collections.singletonList(Proxy.NO_PROXY);
            }

            @Override
            public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
            }
        });
    }

    public static Downloader getInstance() {
        return INSTANCE;
    }

    public void configure(Settings settings) throws InvalidSettingException {
        this.settings = settings;
        if (settings.getString("proxy.server") != null) {
            String proxyHost = settings.getString("proxy.server");
            int proxyPort = settings.getInt("proxy.port", -1);
            String nonProxyHosts = settings.getString("proxy.nonproxyhosts");
            if (nonProxyHosts != null && !nonProxyHosts.isEmpty()) {
                SelectiveProxySelector selector = new SelectiveProxySelector(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort)), nonProxyHosts.split("\\|"));
                this.httpClientBuilder.setProxySelector((ProxySelector)selector);
            } else {
                this.httpClientBuilder.setProxy(new HttpHost(proxyHost, proxyPort));
            }
            if (settings.getString("proxy.username") != null) {
                String proxyuser = settings.getString("proxy.username");
                char[] proxypass = settings.getString("proxy.password").toCharArray();
                this.proxyHttpHost = new HttpHost(null, proxyHost, proxyPort);
                this.proxyCreds = new UsernamePasswordCredentials(proxyuser, proxypass);
                this.proxyAuthScope = new AuthScope(this.proxyHttpHost);
                this.proxyPreEmptAuth = new BasicScheme();
                this.proxyPreEmptAuth.initPreemptive(this.proxyCreds);
                this.tryConfigureProxyCredentials((CredentialsStore)this.credentialsProvider, this.authCache);
            }
        }
        this.tryAddRetireJSCredentials();
        this.tryAddHostedSuppressionCredentials();
        this.tryAddKEVCredentials();
        this.tryAddNexusAnalyzerCredentials();
        this.tryAddArtifactoryCredentials();
        this.tryAddCentralAnalyzerCredentials();
        this.tryAddCentralContentCredentials();
        this.tryAddNVDApiDatafeed();
        this.httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)this.credentialsProvider);
        this.httpClientBuilderExplicitNoproxy.setDefaultCredentialsProvider((CredentialsProvider)this.credentialsProvider);
    }

    private void tryAddRetireJSCredentials() throws InvalidSettingException {
        if (!this.settings.getString("analyzer.retirejs.repo.js.url", "").isBlank()) {
            this.configureCredentials("analyzer.retirejs.repo.js.url", "RetireJS repo.js", "analyzer.retirejs.repo.js.username", "analyzer.retirejs.repo.js.password", "analyzer.retirejs.repo.js.bearertoken");
        }
    }

    private void tryAddHostedSuppressionCredentials() throws InvalidSettingException {
        if (!this.settings.getString("hosted.suppressions.url", "").isBlank()) {
            this.configureCredentials("hosted.suppressions.url", "Hosted suppressions", "hosted.suppressions.user", "hosted.suppressions.password", "hosted.suppressions.bearertoken");
        }
    }

    private void tryAddKEVCredentials() throws InvalidSettingException {
        if (!this.settings.getString("kev.url", "").isBlank()) {
            this.configureCredentials("kev.url", "Known Exploited Vulnerabilities", "kev.user", "kev.password", "kev.bearertoken");
        }
    }

    private void tryAddNexusAnalyzerCredentials() throws InvalidSettingException {
        if (!this.settings.getString("analyzer.nexus.url", "").isBlank()) {
            this.configureCredentials("analyzer.nexus.url", "Nexus Analyzer", "analyzer.nexus.username", "analyzer.nexus.password", null);
        }
    }

    private void tryAddCentralAnalyzerCredentials() throws InvalidSettingException {
        if (!this.settings.getString("analyzer.central.url", "").isBlank()) {
            this.configureCredentials("analyzer.central.url", "Central Analyzer", "analyzer.central.username", "analyzer.central.password", "analyzer.central.bearertoken");
        }
    }

    private void tryAddArtifactoryCredentials() throws InvalidSettingException {
        if (!this.settings.getString("analyzer.artifactory.url", "").isBlank()) {
            this.configureCredentials("analyzer.artifactory.url", "Artifactory Analyzer", "analyzer.artifactory.api.username", "analyzer.artifactory.api.token", "analyzer.artifactory.bearer.token");
        }
    }

    private void tryAddCentralContentCredentials() throws InvalidSettingException {
        if (!this.settings.getString("central.content.url", "").isBlank()) {
            this.configureCredentials("central.content.url", "Central Content", "central.content.username", "central.content.password", "central.content.bearertoken");
        }
    }

    private void tryAddNVDApiDatafeed() throws InvalidSettingException {
        if (!this.settings.getString("nvd.api.datafeed.url", "").isBlank()) {
            this.configureCredentials("nvd.api.datafeed.url", "NVD API Datafeed", "nvd.api.datafeed.user", "nvd.api.datafeed.password", "nvd.api.datafeed.bearertoken");
        }
    }

    private void configureCredentials(String urlKey, String scopeDescription, String userKey, String passwordKey, String tokenKey) throws InvalidSettingException {
        URL theURL;
        try {
            theURL = new URL(this.settings.getString(urlKey, ""));
        }
        catch (MalformedURLException e) {
            throw new InvalidSettingException(scopeDescription + " URL must be a valid URL (was: " + this.settings.getString(urlKey, "") + ")", e);
        }
        this.configureCredentials(theURL, scopeDescription, userKey, passwordKey, tokenKey, (CredentialsStore)this.credentialsProvider, this.authCache);
    }

    private void configureCredentials(URL theURL, String scopeDescription, String userKey, String passwordKey, String tokenKey, CredentialsStore theCredentialsStore, AuthCache theAuthCache) throws InvalidSettingException {
        String theToken;
        String theUser = this.settings.getString(userKey);
        String thePass = this.settings.getString(passwordKey);
        String string = theToken = tokenKey != null ? this.settings.getString(tokenKey) : null;
        if (theUser == null && thePass == null && theToken == null) {
            return;
        }
        String theProtocol = theURL.getProtocol();
        if ("file".equals(theProtocol)) {
            return;
        }
        if ("http".equals(theProtocol) && theUser != null && thePass != null) {
            LOGGER.warn("Insecure configuration: Basic Credentials are configured to be used over a plain http connection for {}. Consider migrating to https to guard the credentials.", (Object)scopeDescription);
        } else if ("http".equals(theProtocol) && theToken != null) {
            LOGGER.warn("Insecure configuration: Bearer Credentials are configured to be used over a plain http connection for {}. Consider migrating to https to guard the credentials.", (Object)scopeDescription);
        } else if (!"https".equals(theProtocol)) {
            throw new InvalidSettingException("Unsupported protocol in the " + scopeDescription + " URL; only file, http and https are supported");
        }
        if (theToken != null) {
            HC5CredentialHelper.configurePreEmptiveBearerAuth(theURL, theToken, theCredentialsStore, theAuthCache);
        } else if (theUser != null && thePass != null) {
            HC5CredentialHelper.configurePreEmptiveBasicAuth(theURL, theUser, thePass, theCredentialsStore, theAuthCache);
        }
    }

    public void fetchFile(URL url, File outputPath) throws DownloadFailedException, TooManyRequestsException, ResourceNotFoundException, URLConnectionFailureException {
        this.fetchFile(url, outputPath, true);
    }

    public void fetchFile(URL url, File outputPath, boolean useProxy) throws DownloadFailedException, TooManyRequestsException, ResourceNotFoundException, URLConnectionFailureException {
        block12: {
            try {
                if ("file".equals(url.getProtocol())) {
                    Path p = Paths.get(url.toURI());
                    Files.copy(p, outputPath.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    break block12;
                }
                BasicClassicHttpRequest req = new BasicClassicHttpRequest(Method.GET, url.toURI());
                try (CloseableHttpClient hc = useProxy ? this.httpClientBuilder.build() : this.httpClientBuilderExplicitNoproxy.build();){
                    SaveToFileResponseHandler responseHandler = new SaveToFileResponseHandler(outputPath);
                    hc.execute((ClassicHttpRequest)req, (HttpContext)this.getPreEmptiveAuthContext(), (HttpClientResponseHandler)responseHandler);
                }
            }
            catch (HttpResponseException hre) {
                Downloader.wrapAndThrowHttpResponseException(url.toString(), hre);
            }
            catch (SSLHandshakeException ex) {
                if (ex.getMessage().contains("unable to find valid certification path to requested target")) {
                    String msg = String.format("Unable to connect to '%s' - the Java trust store does not contain a trusted root for the cert. Please see https://github.com/jeremylong/InstallCert for one method of updating the trusted certificates.", url);
                    throw new URLConnectionFailureException(msg, ex);
                }
                String msg = String.format("Download failed, unable to copy '%s' to '%s'; %s", url, outputPath.getAbsolutePath(), ex.getMessage());
                throw new DownloadFailedException(msg, ex);
            }
            catch (IOException | RuntimeException | URISyntaxException ex) {
                String msg = String.format("Download failed, unable to copy '%s' to '%s'; %s", url, outputPath.getAbsolutePath(), ex.getMessage());
                throw new DownloadFailedException(msg, ex);
            }
        }
    }

    private static void wrapAndThrowHttpResponseException(String url, HttpResponseException hre) throws ResourceNotFoundException, TooManyRequestsException, DownloadFailedException {
        String messageFormat = "%s - Server status: %d - Server reason: %s";
        switch (hre.getStatusCode()) {
            case 404: {
                throw new ResourceNotFoundException(String.format("%s - Server status: %d - Server reason: %s", url, hre.getStatusCode(), hre.getReasonPhrase()), hre);
            }
            case 429: {
                throw new TooManyRequestsException(String.format("%s - Server status: %d - Server reason: %s", url, hre.getStatusCode(), hre.getReasonPhrase()), hre);
            }
        }
        throw new DownloadFailedException(String.format("%s - Server status: %d - Server reason: %s", url, hre.getStatusCode(), hre.getReasonPhrase()), hre);
    }

    public void fetchFile(URL url, File outputPath, boolean useProxy, String userKey, String passwordKey, String tokenKey) throws DownloadFailedException, TooManyRequestsException, ResourceNotFoundException, URLConnectionFailureException {
        boolean tokenConfigured;
        boolean basicConfigured = userKey != null && this.settings.getString(userKey) != null && passwordKey != null && this.settings.getString(passwordKey) != null;
        boolean bl = tokenConfigured = tokenKey != null && this.settings.getString(tokenKey) != null;
        if ("file".equals(url.getProtocol()) || !basicConfigured && !tokenConfigured) {
            this.fetchFile(url, outputPath, useProxy);
            return;
        }
        String theProtocol = url.getProtocol();
        if (!"http".equals(theProtocol) && !"https".equals(theProtocol)) {
            throw new DownloadFailedException("Unsupported protocol in the URL; only file, http and https are supported");
        }
        try {
            HttpClientContext dedicatedAuthContext = HttpClientContext.create();
            SystemDefaultCredentialsProvider dedicatedCredentialStore = new SystemDefaultCredentialsProvider();
            BasicAuthCache dedicatedAuthCache = new BasicAuthCache();
            this.configureCredentials(url, url.toString(), userKey, passwordKey, tokenKey, (CredentialsStore)dedicatedCredentialStore, (AuthCache)dedicatedAuthCache);
            if (useProxy && this.proxyAuthScope != null) {
                this.tryConfigureProxyCredentials((CredentialsStore)dedicatedCredentialStore, (AuthCache)dedicatedAuthCache);
            }
            dedicatedAuthContext.setCredentialsProvider((CredentialsProvider)dedicatedCredentialStore);
            dedicatedAuthContext.setAuthCache((AuthCache)dedicatedAuthCache);
            try (CloseableHttpClient hc = useProxy ? this.httpClientBuilder.build() : this.httpClientBuilderExplicitNoproxy.build();){
                BasicClassicHttpRequest req = new BasicClassicHttpRequest(Method.GET, url.toURI());
                SaveToFileResponseHandler responseHandler = new SaveToFileResponseHandler(outputPath);
                hc.execute((ClassicHttpRequest)req, (HttpContext)dedicatedAuthContext, (HttpClientResponseHandler)responseHandler);
            }
        }
        catch (HttpResponseException hre) {
            Downloader.wrapAndThrowHttpResponseException(url.toString(), hre);
        }
        catch (SSLHandshakeException ex) {
            if (ex.getMessage().contains("unable to find valid certification path to requested target")) {
                String msg = String.format("Unable to connect to '%s' - the Java trust store does not contain a trusted root for the cert. Please see https://github.com/jeremylong/InstallCert for one method of updating the trusted certificates.", url);
                throw new URLConnectionFailureException(msg, ex);
            }
            String msg = String.format("Download failed, unable to copy '%s' to '%s'; %s", url, outputPath.getAbsolutePath(), ex.getMessage());
            throw new DownloadFailedException(msg, ex);
        }
        catch (IOException | RuntimeException | URISyntaxException ex) {
            String msg = String.format("Download failed, unable to copy '%s' to '%s'; %s", url, outputPath.getAbsolutePath(), ex.getMessage());
            throw new DownloadFailedException(msg, ex);
        }
    }

    private void tryConfigureProxyCredentials(@NotNull CredentialsStore credentialsProvider, @NotNull AuthCache authCache) {
        if (this.proxyPreEmptAuth != null) {
            credentialsProvider.setCredentials(this.proxyAuthScope, this.proxyCreds);
            authCache.put(this.proxyHttpHost, (AuthScheme)this.proxyPreEmptAuth);
        }
    }

    public String postBasedFetchContent(URI url, String payload, ContentType payloadType, List<Header> hdr) throws DownloadFailedException, TooManyRequestsException, ResourceNotFoundException, URLConnectionFailureException {
        try {
            String result;
            if (url.getScheme() == null || !url.getScheme().toLowerCase(Locale.ROOT).matches("^https?")) {
                throw new IllegalArgumentException("Unsupported protocol in the URL; only http and https are supported");
            }
            BasicClassicHttpRequest req = new BasicClassicHttpRequest(Method.POST, url);
            req.setEntity((HttpEntity)new StringEntity(payload, payloadType));
            for (Header h : hdr) {
                req.addHeader(h);
            }
            try (CloseableHttpClient hc = this.httpClientBuilder.build();){
                result = (String)hc.execute((ClassicHttpRequest)req, (HttpContext)this.getPreEmptiveAuthContext(), (HttpClientResponseHandler)new BasicHttpClientResponseHandler());
            }
            return result;
        }
        catch (HttpResponseException hre) {
            Downloader.wrapAndThrowHttpResponseException(url.toString(), hre);
            throw new InternalError("wrapAndThrowHttpResponseException will always throw an exception but Java compiler fails to spot it");
        }
        catch (SSLHandshakeException ex) {
            if (ex.getMessage().contains("unable to find valid certification path to requested target")) {
                String msg = String.format("Unable to connect to '%s' - the Java trust store does not contain a trusted root for the cert. Please see https://github.com/jeremylong/InstallCert for one method of updating the trusted certificates.", url);
                throw new URLConnectionFailureException(msg, ex);
            }
            String msg = String.format("Download failed, error downloading '%s'; %s", url, ex.getMessage());
            throw new DownloadFailedException(msg, ex);
        }
        catch (IOException | RuntimeException ex) {
            String msg = String.format("Download failed, error downloading '%s'; %s", url, ex.getMessage());
            throw new DownloadFailedException(msg, ex);
        }
    }

    public String fetchContent(URL url, Charset charset) throws DownloadFailedException, TooManyRequestsException, ResourceNotFoundException {
        return this.fetchContent(url, true, charset);
    }

    public String fetchContent(URL url, boolean useProxy, Charset charset) throws DownloadFailedException, TooManyRequestsException, ResourceNotFoundException {
        try {
            String result;
            if ("file".equals(url.getProtocol())) {
                Path p = Paths.get(url.toURI());
                result = Files.readString(p, charset);
            } else {
                BasicClassicHttpRequest req = new BasicClassicHttpRequest(Method.GET, url.toURI());
                try (CloseableHttpClient hc = useProxy ? this.httpClientBuilder.build() : this.httpClientBuilderExplicitNoproxy.build();){
                    req.addHeader("Accept-Charset", (Object)charset.name());
                    ExplicitCharsetToStringResponseHandler responseHandler = new ExplicitCharsetToStringResponseHandler(charset);
                    result = (String)hc.execute((ClassicHttpRequest)req, (HttpContext)this.getPreEmptiveAuthContext(), (HttpClientResponseHandler)responseHandler);
                }
            }
            return result;
        }
        catch (HttpResponseException hre) {
            Downloader.wrapAndThrowHttpResponseException(url.toString(), hre);
            throw new InternalError("wrapAndThrowHttpResponseException will always throw an exception but Java compiler fails to spot it");
        }
        catch (IOException | RuntimeException | URISyntaxException ex) {
            String msg = String.format("Download failed, error downloading '%s'; %s", url, ex.getMessage());
            throw new DownloadFailedException(msg, ex);
        }
    }

    public HttpClientContext getPreEmptiveAuthContext() {
        HttpClientContext context = HttpClientContext.create();
        context.setCredentialsProvider((CredentialsProvider)this.credentialsProvider);
        context.setAuthCache(this.authCache);
        return context;
    }

    public CloseableHttpClient getHttpClient(boolean useProxy) {
        return useProxy ? this.httpClientBuilder.build() : this.httpClientBuilderExplicitNoproxy.build();
    }

    public <T> T fetchAndHandle(@NotNull URL url, @NotNull HttpClientResponseHandler<T> handler) throws IOException, TooManyRequestsException, ResourceNotFoundException, URISyntaxException {
        return this.fetchAndHandle(url, handler, Collections.emptyList(), true);
    }

    public <T> T fetchAndHandle(@NotNull URL url, @NotNull HttpClientResponseHandler<T> handler, @NotNull List<Header> hdr) throws IOException, TooManyRequestsException, ResourceNotFoundException, URISyntaxException {
        return this.fetchAndHandle(url, handler, hdr, true);
    }

    public <T> T fetchAndHandle(@NotNull URL url, @NotNull HttpClientResponseHandler<T> handler, @NotNull List<Header> hdr, boolean useProxy) throws IOException, TooManyRequestsException, ResourceNotFoundException, URISyntaxException {
        Object data;
        block15: {
            if ("file".equals(url.getProtocol())) {
                Path p = Paths.get(url.toURI());
                try (InputStream is = Files.newInputStream(p, new OpenOption[0]);){
                    BasicHttpEntity dummyEntity = new BasicHttpEntity(is, ContentType.APPLICATION_JSON);
                    BasicClassicHttpResponse dummyResponse = new BasicClassicHttpResponse(200);
                    dummyResponse.setEntity((HttpEntity)dummyEntity);
                    data = handler.handleResponse((ClassicHttpResponse)dummyResponse);
                    break block15;
                }
                catch (HttpException e) {
                    throw new IllegalStateException("HttpException encountered emulating a HTTP response from a file", e);
                }
            }
            try (CloseableHttpClient hc = useProxy ? this.httpClientBuilder.build() : this.httpClientBuilderExplicitNoproxy.build();){
                T t = this.fetchAndHandle(hc, url, handler, hdr);
                return t;
            }
        }
        return (T)data;
    }

    public <T> T fetchAndHandle(@NotNull CloseableHttpClient client, @NotNull URL url, @NotNull HttpClientResponseHandler<T> handler, @NotNull List<Header> hdr) throws IOException, TooManyRequestsException, ResourceNotFoundException {
        try {
            String theProtocol = url.getProtocol();
            if (!"http".equals(theProtocol) && !"https".equals(theProtocol)) {
                throw new DownloadFailedException("Unsupported protocol in the URL; only http and https are supported");
            }
            BasicClassicHttpRequest req = new BasicClassicHttpRequest(Method.GET, url.toURI());
            for (Header h : hdr) {
                req.addHeader(h);
            }
            HttpClientContext context = this.getPreEmptiveAuthContext();
            return (T)client.execute((ClassicHttpRequest)req, (HttpContext)context, handler);
        }
        catch (HttpResponseException hre) {
            String messageFormat = "%s - Server status: %d - Server reason: %s";
            switch (hre.getStatusCode()) {
                case 404: {
                    throw new ResourceNotFoundException(String.format("%s - Server status: %d - Server reason: %s", url, hre.getStatusCode(), hre.getReasonPhrase()));
                }
                case 429: {
                    throw new TooManyRequestsException(String.format("%s - Server status: %d - Server reason: %s", url, hre.getStatusCode(), hre.getReasonPhrase()));
                }
            }
            throw new IOException(String.format("%s - Server status: %d - Server reason: %s", url, hre.getStatusCode(), hre.getReasonPhrase()));
        }
        catch (RuntimeException | URISyntaxException ex) {
            String msg = String.format("Download failed, unable to retrieve and parse '%s'; %s", url, ex.getMessage());
            throw new IOException(msg, ex);
        }
    }

    private static class SelectiveProxySelector
    extends ProxySelector {
        private final List<String> suffixMatch = new ArrayList<String>();
        private final List<String> fullmatch = new ArrayList<String>();
        private final Proxy configuredProxy;

        SelectiveProxySelector(Proxy httpHost, String[] nonProxyHostsPatterns) {
            for (String nonProxyHostPattern : nonProxyHostsPatterns) {
                if (nonProxyHostPattern.startsWith("*")) {
                    this.suffixMatch.add(nonProxyHostPattern.substring(1));
                    continue;
                }
                this.fullmatch.add(nonProxyHostPattern);
            }
            this.configuredProxy = httpHost;
        }

        @Override
        public List<Proxy> select(URI uri) {
            String theHost = uri.getHost();
            if (this.fullmatch.contains(theHost)) {
                return Collections.singletonList(Proxy.NO_PROXY);
            }
            for (String suffix : this.suffixMatch) {
                if (!theHost.endsWith(suffix)) continue;
                return Collections.singletonList(Proxy.NO_PROXY);
            }
            return List.of(this.configuredProxy);
        }

        @Override
        public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        }
    }
}

