/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.authorization;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.pac4j.core.authorization.AuthorizationChecker;
import org.pac4j.core.authorization.Authorizer;
import org.pac4j.core.authorization.authorizer.CacheControlHeader;
import org.pac4j.core.authorization.authorizer.StrictTransportSecurityHeader;
import org.pac4j.core.authorization.authorizer.XContentTypeOptionsHeader;
import org.pac4j.core.authorization.authorizer.XFrameOptionsHeader;
import org.pac4j.core.authorization.authorizer.XSSProtectionHeader;
import org.pac4j.core.authorization.authorizer.csrf.CsrfAuthorizer;
import org.pac4j.core.authorization.authorizer.csrf.CsrfTokenGeneratorAuthorizer;
import org.pac4j.core.authorization.authorizer.csrf.DefaultCsrfTokenGenerator;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.util.CommonHelper;

public class DefaultAuthorizationChecker
implements AuthorizationChecker {
    static final StrictTransportSecurityHeader STRICT_TRANSPORT_SECURITY_HEADER = new StrictTransportSecurityHeader();
    static final XContentTypeOptionsHeader X_CONTENT_TYPE_OPTIONS_HEADER = new XContentTypeOptionsHeader();
    static final XFrameOptionsHeader X_FRAME_OPTIONS_HEADER = new XFrameOptionsHeader();
    static final XSSProtectionHeader XSS_PROTECTION_HEADER = new XSSProtectionHeader();
    static final CacheControlHeader CACHE_CONTROL_HEADER = new CacheControlHeader();
    static final CsrfAuthorizer CSRF_AUTHORIZER = new CsrfAuthorizer();
    static final CsrfTokenGeneratorAuthorizer CSRF_TOKEN_GENERATOR_AUTHORIZER = new CsrfTokenGeneratorAuthorizer(new DefaultCsrfTokenGenerator());

    @Override
    public boolean isAuthorized(WebContext context, UserProfile profile, String authorizerName, Map<String, Authorizer> authorizersMap) {
        ArrayList<Authorizer> authorizers = new ArrayList<Authorizer>();
        if (CommonHelper.isNotBlank(authorizerName)) {
            for (String name : authorizerName.split(",")) {
                if ("hsts".equalsIgnoreCase(name)) {
                    authorizers.add(STRICT_TRANSPORT_SECURITY_HEADER);
                    continue;
                }
                if ("nosniff".equalsIgnoreCase(name)) {
                    authorizers.add(X_CONTENT_TYPE_OPTIONS_HEADER);
                    continue;
                }
                if ("noframe".equalsIgnoreCase(name)) {
                    authorizers.add(X_FRAME_OPTIONS_HEADER);
                    continue;
                }
                if ("xssprotection".equalsIgnoreCase(name)) {
                    authorizers.add(XSS_PROTECTION_HEADER);
                    continue;
                }
                if ("nocache".equalsIgnoreCase(name)) {
                    authorizers.add(CACHE_CONTROL_HEADER);
                    continue;
                }
                if ("securityheaders".equalsIgnoreCase(name)) {
                    authorizers.add(CACHE_CONTROL_HEADER);
                    authorizers.add(X_CONTENT_TYPE_OPTIONS_HEADER);
                    authorizers.add(STRICT_TRANSPORT_SECURITY_HEADER);
                    authorizers.add(X_FRAME_OPTIONS_HEADER);
                    authorizers.add(XSS_PROTECTION_HEADER);
                    continue;
                }
                if ("csrfToken".equalsIgnoreCase(name)) {
                    authorizers.add(CSRF_TOKEN_GENERATOR_AUTHORIZER);
                    continue;
                }
                if ("csrfCheck".equalsIgnoreCase(name)) {
                    authorizers.add(CSRF_AUTHORIZER);
                    continue;
                }
                if ("csrf".equalsIgnoreCase(name)) {
                    authorizers.add(CSRF_TOKEN_GENERATOR_AUTHORIZER);
                    authorizers.add(CSRF_AUTHORIZER);
                    continue;
                }
                CommonHelper.assertNotNull("authorizersMap", authorizersMap);
                Authorizer result = authorizersMap.get(name);
                CommonHelper.assertNotNull("authorizersMap['" + name + "']", result);
                authorizers.add(result);
            }
        }
        return this.isAuthorized(context, profile, authorizers);
    }

    @Override
    public boolean isAuthorized(WebContext context, UserProfile profile, List<Authorizer> authorizers) {
        CommonHelper.assertNotNull("profile", profile);
        if (authorizers != null && !authorizers.isEmpty()) {
            for (Authorizer authorizer : authorizers) {
                if (authorizer.isAuthorized(context, profile)) continue;
                return false;
            }
        }
        return true;
    }
}

