/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.authorization.authorizer.csrf;

import org.pac4j.core.authorization.Authorizer;
import org.pac4j.core.context.ContextHelper;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.util.CommonHelper;

public class CsrfAuthorizer<U extends UserProfile>
implements Authorizer<U> {
    private String parameterName = "pac4jCsrfToken";
    private String headerName = "pac4jCsrfToken";
    private boolean onlyCheckPostRequest = true;

    public CsrfAuthorizer() {
    }

    public CsrfAuthorizer(String parameterName, String headerName) {
        this.parameterName = parameterName;
        this.headerName = headerName;
    }

    public CsrfAuthorizer(String parameterName, String headerName, boolean onlyCheckPostRequest) {
        this(parameterName, headerName);
        this.onlyCheckPostRequest = onlyCheckPostRequest;
    }

    @Override
    public boolean isAuthorized(WebContext context, U profile) {
        boolean checkRequest;
        boolean bl = checkRequest = !this.onlyCheckPostRequest || this.onlyCheckPostRequest && ContextHelper.isPost(context);
        if (checkRequest) {
            String parameterToken = context.getRequestParameter(this.parameterName);
            String headerToken = context.getRequestHeader(this.headerName);
            String sessionToken = (String)context.getSessionAttribute("pac4jCsrfToken");
            return CommonHelper.areEquals(parameterToken, sessionToken) || CommonHelper.areEquals(headerToken, sessionToken);
        }
        return true;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    public boolean isOnlyCheckPostRequest() {
        return this.onlyCheckPostRequest;
    }

    public void setOnlyCheckPostRequest(boolean onlyCheckPostRequest) {
        this.onlyCheckPostRequest = onlyCheckPostRequest;
    }
}

