/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.authorization.authorizer.csrf;

import org.pac4j.core.authorization.Authorizer;
import org.pac4j.core.authorization.authorizer.csrf.CsrfTokenGenerator;
import org.pac4j.core.context.Cookie;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.util.CommonHelper;

public class CsrfTokenGeneratorAuthorizer
implements Authorizer<UserProfile> {
    private final CsrfTokenGenerator csrfTokenGenerator;

    public CsrfTokenGeneratorAuthorizer(CsrfTokenGenerator csrfTokenGenerator) {
        this.csrfTokenGenerator = csrfTokenGenerator;
    }

    @Override
    public boolean isAuthorized(WebContext context, UserProfile profile) {
        CommonHelper.assertNotNull("csrfTokenGenerator", this.csrfTokenGenerator);
        String token = this.csrfTokenGenerator.get(context);
        context.setRequestAttribute("pac4jCsrfToken", token);
        Cookie cookie = new Cookie("pac4jCsrfToken", token);
        cookie.setDomain(context.getServerName());
        context.addResponseCookie(cookie);
        return true;
    }
}

