/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.pac4j.core.authorization.AuthorizationGenerator;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.ClientType;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.InitializableWebObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseClient<C extends Credentials, U extends CommonProfile>
extends InitializableWebObject
implements Client<C, U>,
Cloneable {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String name;
    private List<AuthorizationGenerator<U>> authorizationGenerators = new ArrayList<AuthorizationGenerator<U>>();

    public BaseClient<C, U> clone() {
        BaseClient<C, U> newClient = this.newClient();
        newClient.setName(this.name);
        return newClient;
    }

    protected abstract BaseClient<C, U> newClient();

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        if (CommonHelper.isBlank(this.name)) {
            return this.getClass().getSimpleName();
        }
        return this.name;
    }

    @Override
    public final U getUserProfile(C credentials, WebContext context) {
        this.init(context);
        this.logger.debug("credentials : {}", credentials);
        if (credentials == null) {
            return null;
        }
        U profile = this.retrieveUserProfile(credentials, context);
        if (this.authorizationGenerators != null) {
            for (AuthorizationGenerator<U> authorizationGenerator : this.authorizationGenerators) {
                authorizationGenerator.generate(profile);
            }
        }
        return profile;
    }

    protected abstract U retrieveUserProfile(C var1, WebContext var2);

    public abstract ClientType getClientType();

    public String toString() {
        return CommonHelper.toString(this.getClass(), "name", this.getName());
    }

    public void addAuthorizationGenerator(AuthorizationGenerator<U> authorizationGenerator) {
        CommonHelper.assertNotNull("authorizationGenerator", authorizationGenerator);
        this.authorizationGenerators.add(authorizationGenerator);
    }

    public List<AuthorizationGenerator<U>> getAuthorizationGenerators() {
        return this.authorizationGenerators;
    }

    public void setAuthorizationGenerators(List<AuthorizationGenerator<U>> authorizationGenerators) {
        CommonHelper.assertNotNull("authorizationGenerators", authorizationGenerators);
        this.authorizationGenerators = authorizationGenerators;
    }

    public void setAuthorizationGenerators(AuthorizationGenerator<U> ... authorizationGenerators) {
        CommonHelper.assertNotNull("authorizationGenerators", authorizationGenerators);
        this.authorizationGenerators = Arrays.asList(authorizationGenerators);
    }

    public void setAuthorizationGenerator(AuthorizationGenerator<U> authorizationGenerator) {
        this.addAuthorizationGenerator(authorizationGenerator);
    }
}

