/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.matching;

import java.util.regex.Pattern;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.matching.Matcher;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExcludedPathMatcher
implements Matcher {
    private static final Logger logger = LoggerFactory.getLogger(ExcludedPathMatcher.class);
    private String excludePath;
    private Pattern pattern;

    public ExcludedPathMatcher() {
    }

    public ExcludedPathMatcher(String excludePath) {
        this.setExcludePath(excludePath);
    }

    @Override
    public boolean matches(WebContext context) {
        if (this.pattern != null) {
            String path = context.getPath();
            logger.debug("path to match: {}", (Object)path);
            return !this.pattern.matcher(path).matches();
        }
        return true;
    }

    public String getExcludePath() {
        return this.excludePath;
    }

    public void setExcludePath(String excludePath) {
        this.excludePath = excludePath;
        if (CommonHelper.isNotBlank(excludePath)) {
            logger.warn("Excluding paths is an advanced feature: be careful when defining your regular expression to avoid any security issue!");
            if (!excludePath.startsWith("^") || !excludePath.endsWith("$")) {
                String msg = "Your regular expression: '" + excludePath + "' must start with a ^ and ends with a $ to define a full path matching";
                logger.error(msg);
                throw new TechnicalException(msg);
            }
            this.pattern = Pattern.compile(excludePath);
        }
    }
}

