/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.profile;

import java.lang.reflect.Constructor;
import java.util.Map;
import org.pac4j.core.profile.RawDataObject;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProfileHelper {
    private static final Logger logger = LoggerFactory.getLogger(ProfileHelper.class);
    private static boolean enforceProfileDefinition = false;

    public static boolean isTypedIdOf(String id, Class<? extends UserProfile> clazz) {
        return id != null && clazz != null && id.startsWith(clazz.getSimpleName() + "#");
    }

    public static UserProfile buildProfile(String typedId, Map<String, Object> attributes) {
        if (CommonHelper.isBlank(typedId)) {
            return null;
        }
        logger.info("Building user profile based on typedId {}", (Object)typedId);
        try {
            String[] values = typedId.split("#");
            if (values.length >= 1) {
                String className = values[0];
                String completeName = ProfileHelper.determineProfileClassByName(className);
                return ProfileHelper.buildUserProfileByClassCompleteName(typedId, attributes, completeName);
            }
        }
        catch (Exception e) {
            logger.error("Cannot build instance", (Throwable)e);
        }
        return null;
    }

    private static String determineProfileClassByName(String className) {
        String completeName;
        if ("CasProfile".equals(className) || "CasProxyProfile".equals(className)) {
            completeName = "org.pac4j.cas.profile." + className;
        } else if ("HttpTGTProfile".equals(className)) {
            completeName = "org.pac4j.cas.profile.HttpTGTProfile";
        } else if ("SAML2Profile".equals(className)) {
            completeName = "org.pac4j.saml.profile.SAML2Profile";
        } else if ("HttpProfile".equals(className)) {
            completeName = "org.pac4j.http.profile.HttpProfile";
        } else if ("OidcProfile".equals(className)) {
            completeName = "org.pac4j.oidc.profile.OidcProfile";
        } else if ("LdapProfile".equals(className)) {
            completeName = "org.pac4j.ldap.profile.LdapProfile";
        } else if ("DbProfile".equals(className)) {
            completeName = "org.pac4j.sql.profile.DbProfile";
        } else if ("MongoProfile".equals(className)) {
            completeName = "org.pac4j.mongo.profile.MongoProfile";
        } else if ("YahooOpenIdProfile".equals(className)) {
            completeName = "org.pac4j.openid.profile.yahoo.YahooOpenIdProfile";
        } else if ("GaeUserServiceProfile".equals(className)) {
            completeName = "org.pac4j.gae.profile.GaeUserServiceProfile";
        } else if ("StormpathProfile".equals(className)) {
            completeName = "org.pac4j.stormpath.profile.StormpathProfile";
        } else if ("JwtProfile".equals(className)) {
            completeName = "org.pac4j.jwt.profile.JwtProfile";
        } else {
            String packageName = className.substring(0, className.length() - 7).toLowerCase();
            completeName = "org.pac4j.oauth.profile." + packageName + '.' + className;
        }
        return completeName;
    }

    public static UserProfile buildUserProfileByClassCompleteName(String typedId, Map<String, Object> attributes, String completeName) throws Exception {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        Constructor<?> constructor = tccl == null ? Class.forName(completeName).getDeclaredConstructor(new Class[0]) : Class.forName(completeName, true, tccl).getDeclaredConstructor(new Class[0]);
        UserProfile userProfile = (UserProfile)constructor.newInstance(new Object[0]);
        userProfile.build(typedId, attributes);
        logger.debug("userProfile built : {}", (Object)userProfile);
        return userProfile;
    }

    public static void setKeepRawData(boolean keepRawData) {
        RawDataObject.setKeepRawData(keepRawData);
    }

    public static boolean isEnforceProfileDefinition() {
        return enforceProfileDefinition;
    }

    public static void setEnforceProfileDefinition(boolean enforceProfileDefinition) {
        ProfileHelper.enforceProfileDefinition = enforceProfileDefinition;
    }
}

