/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.credentials.extractor;

import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.http.credentials.TokenCredentials;
import org.pac4j.http.credentials.extractor.Extractor;

public class ParameterExtractor
implements Extractor<TokenCredentials> {
    private final String parameterName;
    private final String clientName;
    private boolean supportGetRequest;
    private boolean supportPostRequest;

    public ParameterExtractor(String parameterName, String clientName) {
        this(parameterName, false, true, clientName);
    }

    public ParameterExtractor(String parameterName, boolean supportGetRequest, boolean supportPostRequest, String clientName) {
        this.parameterName = parameterName;
        this.supportGetRequest = supportGetRequest;
        this.supportPostRequest = supportPostRequest;
        this.clientName = clientName;
    }

    @Override
    public TokenCredentials extract(WebContext context) {
        String method = context.getRequestMethod();
        if ("GET".equals(method) && !this.supportGetRequest) {
            throw new CredentialsException("GET requests not supported");
        }
        if ("POST".equals(method) && !this.supportPostRequest) {
            throw new CredentialsException("POST requests not supported");
        }
        String value = context.getRequestParameter(this.parameterName);
        if (value == null) {
            return null;
        }
        return new TokenCredentials(value, this.clientName);
    }
}

